/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationErrorResponse;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationResponse;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.UrlUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.util.Map;

public class AzureActiveDirectoryAuthorizationResultFactory
extends AuthorizationResultFactory<AzureActiveDirectoryAuthorizationResult, AzureActiveDirectoryAuthorizationRequest> {
    private static final String TAG = AzureActiveDirectoryAuthorizationResultFactory.class.getSimpleName();

    @Override
    protected AzureActiveDirectoryAuthorizationResult createAuthorizationResultWithErrorResponse(AuthorizationStatus authStatus, @NonNull String error, @Nullable String errorDescription) {
        AzureActiveDirectoryAuthorizationErrorResponse errorResponse = new AzureActiveDirectoryAuthorizationErrorResponse(error, errorDescription);
        return new AzureActiveDirectoryAuthorizationResult(authStatus, errorResponse);
    }

    @Override
    protected AzureActiveDirectoryAuthorizationResult parseRedirectUriAndCreateAuthorizationResult(@NonNull URI redirectUri, @Nullable String requestStateParameter) {
        Map<String, String> urlParameters = UrlUtil.getParameters(redirectUri);
        if (urlParameters == null || urlParameters.isEmpty()) {
            Logger.warn(TAG, "Invalid server response, empty query string from the webview redirect.");
            return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response.");
        }
        String correlationInResponse = urlParameters.get("correlation_id");
        AuthorizationResult result = urlParameters.containsKey("code") ? this.validateAndCreateAuthorizationResult((Map)urlParameters, requestStateParameter, correlationInResponse) : (urlParameters.containsKey("error") ? this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, urlParameters.get("error"), urlParameters.get("error_description"), urlParameters.get("error_codes"), correlationInResponse) : this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response."));
        return result;
    }

    private AzureActiveDirectoryAuthorizationResult createAuthorizationResultWithErrorResponse(@NonNull AuthorizationStatus authStatus, @Nullable String error, @Nullable String errorDescription, @Nullable String errorCodes, @Nullable String correlationId) {
        Logger.info(TAG, correlationId, "Error is returned from webview redirect");
        Logger.infoPII(TAG, correlationId, "error: " + error + " errorDescription: " + errorDescription);
        AzureActiveDirectoryAuthorizationErrorResponse errorResponse = new AzureActiveDirectoryAuthorizationErrorResponse(error, errorDescription);
        errorResponse.setErrorCodes(errorCodes);
        return new AzureActiveDirectoryAuthorizationResult(authStatus, errorResponse);
    }

    @Override
    protected AzureActiveDirectoryAuthorizationResult validateAndCreateAuthorizationResult(@NonNull Map<String, String> urlParameters, @Nullable String requestStateParameter, @Nullable String correlationId) {
        AzureActiveDirectoryAuthorizationResult result;
        String state = urlParameters.get("state");
        String code = urlParameters.get("code");
        if (StringUtil.isNullOrEmpty(state)) {
            Logger.warn(TAG, correlationId, "State parameter is not returned from the webview redirect.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "State is not returned");
        } else if (StringUtil.isNullOrEmpty(requestStateParameter) || !requestStateParameter.equals(state)) {
            Logger.warn(TAG, correlationId, "State parameter returned from the redirect is not same as the one sent in request.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "Returned state from authorize endpoint is not the same as the one sent");
        } else {
            Logger.info(TAG, correlationId, "Auth code is successfully returned from webview redirect.");
            AzureActiveDirectoryAuthorizationResponse response = new AzureActiveDirectoryAuthorizationResponse(code, state);
            response.setCorrelationId(correlationId);
            result = new AzureActiveDirectoryAuthorizationResult(AuthorizationStatus.SUCCESS, response);
        }
        return result;
    }
}

