/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry.adapter;

import com.microsoft.identity.common.java.telemetry.adapter.ITelemetryAdapter;
import com.microsoft.identity.common.java.telemetry.observers.ITelemetryAggregatedObserver;
import com.microsoft.identity.common.java.telemetry.rules.TelemetryAggregationRules;
import com.microsoft.identity.common.java.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class TelemetryAggregationAdapter
implements ITelemetryAdapter<List<Map<String, String>>> {
    private ITelemetryAggregatedObserver mObserver;
    private static final String START = "start";
    private static final String END = "end";

    public TelemetryAggregationAdapter(@NonNull ITelemetryAggregatedObserver observer) {
        if (observer == null) {
            throw new NullPointerException("observer is marked non-null but is null");
        }
        this.mObserver = observer;
    }

    public ITelemetryAggregatedObserver getObserver() {
        return this.mObserver;
    }

    @Override
    public void process(@NonNull List<Map<String, String>> rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData is marked non-null but is null");
        }
        HashMap<String, String> aggregatedData = new HashMap<String, String>();
        HashMap<String, String> responseTimeMap = new HashMap<String, String>();
        for (Map<String, String> event : rawData) {
            String eventName = event.get("Microsoft.MSAL.event_name");
            String eventType = event.get("Microsoft.MSAL.event_type");
            if (StringUtil.isNullOrEmpty(eventName)) {
                aggregatedData.putAll(this.applyAggregationRule(event));
                continue;
            }
            if (eventName.contains(START)) {
                String eventTypeCountKey = eventType + "_count";
                String currentEventTypeCount = (String)aggregatedData.get(eventTypeCountKey);
                int currentEventTypeCountValue = Integer.parseInt(currentEventTypeCount == null ? "0" : currentEventTypeCount);
                int newEventTypeCountValue = currentEventTypeCountValue + 1;
                aggregatedData.put(eventTypeCountKey, String.valueOf(newEventTypeCountValue));
            }
            if (!StringUtil.isNullOrEmpty(event.get("_is_successful"))) {
                aggregatedData.put(eventType + "_is_successful", event.get("_is_successful"));
            }
            this.trackEventResponseTime(responseTimeMap, event);
            aggregatedData.putAll(this.applyAggregationRule(event));
        }
        this.calculateEventResponseTime(responseTimeMap, aggregatedData);
        this.mObserver.onReceived((Map<String, String>)aggregatedData);
    }

    private Map<String, String> applyAggregationRule(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        HashMap<String, String> nonPiiProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (StringUtil.isNullOrEmpty(entry.getValue()) || TelemetryAggregationRules.getInstance().isRedundant(entry.getKey())) continue;
            nonPiiProperties.put(entry.getKey(), entry.getValue());
        }
        return nonPiiProperties;
    }

    private void trackEventResponseTime(@NonNull Map<String, String> responseTimeMap, @NonNull Map<String, String> event) {
        if (responseTimeMap == null) {
            throw new NullPointerException("responseTimeMap is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        String eventName = event.get("Microsoft.MSAL.event_name");
        String eventType = event.get("Microsoft.MSAL.event_type");
        if (eventName != null && eventName.contains(START)) {
            String eventStartTime = eventType + "_start_time";
            responseTimeMap.put(eventStartTime, event.get("Microsoft.MSAL.occur_time"));
        }
        if (eventName != null && eventName.contains(END)) {
            String eventEndTime = eventType + "_end_time";
            responseTimeMap.put(eventEndTime, event.get("Microsoft.MSAL.occur_time"));
        }
    }

    private void calculateEventResponseTime(@NonNull Map<String, String> responseTimeMap, @NonNull Map<String, String> aggregatedData) {
        if (responseTimeMap == null) {
            throw new NullPointerException("responseTimeMap is marked non-null but is null");
        }
        if (aggregatedData == null) {
            throw new NullPointerException("aggregatedData is marked non-null but is null");
        }
        for (Map.Entry<String, String> entry : responseTimeMap.entrySet()) {
            String eventEndTimeKey;
            String eventEndTimeValue;
            String entryKey = entry.getKey();
            if (!entryKey.contains(START) || (eventEndTimeValue = responseTimeMap.get(eventEndTimeKey = entryKey.replace(START, END))) == null) continue;
            String eventResponseTimeKey = entryKey.replace(START, "response");
            long startTime = Long.parseLong(entry.getValue());
            long endTime = Long.parseLong(eventEndTimeValue);
            aggregatedData.put(eventResponseTimeKey, String.valueOf(endTime - startTime));
        }
    }
}

