/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry.events;

import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.telemetry.Properties;
import lombok.NonNull;

public class BaseEvent
extends Properties {
    public BaseEvent() {
        this.occurs(System.currentTimeMillis());
        this.correlationId((String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id"));
    }

    @Override
    public Properties put(String key, String value) {
        return super.put(key, value);
    }

    @Override
    public Properties remove(String key) {
        return super.remove(key);
    }

    @Override
    public Properties remove(String key, String value) {
        return super.remove(key, value);
    }

    @Override
    public Properties put(Properties appendProperties) {
        return super.put(appendProperties);
    }

    public BaseEvent names(@NonNull String eventName) {
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        this.put("Microsoft.MSAL.event_name", eventName);
        return this;
    }

    public BaseEvent types(@NonNull String eventType) {
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        this.put("Microsoft.MSAL.event_type", eventType);
        return this;
    }

    public BaseEvent occurs(Long eventStartTime) {
        if (null == eventStartTime) {
            this.put("Microsoft.MSAL.occur_time", String.valueOf(System.currentTimeMillis()));
        } else {
            this.put("Microsoft.MSAL.occur_time", eventStartTime.toString());
        }
        return this;
    }

    public BaseEvent correlationId(String correlationId) {
        this.put("Microsoft.MSAL.correlation_id", correlationId);
        return this;
    }
}

