/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry.rules;

import com.microsoft.identity.common.java.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public final class TelemetryPiiOiiRules {
    private static TelemetryPiiOiiRules sInstance;
    private Set<String> piiPropertiesSet;
    private Set<String> oiiPropertiesSet;
    private final String[] piiArray = new String[]{"Microsoft.MSAL.user_id", "Microsoft.MSAL.device_id", "Microsoft.MSAL.login_hint", "Microsoft.MSAL.error_description", "Microsoft.MSAL.query_params", "Microsoft.MSAL.redirect_uri", "Microsoft.MSAL.scope_value", "Microsoft.MSAL.claim_request"};
    private final String[] oiiArray = new String[]{"Microsoft.MSAL.tenant_id", "Microsoft.MSAL.client_id", "Microsoft.MSAL.redirect_uri", "Microsoft.MSAL.http_path", "Microsoft.MSAL.authority", "Microsoft.MSAL.idp"};

    private TelemetryPiiOiiRules() {
        this.piiPropertiesSet = new HashSet<String>(Arrays.asList(this.piiArray));
        this.oiiPropertiesSet = new HashSet<String>(Arrays.asList(this.oiiArray));
    }

    @NonNull
    public static synchronized TelemetryPiiOiiRules getInstance() {
        if (sInstance == null) {
            sInstance = new TelemetryPiiOiiRules();
        }
        return sInstance;
    }

    public boolean isPii(String propertyName) {
        if (StringUtil.isNullOrEmpty(propertyName)) {
            return false;
        }
        return this.piiPropertiesSet.contains(propertyName);
    }

    public boolean isOii(String propertyName) {
        if (StringUtil.isNullOrEmpty(propertyName)) {
            return false;
        }
        return this.oiiPropertiesSet.contains(propertyName);
    }

    public boolean isPiiOrOii(String propertyName) {
        return this.isPii(propertyName) || this.isOii(propertyName);
    }
}

