/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authorities;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.authorities.ActiveDirectoryFederationServicesAuthority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.java.authorities.CIAMAuthority;
import com.microsoft.identity.common.java.authorities.UnknownAuthority;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;

public abstract class Authority {
    private static final String TAG = Authority.class.getSimpleName();
    private static final String ADFS_PATH_SEGMENT = "adfs";
    private static final String B2C_PATH_SEGMENT = "tfp";
    public static final String B2C = "B2C";
    public static final String CIAM = "CIAM";
    @SerializedName(value="default")
    protected boolean mIsDefault = false;
    @SerializedName(value="type")
    protected String mAuthorityTypeString;
    @SerializedName(value="authority_url")
    protected String mAuthorityUrlString;
    @SerializedName(value="slice")
    public AzureActiveDirectorySlice mSlice;
    private static final List<Authority> knownAuthorities = new ArrayList<Authority>();
    private static final Object sLock = new Object();

    public AzureActiveDirectorySlice getSlice() {
        return this.mSlice;
    }

    public void setSlice(AzureActiveDirectorySlice slice) {
        this.mSlice = slice;
    }

    public URI getAuthorityUri() {
        try {
            return new URI(this.mAuthorityUrlString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Authority URL is not a URI.", e);
        }
    }

    public URL getAuthorityURL() {
        try {
            return this.getAuthorityUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Authority URI is not a URL.", e);
        }
    }

    public boolean getDefault() {
        return this.mIsDefault;
    }

    public String getAuthorityTypeString() {
        return this.mAuthorityTypeString;
    }

    public void setDefault(Boolean isDefault) {
        this.mIsDefault = isDefault;
    }

    @SuppressFBWarnings(value={"RpC_REPEATED_CONDITIONAL_TEST"}, justification="Somehow, spotbugs thinks that BuildConfig.SLICE and BuildConfig.DC are the same values.")
    public Authority() {
        if (!StringUtil.isNullOrEmpty("") || !StringUtil.isNullOrEmpty("")) {
            AzureActiveDirectorySlice slice = new AzureActiveDirectorySlice();
            slice.setSlice("");
            slice.setDataCenter("");
            this.mSlice = slice;
        }
    }

    public static Authority getAuthorityFromAuthorityUrl(String authorityUrl) {
        CommonURIBuilder authorityCommonUriBuilder;
        String methodName = ":getAuthorityFromAuthorityUrl";
        try {
            authorityCommonUriBuilder = new CommonURIBuilder(authorityUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid authority URL");
        }
        List pathSegments = authorityCommonUriBuilder.getPathSegments();
        if (pathSegments.size() == 0 || pathSegments.size() == 1 && ((String)pathSegments.get(0)).equals("")) {
            if (authorityUrl.contains("ciamlogin.com")) {
                return new CIAMAuthority(CIAMAuthority.getFullAuthorityUrlFromAuthorityWithoutPath(authorityUrl));
            }
            return new UnknownAuthority();
        }
        Authority authority = null;
        if (Authority.authorityIsKnownFromConfiguration(authorityUrl)) {
            Authority configuredAuthority = Authority.getEquivalentConfiguredAuthority(authorityUrl);
            String authorityTypeStr = configuredAuthority.mAuthorityTypeString;
            authority = B2C.equalsIgnoreCase(authorityTypeStr) ? new AzureActiveDirectoryB2CAuthority(authorityUrl) : (CIAM.equalsIgnoreCase(authorityTypeStr) ? new CIAMAuthority(authorityUrl) : Authority.createAadAuthority(authorityCommonUriBuilder, pathSegments));
        } else {
            String authorityType = ((String)pathSegments.get(0)).toLowerCase(Locale.ROOT);
            if (authorityType.equals(ADFS_PATH_SEGMENT)) {
                Logger.verbose(TAG + ":getAuthorityFromAuthorityUrl", "Authority type is ADFS");
                authority = new ActiveDirectoryFederationServicesAuthority(authorityUrl);
            } else if (authorityType.equals(B2C_PATH_SEGMENT)) {
                Logger.verbose(TAG + ":getAuthorityFromAuthorityUrl", "Authority type is B2C");
                authority = new AzureActiveDirectoryB2CAuthority(authorityUrl);
            } else if (authorityUrl.contains("ciamlogin.com")) {
                Logger.verbose(TAG + ":getAuthorityFromAuthorityUrl", "Authority type is CIAM");
                authority = new CIAMAuthority(authorityUrl);
            } else {
                Logger.verbose(TAG + ":getAuthorityFromAuthorityUrl", "Authority type default: AAD");
                authority = Authority.createAadAuthority(authorityCommonUriBuilder, pathSegments);
            }
        }
        return authority;
    }

    @Nullable
    private static Authority getEquivalentConfiguredAuthority(@NonNull String authorityStr) {
        if (authorityStr == null) {
            throw new NullPointerException("authorityStr is marked non-null but is null");
        }
        Authority result = null;
        try {
            URL authorityUrl = new URL(authorityStr);
            String httpAuthority = authorityUrl.getAuthority();
            for (Authority currentAuthority : knownAuthorities) {
                URL currentAuthorityUrl;
                String currentHttpAuthority;
                if (StringUtil.isNullOrEmpty(currentAuthority.mAuthorityUrlString) || !httpAuthority.equalsIgnoreCase(currentHttpAuthority = (currentAuthorityUrl = new URL(currentAuthority.mAuthorityUrlString)).getAuthority())) continue;
                result = currentAuthority;
                break;
            }
        }
        catch (MalformedURLException e) {
            Logger.errorPII(TAG, "Error parsing authority", e);
        }
        return result;
    }

    private static boolean authorityIsKnownFromConfiguration(@NonNull String authorityStr) {
        if (authorityStr == null) {
            throw new NullPointerException("authorityStr is marked non-null but is null");
        }
        return null != Authority.getEquivalentConfiguredAuthority(authorityStr);
    }

    private static Authority createAadAuthority(@NonNull CommonURIBuilder authorityCommonUriBuilder, @NonNull List<String> pathSegments) {
        if (authorityCommonUriBuilder == null) {
            throw new NullPointerException("authorityCommonUriBuilder is marked non-null but is null");
        }
        if (pathSegments == null) {
            throw new NullPointerException("pathSegments is marked non-null but is null");
        }
        AzureActiveDirectoryAudience audience = AzureActiveDirectoryAudience.getAzureActiveDirectoryAudience(authorityCommonUriBuilder.getScheme() + "://" + authorityCommonUriBuilder.getHost(), pathSegments.get(0));
        return new AzureActiveDirectoryAuthority(audience);
    }

    public abstract OAuth2Strategy createOAuth2Strategy(@NonNull OAuth2StrategyParameters var1) throws ClientException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Authority)) {
            return false;
        }
        Authority authority = (Authority)o;
        if (!this.mAuthorityTypeString.equals(authority.mAuthorityTypeString)) {
            return false;
        }
        return this.getAuthorityUri().equals(authority.getAuthorityUri());
    }

    public int hashCode() {
        int result = this.mAuthorityTypeString.hashCode();
        result = 31 * result + this.getAuthorityUri().hashCode();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCloudDiscovery() throws IOException, URISyntaxException {
        String methodName = ":performCloudDiscovery";
        Logger.info(TAG + ":performCloudDiscovery", "Performing cloud discovery...");
        Object object = sLock;
        synchronized (object) {
            Logger.info(TAG + ":performCloudDiscovery", "Acquired lock.");
            if (!AzureActiveDirectory.isInitialized()) {
                Logger.info(TAG + ":performCloudDiscovery", "Not initialized. Starting request.");
                AzureActiveDirectory.performCloudDiscovery();
                Logger.info(TAG + ":performCloudDiscovery", "Loaded cloud metadata.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addKnownAuthorities(List<Authority> authorities) {
        Object object = sLock;
        synchronized (object) {
            knownAuthorities.addAll(authorities);
        }
    }

    public static boolean isKnownAuthority(Authority authority) {
        String methodName = ":isKnownAuthority";
        boolean knownToDeveloper = false;
        if (authority == null) {
            Logger.warn(TAG + ":isKnownAuthority", "Authority is null");
            return false;
        }
        for (Authority currentAuthority : knownAuthorities) {
            if (currentAuthority.mAuthorityUrlString == null || authority.getAuthorityURL() == null || authority.getAuthorityURL().getAuthority() == null || !currentAuthority.mAuthorityUrlString.toLowerCase(Locale.ROOT).contains(authority.getAuthorityURL().getAuthority().toLowerCase(Locale.ROOT))) continue;
            knownToDeveloper = true;
            break;
        }
        boolean knownToMicrosoft = AzureActiveDirectory.hasCloudHost(authority.getAuthorityURL());
        boolean isKnown = knownToDeveloper || knownToMicrosoft;
        Logger.verbose(TAG + ":isKnownAuthority", "Authority is known to developer? [" + knownToDeveloper + "]");
        Logger.verbose(TAG + ":isKnownAuthority", "Authority is known to Microsoft? [" + knownToMicrosoft + "]");
        return isKnown;
    }

    public static KnownAuthorityResult getKnownAuthorityResult(Authority authority) {
        String methodName = ":getKnownAuthorityResult";
        Logger.verbose(TAG + ":getKnownAuthorityResult", "Getting known authority result...");
        ClientException clientException = null;
        boolean known = false;
        try {
            Logger.info(TAG + ":getKnownAuthorityResult", "Performing cloud discovery");
            Authority.performCloudDiscovery();
        }
        catch (IOException ex) {
            clientException = new ClientException("io_error", "Unable to perform cloud discovery", ex);
        }
        catch (URISyntaxException ex) {
            clientException = new ClientException("malformed_url", "Unable to construct cloud discovery URL", ex);
        }
        Logger.info(TAG + ":getKnownAuthorityResult", "Cloud discovery complete.");
        if (clientException == null) {
            if (!Authority.isKnownAuthority(authority)) {
                clientException = new ClientException("unknown_authority", "Provided authority is not known.  MSAL will only make requests to known authorities");
            } else {
                Logger.info(TAG + ":getKnownAuthorityResult", "Cloud is known.");
                known = true;
            }
        }
        return new KnownAuthorityResult(known, clientException);
    }

    public static class KnownAuthorityResult {
        private boolean mKnown;
        private ClientException mClientException;

        KnownAuthorityResult(boolean known, ClientException exception) {
            this.mKnown = known;
            this.mClientException = exception;
        }

        public boolean getKnown() {
            return this.mKnown;
        }

        public ClientException getClientException() {
            return this.mClientException;
        }
    }
}

