/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.cache.AccountDeletionRecord;
import com.microsoft.identity.common.java.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.java.cache.IAccountCredentialCache;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class MsalCppOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends TokenResponse, GenericAccount extends BaseAccount, GenericRefreshToken extends RefreshToken>
extends MsalOAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> {
    private static final String TAG = MsalCppOAuth2TokenCache.class.getName();

    private MsalCppOAuth2TokenCache(IPlatformComponents commonComponents, IAccountCredentialCache accountCredentialCache, IAccountCredentialAdapter accountCredentialAdapter) {
        super(commonComponents, accountCredentialCache, accountCredentialAdapter);
    }

    public static MsalCppOAuth2TokenCache create(@NonNull IPlatformComponents platformComponents) {
        if (platformComponents == null) {
            throw new NullPointerException("platformComponents is marked non-null but is null");
        }
        return MsalCppOAuth2TokenCache.create(platformComponents, false);
    }

    public static MsalCppOAuth2TokenCache create(@NonNull IPlatformComponents platformComponents, boolean useInMemoryCache) {
        if (platformComponents == null) {
            throw new NullPointerException("platformComponents is marked non-null but is null");
        }
        MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> msalOAuth2TokenCache = MsalOAuth2TokenCache.create(platformComponents, useInMemoryCache);
        MsalCppOAuth2TokenCache msalCppOAuth2TokenCache = new MsalCppOAuth2TokenCache(platformComponents, msalOAuth2TokenCache.getAccountCredentialCache(), msalOAuth2TokenCache.getAccountCredentialAdapter());
        return msalCppOAuth2TokenCache;
    }

    @Override
    public IAccountCredentialCache getAccountCredentialCache() {
        return super.getAccountCredentialCache();
    }

    public synchronized void saveCredentials(Credential ... credentials) throws ClientException {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (credentials.length == 0) {
            throw new ClientException("Credential array passed in is null or empty");
        }
        RefreshTokenRecord refreshTokenRecord = null;
        for (Credential credential : credentials) {
            if (credential instanceof RefreshTokenRecord) {
                refreshTokenRecord = (RefreshTokenRecord)credential;
            }
            if (!(credential instanceof AccessTokenRecord) || this.isAccessTokenSchemaCompliant((AccessTokenRecord)credential)) continue;
            throw new ClientException("Credential is missing schema-required fields.", "AT is missing a required property.");
        }
        this.saveCredentialsInternal(credentials);
    }

    public void saveAccountRecord(@NonNull AccountRecord accountRecord) {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        this.getAccountCredentialCache().saveAccount(accountRecord);
    }

    public void clearCache() {
        this.getAccountCredentialCache().clearAll();
    }

    public List<Credential> getCredentials() {
        return Collections.unmodifiableList(this.getAccountCredentialCache().getCredentials());
    }

    public synchronized AccountDeletionRecord forceRemoveAccount(@NonNull String homeAccountId, @Nullable String environment, @Nullable String realm) throws ClientException {
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        this.validateNonNull(homeAccountId, "homeAccountId");
        boolean mustMatchOnEnvironment = !StringUtil.isNullOrEmpty(environment);
        boolean mustMatchOnRealm = !StringUtil.isNullOrEmpty(realm);
        ArrayList<AccountRecord> removedAccounts = new ArrayList<AccountRecord>();
        for (AccountRecord accountRecord : this.getAllAccounts()) {
            boolean accountRemoved;
            boolean matches = accountRecord.getHomeAccountId().equals(homeAccountId);
            if (mustMatchOnEnvironment) {
                boolean bl = matches = matches && accountRecord.getEnvironment().equals(environment);
            }
            if (mustMatchOnRealm) {
                boolean bl = matches = matches && accountRecord.getRealm().equals(realm);
            }
            if (!matches || !(accountRemoved = this.getAccountCredentialCache().removeAccount(accountRecord))) continue;
            removedAccounts.add(accountRecord);
        }
        return new AccountDeletionRecord(removedAccounts);
    }

    public synchronized AccountDeletionRecord removeAccount(@NonNull String homeAccountId, @NonNull String environment, @NonNull String realm) throws ClientException {
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        this.validateNonNull(homeAccountId, "homeAccountId");
        this.validateNonNull(environment, "environment");
        this.validateNonNull(realm, "realm");
        String normalizedEnvironment = environment.equals("") ? null : environment;
        String normalizedRealm = realm.equals("") ? null : realm;
        List<Credential> credentials = this.getAccountCredentialCache().getCredentialsFilteredBy(homeAccountId, normalizedEnvironment, CredentialType.RefreshToken, null, null, null, normalizedRealm, null, "Bearer");
        if (credentials != null && !credentials.isEmpty()) {
            String clientId = credentials.get(0).getClientId();
            return this.removeAccount(normalizedEnvironment, clientId, homeAccountId, normalizedRealm, CredentialType.AccessToken, CredentialType.AccessToken_With_AuthScheme, CredentialType.IdToken, CredentialType.V1IdToken);
        }
        return this.forceRemoveAccount(homeAccountId, normalizedEnvironment, normalizedRealm);
    }

    public List<AccountRecord> getAllAccounts() {
        return Collections.unmodifiableList(this.getAccountCredentialCache().getAccounts());
    }

    @Nullable
    public AccountRecord getAccount(@NonNull String homeAccountId, @NonNull String environment, @NonNull String realm) throws ClientException {
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked non-null but is null");
        }
        String methodName = ":getAccount";
        this.validateNonNull(homeAccountId, "homeAccountId");
        this.validateNonNull(environment, "environment");
        this.validateNonNull(realm, "realm");
        List<AccountRecord> accountRecords = this.getAccountCredentialCache().getAccountsFilteredBy(homeAccountId, environment, realm);
        if (accountRecords == null || accountRecords.isEmpty()) {
            Logger.info(TAG + ":getAccount", "No account found for the passing in homeAccountId: " + homeAccountId + " environment: " + environment + " realm: " + realm);
            return null;
        }
        return accountRecords.get(0);
    }
}

