/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands;

import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.DeviceCodeFlowCommandCallback;
import com.microsoft.identity.common.java.commands.TokenCommand;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class DeviceCodeFlowCommand
extends TokenCommand {
    private static final String TAG = DeviceCodeFlowCommand.class.getSimpleName();

    public DeviceCodeFlowCommand(@NonNull DeviceCodeFlowCommandParameters parameters, @NonNull BaseController controller, @NonNull DeviceCodeFlowCommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controller, (CommandCallback)callback, publicApiId);
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
    }

    @Override
    public AcquireTokenResult execute() throws Exception {
        String methodTag = TAG + ":execute";
        Logger.verbose(methodTag, "Device Code Flow command initiating...");
        Span span = OTelUtility.createSpanFromParent(SpanName.AcquireTokenDcf.name(), this.getParameters().getSpanContext());
        span.setAttribute(AttributeName.correlation_id.name(), this.getParameters().getCorrelationId());
        span.setAttribute(AttributeName.application_name.name(), this.getParameters().getApplicationName());
        span.setAttribute(AttributeName.public_api_id.name(), this.getPublicApiId());
        try {
            AcquireTokenResult acquireTokenResult;
            block20: {
                Scope scope = span.makeCurrent();
                try {
                    BaseController controller = this.getDefaultController();
                    span.setAttribute(AttributeName.controller_name.name(), controller.getClass().getSimpleName());
                    DeviceCodeFlowCommandParameters commandParameters = (DeviceCodeFlowCommandParameters)this.getParameters();
                    AuthorizationResult authorizationResult = controller.deviceCodeFlowAuthRequest(commandParameters);
                    MicrosoftStsAuthorizationResponse authorizationResponse = (MicrosoftStsAuthorizationResponse)authorizationResult.getAuthorizationResponse();
                    Date expiredDate = new Date();
                    try {
                        long expiredInInMilliseconds = TimeUnit.SECONDS.toMillis(Long.parseLong(authorizationResponse.getExpiresIn()));
                        expiredDate.setTime(expiredDate.getTime() + expiredInInMilliseconds);
                    }
                    catch (NumberFormatException e) {
                        Logger.error(methodTag, "Failed to parse authorizationResponse.getExpiresIn()", e);
                    }
                    DeviceCodeFlowCommandCallback deviceCodeFlowCommandCallback = (DeviceCodeFlowCommandCallback)this.getCallback();
                    deviceCodeFlowCommandCallback.onUserCodeReceived(authorizationResponse.getVerificationUri(), authorizationResponse.getUserCode(), authorizationResponse.getMessage(), expiredDate);
                    AcquireTokenResult tokenResult = controller.acquireDeviceCodeFlowToken(authorizationResult, commandParameters);
                    Logger.verbose(methodTag, "Device Code Flow command exiting with token...");
                    if (tokenResult == null) {
                        span.setStatus(StatusCode.ERROR, "empty result");
                    } else if (tokenResult.getSucceeded().booleanValue()) {
                        span.setStatus(StatusCode.OK);
                    } else {
                        BaseException exception = ExceptionAdapter.exceptionFromAcquireTokenResult(tokenResult, this.getParameters());
                        if (!exception.getErrorCode().equals("authorization_pending")) {
                            if (exception != null) {
                                span.recordException((Throwable)exception);
                                span.setStatus(StatusCode.ERROR);
                            } else {
                                span.setStatus(StatusCode.ERROR, "empty exception");
                            }
                        }
                    }
                    acquireTokenResult = tokenResult;
                    if (scope == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        span.setStatus(StatusCode.ERROR);
                        span.recordException(throwable3);
                        throw throwable3;
                    }
                }
                scope.close();
            }
            return acquireTokenResult;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }
}

