/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands.parameters;

import com.google.gson.annotations.Expose;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.logging.Logger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TokenCommandParameters
extends CommandParameters {
    private static final String TAG = TokenCommandParameters.class.getSimpleName();
    private final IAccountRecord account;
    @Expose
    private final Set<String> scopes;
    @Expose
    private final Authority authority;
    @Expose
    private final String claimsRequestJson;
    @Expose
    private final AbstractAuthenticationScheme authenticationScheme;
    @Expose
    private final String mamEnrollmentId;
    @Expose
    private final boolean forceRefresh;
    private final String loginHint;
    private final List<Map.Entry<String, String>> extraOptions;

    public Set<String> getScopes() {
        return this.scopes == null ? null : new HashSet<String>(this.scopes);
    }

    public String getMamEnrollmentId() {
        return this.mamEnrollmentId;
    }

    public void validate() throws ArgumentException {
        String methodName = ":validate";
        Logger.verbose(TAG + ":validate", "Validating operation params...");
        boolean validScopeArgument = false;
        if (this.scopes != null) {
            this.scopes.removeAll(Arrays.asList("", null));
            if (this.scopes.size() > 0) {
                validScopeArgument = true;
            }
        }
        if (!validScopeArgument) {
            if (this instanceof SilentTokenCommandParameters) {
                throw new ArgumentException("acquireTokenSilent", "scopes", "scope is empty or null");
            }
            if (this instanceof InteractiveTokenCommandParameters) {
                throw new ArgumentException("acquireToken", "scopes", "scope is empty or null");
            }
            if (this instanceof DeviceCodeFlowCommandParameters) {
                throw new ArgumentException("acquireTokenWithDeviceCode", "scopes", "scope is empty or null");
            }
        }
        if (null == this.authenticationScheme) {
            if (this instanceof SilentTokenCommandParameters) {
                throw new ArgumentException("acquireTokenSilent", "authentication_scheme", "authentication scheme is undefined");
            }
            if (this instanceof InteractiveTokenCommandParameters) {
                throw new ArgumentException("acquireToken", "authentication_scheme", "authentication scheme is undefined");
            }
            if (this instanceof DeviceCodeFlowCommandParameters) {
                throw new ArgumentException("acquireTokenWithDeviceCode", "authentication_scheme", "authentication scheme is undefined");
            }
        }
    }

    protected TokenCommandParameters(TokenCommandParametersBuilder<?, ?> b) {
        super(b);
        this.account = ((TokenCommandParametersBuilder)b).account;
        this.scopes = ((TokenCommandParametersBuilder)b).scopes;
        this.authority = ((TokenCommandParametersBuilder)b).authority;
        this.claimsRequestJson = ((TokenCommandParametersBuilder)b).claimsRequestJson;
        this.authenticationScheme = ((TokenCommandParametersBuilder)b).authenticationScheme;
        this.mamEnrollmentId = ((TokenCommandParametersBuilder)b).mamEnrollmentId;
        this.forceRefresh = ((TokenCommandParametersBuilder)b).forceRefresh;
        this.loginHint = ((TokenCommandParametersBuilder)b).loginHint;
        this.extraOptions = ((TokenCommandParametersBuilder)b).extraOptions;
    }

    public static TokenCommandParametersBuilder<?, ?> builder() {
        return new TokenCommandParametersBuilderImpl();
    }

    public TokenCommandParametersBuilder<?, ?> toBuilder() {
        return new TokenCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    public IAccountRecord getAccount() {
        return this.account;
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public String getClaimsRequestJson() {
        return this.claimsRequestJson;
    }

    public AbstractAuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public boolean isForceRefresh() {
        return this.forceRefresh;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public List<Map.Entry<String, String>> getExtraOptions() {
        return this.extraOptions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenCommandParameters)) {
            return false;
        }
        TokenCommandParameters other = (TokenCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IAccountRecord this$account = this.getAccount();
        IAccountRecord other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        Set<String> this$scopes = this.getScopes();
        Set<String> other$scopes = other.getScopes();
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        Authority this$authority = this.getAuthority();
        Authority other$authority = other.getAuthority();
        if (this$authority == null ? other$authority != null : !((Object)this$authority).equals(other$authority)) {
            return false;
        }
        String this$claimsRequestJson = this.getClaimsRequestJson();
        String other$claimsRequestJson = other.getClaimsRequestJson();
        if (this$claimsRequestJson == null ? other$claimsRequestJson != null : !this$claimsRequestJson.equals(other$claimsRequestJson)) {
            return false;
        }
        AbstractAuthenticationScheme this$authenticationScheme = this.getAuthenticationScheme();
        AbstractAuthenticationScheme other$authenticationScheme = other.getAuthenticationScheme();
        if (this$authenticationScheme == null ? other$authenticationScheme != null : !((Object)this$authenticationScheme).equals(other$authenticationScheme)) {
            return false;
        }
        String this$mamEnrollmentId = this.getMamEnrollmentId();
        String other$mamEnrollmentId = other.getMamEnrollmentId();
        if (this$mamEnrollmentId == null ? other$mamEnrollmentId != null : !this$mamEnrollmentId.equals(other$mamEnrollmentId)) {
            return false;
        }
        if (this.isForceRefresh() != other.isForceRefresh()) {
            return false;
        }
        String this$loginHint = this.getLoginHint();
        String other$loginHint = other.getLoginHint();
        if (this$loginHint == null ? other$loginHint != null : !this$loginHint.equals(other$loginHint)) {
            return false;
        }
        List<Map.Entry<String, String>> this$extraOptions = this.getExtraOptions();
        List<Map.Entry<String, String>> other$extraOptions = other.getExtraOptions();
        return !(this$extraOptions == null ? other$extraOptions != null : !((Object)this$extraOptions).equals(other$extraOptions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TokenCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IAccountRecord $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        Set<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        Authority $authority = this.getAuthority();
        result = result * 59 + ($authority == null ? 43 : ((Object)$authority).hashCode());
        String $claimsRequestJson = this.getClaimsRequestJson();
        result = result * 59 + ($claimsRequestJson == null ? 43 : $claimsRequestJson.hashCode());
        AbstractAuthenticationScheme $authenticationScheme = this.getAuthenticationScheme();
        result = result * 59 + ($authenticationScheme == null ? 43 : ((Object)$authenticationScheme).hashCode());
        String $mamEnrollmentId = this.getMamEnrollmentId();
        result = result * 59 + ($mamEnrollmentId == null ? 43 : $mamEnrollmentId.hashCode());
        result = result * 59 + (this.isForceRefresh() ? 79 : 97);
        String $loginHint = this.getLoginHint();
        result = result * 59 + ($loginHint == null ? 43 : $loginHint.hashCode());
        List<Map.Entry<String, String>> $extraOptions = this.getExtraOptions();
        result = result * 59 + ($extraOptions == null ? 43 : ((Object)$extraOptions).hashCode());
        return result;
    }

    private static final class TokenCommandParametersBuilderImpl
    extends TokenCommandParametersBuilder<TokenCommandParameters, TokenCommandParametersBuilderImpl> {
        private TokenCommandParametersBuilderImpl() {
        }

        @Override
        protected TokenCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public TokenCommandParameters build() {
            return new TokenCommandParameters(this);
        }
    }

    public static abstract class TokenCommandParametersBuilder<C extends TokenCommandParameters, B extends TokenCommandParametersBuilder<C, B>>
    extends CommandParameters.CommandParametersBuilder<C, B> {
        private IAccountRecord account;
        private Set<String> scopes;
        private Authority authority;
        private String claimsRequestJson;
        private AbstractAuthenticationScheme authenticationScheme;
        private String mamEnrollmentId;
        private boolean forceRefresh;
        private String loginHint;
        private List<Map.Entry<String, String>> extraOptions;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TokenCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TokenCommandParameters instance, TokenCommandParametersBuilder<?, ?> b) {
            b.account(instance.account);
            b.scopes(instance.scopes);
            b.authority(instance.authority);
            b.claimsRequestJson(instance.claimsRequestJson);
            b.authenticationScheme(instance.authenticationScheme);
            b.mamEnrollmentId(instance.mamEnrollmentId);
            b.forceRefresh(instance.forceRefresh);
            b.loginHint(instance.loginHint);
            b.extraOptions(instance.extraOptions);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B account(IAccountRecord account) {
            this.account = account;
            return (B)this.self();
        }

        public B scopes(Set<String> scopes) {
            this.scopes = scopes;
            return (B)this.self();
        }

        public B authority(Authority authority) {
            this.authority = authority;
            return (B)this.self();
        }

        public B claimsRequestJson(String claimsRequestJson) {
            this.claimsRequestJson = claimsRequestJson;
            return (B)this.self();
        }

        public B authenticationScheme(AbstractAuthenticationScheme authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return (B)this.self();
        }

        public B mamEnrollmentId(String mamEnrollmentId) {
            this.mamEnrollmentId = mamEnrollmentId;
            return (B)this.self();
        }

        public B forceRefresh(boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return (B)this.self();
        }

        public B loginHint(String loginHint) {
            this.loginHint = loginHint;
            return (B)this.self();
        }

        public B extraOptions(List<Map.Entry<String, String>> extraOptions) {
            this.extraOptions = extraOptions;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TokenCommandParameters.TokenCommandParametersBuilder(super=" + super.toString() + ", account=" + this.account + ", scopes=" + this.scopes + ", authority=" + this.authority + ", claimsRequestJson=" + this.claimsRequestJson + ", authenticationScheme=" + this.authenticationScheme + ", mamEnrollmentId=" + this.mamEnrollmentId + ", forceRefresh=" + this.forceRefresh + ", loginHint=" + this.loginHint + ", extraOptions=" + this.extraOptions + ")";
        }
    }
}

