/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto.key;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.crypto.key.AbstractSecretKeyLoader;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public class KeyUtil {
    private static final String TAG = KeyUtil.class.getSimpleName();
    public static final String UNKNOWN_THUMBPRINT = "UNKNOWN_THUMBPRINT";
    public static final String HMAC_KEY_HASH_ALGORITHM = "SHA-256";
    public static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final String HMAC_KEYSPEC_ALGORITHM = "AES";

    public static String getKeyThumbPrint(@NonNull AbstractSecretKeyLoader keyLoader) {
        if (keyLoader == null) {
            throw new NullPointerException("keyLoader is marked non-null but is null");
        }
        String methodName = ":getKeyThumbPrint";
        try {
            return KeyUtil.getKeyThumbPrint(keyLoader.getKey());
        }
        catch (ClientException e) {
            Logger.warn(TAG + ":getKeyThumbPrint", "failed to load key:" + e.getMessage());
            return UNKNOWN_THUMBPRINT;
        }
    }

    public static String getKeyThumbPrint(@NonNull SecretKey key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String methodName = ":getKeyThumbPrint";
        try {
            return KeyUtil.getKeyThumbPrintFromHmacKey(KeyUtil.getHMacKey(key));
        }
        catch (NoSuchAlgorithmException e) {
            Logger.warn(TAG + ":getKeyThumbPrint", "failed to calculate thumbprint:" + e.getMessage());
            return UNKNOWN_THUMBPRINT;
        }
    }

    public static String getKeyThumbPrintFromHmacKey(@NonNull SecretKey hmacKey) {
        if (hmacKey == null) {
            throw new NullPointerException("hmacKey is marked non-null but is null");
        }
        String methodName = ":getKeyThumbPrintFromHmacKey";
        try {
            byte[] thumbprintBytes = "012345678910111213141516".getBytes(AuthenticationConstants.ENCODING_UTF8);
            Mac thumbprintMac = Mac.getInstance(HMAC_ALGORITHM);
            thumbprintMac.init(hmacKey);
            byte[] thumbPrintFinal = thumbprintMac.doFinal(thumbprintBytes);
            return StringUtil.encodeUrlSafeString(thumbPrintFinal);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            Logger.warn(TAG + ":getKeyThumbPrintFromHmacKey", "failed to calculate thumbprint:" + e.getMessage());
            return UNKNOWN_THUMBPRINT;
        }
    }

    public static SecretKey getHMacKey(@NonNull SecretKey key) throws NoSuchAlgorithmException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        byte[] encodedKey = key.getEncoded();
        if (encodedKey != null) {
            MessageDigest digester = MessageDigest.getInstance(HMAC_KEY_HASH_ALGORITHM);
            return new SecretKeySpec(digester.digest(encodedKey), HMAC_KEYSPEC_ALGORITHM);
        }
        return key;
    }
}

