/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.exception;

import com.microsoft.identity.common.java.exception.IErrorInformation;
import com.microsoft.identity.common.java.telemetry.ITelemetryAccessor;
import com.microsoft.identity.common.java.telemetry.Telemetry;
import com.microsoft.identity.common.java.telemetry.events.ErrorEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import lombok.NonNull;

public class BaseException
extends Exception
implements IErrorInformation,
ITelemetryAccessor {
    public static final String sName = "com.microsoft.identity.common.exception.BaseException";
    private static final long serialVersionUID = -5166242728507796770L;
    private static final TreeSet<String> nonCacheableErrorCodes = new TreeSet<String>(Arrays.asList("device_network_not_available", "operation_interrupted", "invalid_broker_bundle", "io_error"));
    @Nullable
    private String mSpeRing;
    @Nullable
    private String mRefreshTokenAge;
    @Nullable
    private String mCliTelemErrorCode;
    @Nullable
    private String mCliTelemSubErrorCode;
    private String mErrorCode;
    private String mCorrelationId;
    @Nullable
    private String mUsername;
    private final List<Map<String, String>> mTelemetry = new ArrayList<Map<String, String>>();
    private final List<Exception> mSuppressedException = new ArrayList<Exception>();

    public void addSuppressedException(@NonNull Exception e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        this.mSuppressedException.add(e);
    }

    protected BaseException() {
        this((String)null);
    }

    public BaseException(String errorCode) {
        this(errorCode, (String)null);
    }

    public BaseException(String errorCode, String errorMessage) {
        this(errorCode, errorMessage, null);
    }

    public BaseException(String errorCode, String errorMessage, Throwable throwable) {
        super(errorMessage, throwable);
        this.mErrorCode = errorCode;
        Telemetry.emit(new ErrorEvent().putException(this));
    }

    @Override
    public String getErrorCode() {
        return this.mErrorCode;
    }

    @Override
    public String getMessage() {
        if (!StringUtil.isNullOrEmpty(super.getMessage())) {
            return super.getMessage();
        }
        return null;
    }

    @Nullable
    public String getSpeRing() {
        return this.mSpeRing;
    }

    public void setSpeRing(@Nullable String speRing) {
        this.mSpeRing = speRing;
    }

    @Nullable
    public String getRefreshTokenAge() {
        return this.mRefreshTokenAge;
    }

    public void setRefreshTokenAge(@Nullable String refreshTokenAge) {
        this.mRefreshTokenAge = refreshTokenAge;
    }

    @Nullable
    public String getCliTelemErrorCode() {
        return this.mCliTelemErrorCode;
    }

    public void setCliTelemErrorCode(@Nullable String cliTelemErrorCode) {
        this.mCliTelemErrorCode = cliTelemErrorCode;
    }

    @Nullable
    public String getCliTelemSubErrorCode() {
        return this.mCliTelemSubErrorCode;
    }

    public void setCliTelemSubErrorCode(@Nullable String cliTelemSubErrorCode) {
        this.mCliTelemSubErrorCode = cliTelemSubErrorCode;
    }

    @Nullable
    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    public void setCorrelationId(@Nullable String correlationId) {
        this.mCorrelationId = correlationId;
    }

    @Nullable
    public String getUsername() {
        return this.mUsername;
    }

    public void setUsername(@NonNull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.mUsername = username;
    }

    public String getExceptionName() {
        return sName;
    }

    public boolean isCacheable() {
        return !nonCacheableErrorCodes.contains(this.mErrorCode);
    }

    public void setTelemetry(@NonNull List<Map<String, String>> telemetry) {
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        this.mTelemetry.addAll(telemetry);
    }

    @Override
    public List<Map<String, String>> getTelemetry() {
        return this.mTelemetry;
    }

    public List<Exception> getSuppressedException() {
        return this.mSuppressedException;
    }
}

