/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.opentelemetry;

import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.CertBasedAuthChoice;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import lombok.NonNull;

public class CertBasedAuthTelemetryHelper
implements ICertBasedAuthTelemetryHelper {
    private final Span mSpan = OTelUtility.createSpan(SpanName.CertBasedAuth.name());

    @Override
    public void setCertBasedAuthChallengeHandler(@NonNull String challengeHandlerName) {
        if (challengeHandlerName == null) {
            throw new NullPointerException("challengeHandlerName is marked non-null but is null");
        }
        this.mSpan.setAttribute(AttributeName.cert_based_auth_challenge_handler.name(), challengeHandlerName);
    }

    @Override
    public void setExistingPivProviderPresent(boolean present) {
        this.mSpan.setAttribute(AttributeName.cert_based_auth_existing_piv_provider_present.name(), present);
    }

    @Override
    @SuppressFBWarnings
    public void setResultSuccess() {
        this.mSpan.setStatus(StatusCode.OK);
        this.mSpan.end();
    }

    @Override
    @SuppressFBWarnings
    public void setResultFailure(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.mSpan.setStatus(StatusCode.ERROR, message);
        this.mSpan.end();
    }

    @Override
    @SuppressFBWarnings
    public void setResultFailure(@NonNull Exception exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        this.mSpan.recordException((Throwable)exception);
        this.mSpan.setStatus(StatusCode.ERROR);
        this.mSpan.end();
    }

    @Override
    public void setUserChoice(@NonNull CertBasedAuthChoice choice) {
        if (choice == null) {
            throw new NullPointerException("choice is marked non-null but is null");
        }
        switch (choice) {
            case ON_DEVICE_CHOICE: {
                this.mSpan.setAttribute(AttributeName.cert_based_auth_user_choice.name(), "on-device");
                break;
            }
            case SMARTCARD_CHOICE: {
                this.mSpan.setAttribute(AttributeName.cert_based_auth_user_choice.name(), "smartcard");
                break;
            }
            default: {
                this.mSpan.setAttribute(AttributeName.cert_based_auth_user_choice.name(), "N/A");
            }
        }
    }

    @Override
    public void setPublicKeyAlgoType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.mSpan.setAttribute(AttributeName.cert_based_auth_public_key_algo_type.name(), type);
    }
}

