/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.opentelemetry;

import com.google.gson.annotations.SerializedName;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import java.io.Serializable;
import lombok.NonNull;

public class SerializableSpanContext
implements SpanContext,
Serializable {
    @SerializedName(value="trace_id")
    @NonNull
    private final String mTraceId;
    @SerializedName(value="span_id")
    @NonNull
    private final String mSpanId;
    @SerializedName(value="trace_flags")
    private final byte mTraceFlags;

    public String getTraceId() {
        return this.mTraceId;
    }

    public String getSpanId() {
        return this.mSpanId;
    }

    public TraceFlags getTraceFlags() {
        return TraceFlags.fromByte((byte)this.mTraceFlags);
    }

    public TraceState getTraceState() {
        return TraceState.getDefault();
    }

    public boolean isRemote() {
        return false;
    }

    SerializableSpanContext(@NonNull String traceId, @NonNull String spanId, byte traceFlags) {
        if (traceId == null) {
            throw new NullPointerException("traceId is marked non-null but is null");
        }
        if (spanId == null) {
            throw new NullPointerException("spanId is marked non-null but is null");
        }
        this.mTraceId = traceId;
        this.mSpanId = spanId;
        this.mTraceFlags = traceFlags;
    }

    public static SerializableSpanContextBuilder builder() {
        return new SerializableSpanContextBuilder();
    }

    public static class SerializableSpanContextBuilder {
        private String traceId;
        private String spanId;
        private byte traceFlags;

        SerializableSpanContextBuilder() {
        }

        public SerializableSpanContextBuilder traceId(@NonNull String traceId) {
            if (traceId == null) {
                throw new NullPointerException("traceId is marked non-null but is null");
            }
            this.traceId = traceId;
            return this;
        }

        public SerializableSpanContextBuilder spanId(@NonNull String spanId) {
            if (spanId == null) {
                throw new NullPointerException("spanId is marked non-null but is null");
            }
            this.spanId = spanId;
            return this;
        }

        public SerializableSpanContextBuilder traceFlags(byte traceFlags) {
            this.traceFlags = traceFlags;
            return this;
        }

        public SerializableSpanContext build() {
            return new SerializableSpanContext(this.traceId, this.spanId, this.traceFlags);
        }

        public String toString() {
            return "SerializableSpanContext.SerializableSpanContextBuilder(traceId=" + this.traceId + ", spanId=" + this.spanId + ", traceFlags=" + this.traceFlags + ")";
        }
    }

    public static class SerializedNames {
        public static final String TRACE_ID = "trace_id";
        public static final String SPAN_ID = "span_id";
        public static final String TRACE_FLAGS = "trace_flags";
        public static final String PARENT_SPAN_NAME = "parent_span_name";
    }
}

