/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.java.authorities.Environment;
import com.microsoft.identity.common.java.cache.HttpCache;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.net.HttpClient;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.providers.IdentityProvider;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryInstanceResponse;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Configuration;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.NonNull;
import org.json.JSONException;

public class AzureActiveDirectory
extends IdentityProvider<AzureActiveDirectoryOAuth2Strategy, AzureActiveDirectoryOAuth2Configuration> {
    private static final String TAG = AzureActiveDirectory.class.getSimpleName();
    private static final String TENANT_DISCOVERY_ENDPOINT = "tenant_discovery_endpoint";
    private static final String METADATA = "metadata";
    private static final String AAD_INSTANCE_DISCOVERY_ENDPOINT = "/common/discovery/instance";
    private static final String API_VERSION = "api-version";
    private static final String API_VERSION_VALUE = "1.1";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private static final String AUTHORIZATION_ENDPOINT_VALUE = "https://login.microsoftonline.com/common/oauth2/v2.0/authorize";
    private static ConcurrentMap<String, AzureActiveDirectoryCloud> sAadClouds = new ConcurrentHashMap<String, AzureActiveDirectoryCloud>();
    private static boolean sIsInitialized = false;
    private static Environment sEnvironment = Environment.Production;
    private static final HttpClient httpClient = UrlConnectionHttpClient.getDefaultInstance();

    @Override
    public AzureActiveDirectoryOAuth2Strategy createOAuth2Strategy(@NonNull AzureActiveDirectoryOAuth2Configuration config, @NonNull IPlatformComponents commonComponents) throws ClientException {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (commonComponents == null) {
            throw new NullPointerException("commonComponents is marked non-null but is null");
        }
        OAuth2StrategyParameters parameters = OAuth2StrategyParameters.builder().platformComponents(commonComponents).build();
        return new AzureActiveDirectoryOAuth2Strategy(config, parameters);
    }

    public static synchronized boolean hasCloudHost(@NonNull URL authorityUrl) {
        if (authorityUrl == null) {
            throw new NullPointerException("authorityUrl is marked non-null but is null");
        }
        return sAadClouds.containsKey(authorityUrl.getHost().toLowerCase(Locale.US));
    }

    static synchronized boolean isValidCloudHost(@NonNull URL authorityUrl) {
        if (authorityUrl == null) {
            throw new NullPointerException("authorityUrl is marked non-null but is null");
        }
        return AzureActiveDirectory.hasCloudHost(authorityUrl) && AzureActiveDirectory.getAzureActiveDirectoryCloud(authorityUrl).isValidated();
    }

    public static synchronized boolean isInitialized() {
        return sIsInitialized;
    }

    public static synchronized void setEnvironment(@NonNull Environment environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        if (environment != sEnvironment) {
            sIsInitialized = false;
            sEnvironment = environment;
        }
    }

    public static synchronized Environment getEnvironment() {
        return sEnvironment;
    }

    public static synchronized AzureActiveDirectoryCloud getAzureActiveDirectoryCloud(@NonNull URL authorityUrl) {
        if (authorityUrl == null) {
            throw new NullPointerException("authorityUrl is marked non-null but is null");
        }
        return (AzureActiveDirectoryCloud)sAadClouds.get(authorityUrl.getHost().toLowerCase(Locale.US));
    }

    public static synchronized AzureActiveDirectoryCloud getAzureActiveDirectoryCloudFromHostName(@NonNull String preferredCacheHostName) {
        if (preferredCacheHostName == null) {
            throw new NullPointerException("preferredCacheHostName is marked non-null but is null");
        }
        return (AzureActiveDirectoryCloud)sAadClouds.get(preferredCacheHostName.toLowerCase(Locale.US));
    }

    public static synchronized void putCloud(@NonNull String host, AzureActiveDirectoryCloud cloud) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        sAadClouds.put(host.toLowerCase(Locale.US), cloud);
    }

    public static synchronized void initializeCloudMetadata(@NonNull String authorityHost, @NonNull Map<String, String> discoveryResponse) throws JSONException {
        if (authorityHost == null) {
            throw new NullPointerException("authorityHost is marked non-null but is null");
        }
        if (discoveryResponse == null) {
            throw new NullPointerException("discoveryResponse is marked non-null but is null");
        }
        boolean tenantDiscoveryEndpointReturned = discoveryResponse.containsKey(TENANT_DISCOVERY_ENDPOINT);
        String metadata = discoveryResponse.get(METADATA);
        if (!tenantDiscoveryEndpointReturned) {
            sAadClouds.put(authorityHost, new AzureActiveDirectoryCloud(false));
            return;
        }
        if (StringUtil.isNullOrEmpty(metadata)) {
            sAadClouds.put(authorityHost, new AzureActiveDirectoryCloud(authorityHost, authorityHost));
            return;
        }
        List<AzureActiveDirectoryCloud> clouds = AzureActiveDirectory.deserializeClouds(metadata);
        for (AzureActiveDirectoryCloud cloud : clouds) {
            cloud.setIsValidated(true);
            for (String alias : cloud.getHostAliases()) {
                sAadClouds.put(alias.toLowerCase(Locale.US), cloud);
            }
        }
        sIsInitialized = true;
    }

    public static synchronized String getDefaultCloudUrl() {
        if (sEnvironment == Environment.PreProduction) {
            return "https://login.windows-ppe.net";
        }
        return "https://login.microsoftonline.com";
    }

    public static synchronized void performCloudDiscovery() throws IOException, URISyntaxException {
        String methodName = ":performCloudDiscovery";
        URI instanceDiscoveryRequestUri = new CommonURIBuilder(AzureActiveDirectory.getDefaultCloudUrl() + AAD_INSTANCE_DISCOVERY_ENDPOINT).setParameter(API_VERSION, API_VERSION_VALUE).setParameter(AUTHORIZATION_ENDPOINT, AUTHORIZATION_ENDPOINT_VALUE).build();
        HttpResponse response = httpClient.get(new URL(instanceDiscoveryRequestUri.toString()), new HashMap<String, String>());
        if (response.getStatusCode() >= 400) {
            Logger.warn(TAG + ":performCloudDiscovery", "Error getting cloud information");
        } else {
            HttpCache.flush();
            Logger.info(TAG + ":performCloudDiscovery", "Parsing response.");
            AzureActiveDirectoryInstanceResponse instanceResponse = ObjectMapper.deserializeJsonStringToObject(response.getBody(), AzureActiveDirectoryInstanceResponse.class);
            Logger.info(TAG + ":performCloudDiscovery", "Discovered [" + instanceResponse.getClouds().size() + "] clouds.");
            for (AzureActiveDirectoryCloud cloud : instanceResponse.getClouds()) {
                cloud.setIsValidated(true);
                for (String alias : cloud.getHostAliases()) {
                    sAadClouds.put(alias.toLowerCase(Locale.US), cloud);
                }
            }
            sIsInitialized = true;
        }
    }

    public static synchronized Set<String> getHosts() {
        if (null != sAadClouds) {
            return sAadClouds.keySet();
        }
        return null;
    }

    public static synchronized List<AzureActiveDirectoryCloud> getClouds() {
        if (null != sAadClouds) {
            return new ArrayList<AzureActiveDirectoryCloud>(sAadClouds.values());
        }
        return new ArrayList<AzureActiveDirectoryCloud>();
    }

    private static List<AzureActiveDirectoryCloud> deserializeClouds(String jsonCloudArray) throws JSONException {
        Type listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{AzureActiveDirectoryCloud.class}).getType();
        return (List)new Gson().fromJson(jsonCloudArray, listType);
    }
}

