/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft.microsoftsts;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.util.SchemaUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import lombok.NonNull;

public class MicrosoftStsAccount
extends MicrosoftAccount {
    private static final String TAG = MicrosoftStsAccount.class.getSimpleName();

    public MicrosoftStsAccount() {
        Logger.verbose(TAG, "Init: " + TAG);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public MicrosoftStsAccount(@NonNull IDToken idToken, @NonNull ClientInfo clientInfo) {
        super(idToken, clientInfo);
        if (idToken == null) {
            throw new NullPointerException("idToken is marked non-null but is null");
        }
        if (clientInfo == null) {
            throw new NullPointerException("clientInfo is marked non-null but is null");
        }
        Logger.verbose(TAG, "Init: " + TAG);
    }

    @Override
    public String getAuthorityType() {
        return "MSSTS";
    }

    @Override
    protected String getDisplayableIdFromClaims(@NonNull Map<String, ?> claims) {
        if (claims == null) {
            throw new NullPointerException("claims is marked non-null but is null");
        }
        return SchemaUtil.getDisplayableId(claims);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicrosoftStsAccount)) {
            return false;
        }
        MicrosoftStsAccount other = (MicrosoftStsAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MicrosoftStsAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

