/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft.microsoftsts;

import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.AuthenticationSchemeFactory;
import com.microsoft.identity.common.java.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.authscheme.PopAuthenticationSchemeWithClientKeyInternal;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.java.challengehandlers.PKeyAuthChallengeFactory;
import com.microsoft.identity.common.java.commands.parameters.RopcTokenCommandParameters;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightManager;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.net.HttpClient;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.platform.Device;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAuthorizationResponse;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftTokenErrorResponse;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAccessToken;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResultFactory;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsRopcTokenRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.java.providers.oauth2.IAuthorizationStrategy;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdProviderConfiguration;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdProviderConfigurationClient;
import com.microsoft.identity.common.java.providers.oauth2.TokenErrorResponse;
import com.microsoft.identity.common.java.providers.oauth2.TokenResult;
import com.microsoft.identity.common.java.telemetry.CliTelemInfo;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.HeaderSerializationUtil;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.ResultUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import lombok.NonNull;

public class MicrosoftStsOAuth2Strategy
extends OAuth2Strategy<MicrosoftStsAccessToken, MicrosoftStsAccount, MicrosoftStsAuthorizationRequest, MicrosoftStsAuthorizationRequest.Builder, IAuthorizationStrategy, MicrosoftStsOAuth2Configuration, OAuth2StrategyParameters, MicrosoftStsAuthorizationResponse, MicrosoftStsRefreshToken, MicrosoftStsTokenRequest, MicrosoftStsTokenResponse, TokenResult, AuthorizationResult> {
    private static final String TAG = MicrosoftStsOAuth2Strategy.class.getSimpleName();
    private static final String RESOURCE_DEFAULT_SCOPE = "/.default";
    private final HttpClient httpClient = UrlConnectionHttpClient.getDefaultInstance();
    private OpenIdProviderConfiguration mOpenIdProviderConfiguration;

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public MicrosoftStsOAuth2Strategy(@NonNull MicrosoftStsOAuth2Configuration config, @NonNull OAuth2StrategyParameters parameters) throws ClientException {
        super(config, parameters);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.setTokenEndpoint(config.getTokenEndpoint().toString());
        if (parameters.isUsingOpenIdConfiguration()) {
            this.loadOpenIdProviderConfiguration();
        }
    }

    @NonNull
    public static String getScopeFromResource(@NonNull String resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        return resource + RESOURCE_DEFAULT_SCOPE;
    }

    @Override
    public AuthorizationResultFactory getAuthorizationResultFactory() {
        return new MicrosoftStsAuthorizationResultFactory();
    }

    @Override
    public String getIssuerCacheIdentifier(@NonNull MicrosoftStsAuthorizationRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String methodName = ":getIssuerCacheIdentifier";
        URL authority = request.getAuthority();
        AzureActiveDirectoryCloud cloudEnv = AzureActiveDirectory.getAzureActiveDirectoryCloud(authority);
        if (null != cloudEnv) {
            String preferredCacheHostName = cloudEnv.getPreferredCacheHostName();
            Logger.info(TAG + ":getIssuerCacheIdentifier", "Using preferred cache host name...");
            Logger.infoPII(TAG + ":getIssuerCacheIdentifier", "Preferred cache hostname: [" + preferredCacheHostName + "]");
            return preferredCacheHostName;
        }
        return authority.getHost();
    }

    private String getIssuerCacheIdentifierFromAuthority(URL authority) {
        String methodName = ":getIssuerCacheIdentifierFromAuthority";
        AzureActiveDirectoryCloud cloudEnv = AzureActiveDirectory.getAzureActiveDirectoryCloud(authority);
        if (null != cloudEnv) {
            String preferredCacheHostName = cloudEnv.getPreferredCacheHostName();
            Logger.info(TAG + ":getIssuerCacheIdentifierFromAuthority", "Using preferred cache host name...");
            Logger.infoPII(TAG + ":getIssuerCacheIdentifierFromAuthority", "Preferred cache hostname: [" + preferredCacheHostName + "]");
            return preferredCacheHostName;
        }
        return authority.getHost();
    }

    public String getIssuerCacheIdentifierFromTokenEndpoint() {
        String methodName = ":getIssuerCacheIdentifierFromTokenEndpoint";
        URL authority = null;
        String cacheIdentifier = null;
        try {
            authority = new URL(this.mTokenEndpoint);
        }
        catch (MalformedURLException e) {
            Logger.error(TAG + ":getIssuerCacheIdentifierFromTokenEndpoint", "Getting issuer cache identifier from token endpoint failed due to malformed URL (mTokenEndpoint)...", e);
        }
        if (authority != null) {
            cacheIdentifier = this.getIssuerCacheIdentifierFromAuthority(authority);
        }
        return cacheIdentifier;
    }

    @Override
    public MicrosoftStsAccessToken getAccessTokenFromResponse(@NonNull MicrosoftStsTokenResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String methodName = ":getAccessTokenFromResponse";
        Logger.verbose(TAG + ":getAccessTokenFromResponse", "Getting AT from TokenResponse...");
        return new MicrosoftStsAccessToken(response);
    }

    @Override
    public MicrosoftStsRefreshToken getRefreshTokenFromResponse(@NonNull MicrosoftStsTokenResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String methodName = ":getRefreshTokenFromResponse";
        Logger.verbose(TAG + ":getRefreshTokenFromResponse", "Getting RT from TokenResponse...");
        return new MicrosoftStsRefreshToken(response);
    }

    @Override
    public MicrosoftStsAccount createAccount(@NonNull MicrosoftStsTokenResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String methodName = ":createAccount";
        Logger.verbose(TAG + ":createAccount", "Creating account from TokenResponse...");
        IDToken idToken = null;
        ClientInfo clientInfo = null;
        try {
            idToken = new IDToken(response.getIdToken());
            clientInfo = new ClientInfo(response.getClientInfo());
        }
        catch (ServiceException ccse) {
            Logger.error(TAG + ":createAccount", "Failed to construct IDToken or ClientInfo", null);
            Logger.errorPII(TAG + ":createAccount", "Failed with Exception", ccse);
            throw new RuntimeException();
        }
        MicrosoftStsAccount account = new MicrosoftStsAccount(idToken, clientInfo);
        account.setEnvironment(this.getIssuerCacheIdentifierFromTokenEndpoint());
        return account;
    }

    @Override
    public MicrosoftStsAuthorizationRequest.Builder createAuthorizationRequestBuilder() {
        String methodName = ":createAuthorizationRequestBuilder";
        Logger.info(TAG + ":createAuthorizationRequestBuilder", "Creating AuthorizationRequestBuilder...");
        MicrosoftStsAuthorizationRequest.Builder builder = new MicrosoftStsAuthorizationRequest.Builder();
        builder.setAuthority(((MicrosoftStsOAuth2Configuration)this.mConfig).getAuthorityUrl());
        if (((MicrosoftStsOAuth2Configuration)this.mConfig).getSlice() != null) {
            Logger.info(TAG + ":createAuthorizationRequestBuilder", "Setting slice params...");
            builder.setSlice(((MicrosoftStsOAuth2Configuration)this.mConfig).getSlice());
        }
        builder.setLibraryName((String)DiagnosticContext.INSTANCE.getRequestContext().get("x-client-SKU"));
        builder.setLibraryVersion(Device.getProductVersion());
        builder.setFlightParameters(((MicrosoftStsOAuth2Configuration)this.mConfig).getFlightParameters());
        builder.setMultipleCloudAware(((MicrosoftStsOAuth2Configuration)this.mConfig).getMultipleCloudsSupported());
        builder.setOpenIdProviderConfiguration(this.mOpenIdProviderConfiguration);
        return builder;
    }

    @Override
    public MicrosoftStsAuthorizationRequest.Builder createAuthorizationRequestBuilder(@Nullable IAccountRecord account) {
        String homeAccountId;
        Map.Entry<String, String> uidUtidKeyValuePair;
        String methodName = ":createAuthorizationRequestBuilder";
        Logger.info(TAG + ":createAuthorizationRequestBuilder", "Creating AuthorizationRequestBuilder");
        MicrosoftStsAuthorizationRequest.Builder builder = this.createAuthorizationRequestBuilder();
        if (null != account && !StringUtil.isNullOrEmpty((uidUtidKeyValuePair = StringUtil.getTenantInfo(homeAccountId = account.getHomeAccountId())).getKey()) && !StringUtil.isNullOrEmpty(uidUtidKeyValuePair.getValue())) {
            builder.setUid(uidUtidKeyValuePair.getKey());
            builder.setUtid(uidUtidKeyValuePair.getValue());
            Logger.infoPII(TAG + ":createAuthorizationRequestBuilder", "Builder w/ uid: [" + uidUtidKeyValuePair.getKey() + "]");
            Logger.infoPII(TAG + ":createAuthorizationRequestBuilder", "Builder w/ utid: [" + uidUtidKeyValuePair.getValue() + "]");
        }
        return builder;
    }

    @Override
    public MicrosoftStsTokenRequest createTokenRequest(@NonNull MicrosoftStsAuthorizationRequest request, @NonNull MicrosoftStsAuthorizationResponse response, @NonNull AbstractAuthenticationScheme authScheme) throws ClientException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        String methodName = ":createTokenRequest";
        Logger.verbose(TAG + ":createTokenRequest", "Creating TokenRequest...");
        if (((MicrosoftStsOAuth2Configuration)this.mConfig).getMultipleCloudsSupported() || request.getMultipleCloudAware().booleanValue()) {
            Logger.verbose(TAG, "get cloud specific authority based on authorization response.");
            this.setTokenEndpoint(this.getCloudSpecificTokenEndpoint(response));
        }
        MicrosoftStsTokenRequest tokenRequest = new MicrosoftStsTokenRequest();
        tokenRequest.setCodeVerifier(request.getPkceCodeVerifier());
        tokenRequest.setCode(response.getCode());
        tokenRequest.setRedirectUri(request.getRedirectUri());
        tokenRequest.setClientId(request.getClientId());
        tokenRequest.setScope(request.getTokenScope());
        tokenRequest.setClaims(request.getClaims());
        this.setTokenRequestCorrelationId(tokenRequest);
        if (response.getDeviceCode() != null) {
            tokenRequest.setGrantType("urn:ietf:params:oauth:grant-type:device_code");
            tokenRequest.setDeviceCode(response.getDeviceCode());
        } else {
            tokenRequest.setGrantType("authorization_code");
        }
        if (authScheme instanceof PopAuthenticationSchemeInternal) {
            tokenRequest.setTokenType("pop");
            IDevicePopManager devicePopManager = this.mStrategyParameters.getPlatformComponents().getDefaultDevicePopManager();
            if (!devicePopManager.asymmetricKeyExists()) {
                String thumbprint = devicePopManager.generateAsymmetricKey();
                Logger.verbosePII(TAG, "Generated new PoP asymmetric key with thumbprint: " + thumbprint);
            }
            String reqCnf = devicePopManager.getRequestConfirmation();
            tokenRequest.setRequestConfirmation(reqCnf);
        } else if (authScheme instanceof PopAuthenticationSchemeWithClientKeyInternal) {
            tokenRequest.setTokenType("pop");
            tokenRequest.setRequestConfirmation(((PopAuthenticationSchemeWithClientKeyInternal)authScheme).getRequestConfirmation());
        }
        return tokenRequest;
    }

    private void setTokenRequestCorrelationId(@NonNull MicrosoftStsTokenRequest tokenRequest) {
        if (tokenRequest == null) {
            throw new NullPointerException("tokenRequest is marked non-null but is null");
        }
        try {
            tokenRequest.setCorrelationId(UUID.fromString((String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id")));
        }
        catch (IllegalArgumentException ex) {
            Logger.error("MicrosoftSTSOAuth2Strategy", "Correlation id on diagnostic context is not a UUID.", ex);
        }
    }

    @Override
    public MicrosoftStsTokenRequest createRefreshTokenRequest(@NonNull AbstractAuthenticationScheme authScheme) throws ClientException {
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        String methodName = ":createRefreshTokenRequest";
        Logger.verbose(TAG + ":createRefreshTokenRequest", "Creating refresh token request");
        MicrosoftStsTokenRequest request = new MicrosoftStsTokenRequest();
        request.setGrantType("refresh_token");
        if (authScheme instanceof PopAuthenticationSchemeInternal) {
            request.setTokenType("pop");
            IDevicePopManager devicePopManager = this.mStrategyParameters.getPlatformComponents().getDefaultDevicePopManager();
            if (!devicePopManager.asymmetricKeyExists()) {
                devicePopManager.generateAsymmetricKey();
            }
            request.setRequestConfirmation(devicePopManager.getRequestConfirmation());
        } else if (authScheme instanceof PopAuthenticationSchemeWithClientKeyInternal) {
            request.setTokenType("pop");
            request.setRequestConfirmation(((PopAuthenticationSchemeWithClientKeyInternal)authScheme).getRequestConfirmation());
        }
        return request;
    }

    @Override
    public MicrosoftStsTokenRequest createRopcTokenRequest(@NonNull RopcTokenCommandParameters parameters) throws ClientException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String methodName = ":createPasswordTokenRequest";
        Logger.verbose(TAG + ":createPasswordTokenRequest", "Creating password token request");
        MicrosoftStsRopcTokenRequest request = new MicrosoftStsRopcTokenRequest();
        request.setGrantType("password");
        request.setUsername(parameters.getUsername());
        request.setPassword(parameters.getPassword());
        request.setClaims(parameters.getClaimsRequestJson());
        request.setClientId(parameters.getClientId());
        request.setRedirectUri(parameters.getRedirectUri());
        request.setScope(StringUtil.join(" ", parameters.getScopes()));
        this.setTokenRequestCorrelationId(request);
        if (AuthenticationSchemeFactory.isPopAuthenticationScheme(parameters.getAuthenticationScheme())) {
            throw new UnsupportedOperationException("MSAL Android supports ROPC on Bearer flows only for testing purposes.");
        }
        return request;
    }

    @Override
    protected void validateAuthorizationRequest(MicrosoftStsAuthorizationRequest request) {
    }

    @Override
    protected void validateTokenRequest(MicrosoftStsTokenRequest request) {
    }

    @Override
    protected HttpResponse performTokenRequest(MicrosoftStsTokenRequest request) throws IOException, ClientException {
        String methodName = ":performTokenRequest";
        HttpResponse response = super.performTokenRequest(request);
        if (response.getStatusCode() == 401 && response.getHeaders() != null && response.getHeaders().containsKey("WWW-Authenticate")) {
            Logger.info(TAG + ":performTokenRequest", "Receiving device certificate challenge request. ");
            return this.performPKeyAuthRequest(response, request);
        }
        return response;
    }

    private HttpResponse performPKeyAuthRequest(@NonNull HttpResponse response, @NonNull MicrosoftStsTokenRequest request) throws IOException, ClientException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String methodName = "#performPkeyAuthRequest";
        String requestBody = ObjectMapper.serializeObjectToFormUrlEncoded(request);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("client-request-id", (String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id"));
        headers.putAll(Device.getPlatformIdParameters());
        headers.put("x-client-SKU", (String)DiagnosticContext.INSTANCE.getRequestContext().get("x-client-SKU"));
        headers.put("x-client-Ver", Device.getProductVersion());
        headers.put("x-app-name", request.getClientAppName());
        headers.put("x-app-ver", request.getClientAppVersion());
        String challengeHeader = response.getHeaders().get("WWW-Authenticate").get(0);
        Logger.info(TAG + "#performPkeyAuthRequest", "Device certificate challenge request. ");
        Logger.infoPII(TAG + "#performPkeyAuthRequest", "Challenge header: " + challengeHeader);
        try {
            PKeyAuthChallengeFactory factory = new PKeyAuthChallengeFactory();
            URL authority = new URL(this.mTokenEndpoint);
            PKeyAuthChallenge pkeyAuthChallenge = factory.getPKeyAuthChallengeFromTokenEndpointResponse(challengeHeader, authority.toString());
            headers.putAll(pkeyAuthChallenge.getChallengeHeader());
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            return this.httpClient.post(authority, headers, requestBody.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException exception) {
            throw new ClientException("unsupported_encoding", "Unsupported encoding", exception);
        }
    }

    @Override
    @NonNull
    protected TokenResult getTokenResultFromHttpResponse(@NonNull HttpResponse response) throws ClientException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String methodName = ":getTokenResultFromHttpResponse";
        Logger.verbose(TAG + ":getTokenResultFromHttpResponse", "Getting TokenResult from HttpResponse...");
        MicrosoftStsTokenResponse tokenResponse = null;
        TokenErrorResponse tokenErrorResponse = null;
        if (response.getStatusCode() >= 400) {
            tokenErrorResponse = ObjectMapper.deserializeJsonStringToObject(this.getBodyFromUnsuccessfulResponse(response.getBody()), MicrosoftTokenErrorResponse.class);
            tokenErrorResponse.setStatusCode(response.getStatusCode());
            if (null != response.getHeaders()) {
                tokenErrorResponse.setResponseHeadersJson(HeaderSerializationUtil.toJson(response.getHeaders()));
            }
            tokenErrorResponse.setResponseBody(response.getBody());
        } else {
            tokenResponse = ObjectMapper.deserializeJsonStringToObject(this.getBodyFromSuccessfulResponse(response.getBody()), MicrosoftStsTokenResponse.class);
        }
        TokenResult result = new TokenResult(tokenResponse, tokenErrorResponse);
        ResultUtil.logResult(TAG, result);
        if (null != response.getHeaders()) {
            String ccsRequestId;
            Map<String, List<String>> responseHeaders = response.getHeaders();
            List<String> cliTelemValues = responseHeaders.get("x-ms-clitelem");
            if (null != cliTelemValues && !cliTelemValues.isEmpty()) {
                String cliTelemHeader = cliTelemValues.get(0);
                CliTelemInfo cliTelemInfo = CliTelemInfo.fromXMsCliTelemHeader(cliTelemHeader);
                result.setCliTelemInfo(cliTelemInfo);
                if (null != tokenResponse && null != cliTelemInfo) {
                    tokenResponse.setSpeRing(cliTelemInfo.getSpeRing());
                    tokenResponse.setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
                    tokenResponse.setCliTelemErrorCode(cliTelemInfo.getServerErrorCode());
                    tokenResponse.setCliTelemSubErrorCode(cliTelemInfo.getServerSubErrorCode());
                }
            }
            if (null != (ccsRequestId = response.getHeaderValue("xms-ccs-requestid", 0))) {
                if (CommonFlightManager.isFlightEnabled(CommonFlight.EXPOSE_CCS_REQUEST_ID_IN_TOKENRESPONSE) && null != tokenResponse) {
                    HashMap<String, String> mapWithAdditionalEntry = new HashMap<String, String>();
                    mapWithAdditionalEntry.put("xms-ccs-requestid", ccsRequestId);
                    if (null != tokenResponse.getExtraParameters()) {
                        for (Map.Entry<String, String> entry : tokenResponse.getExtraParameters()) {
                            mapWithAdditionalEntry.put(entry.getKey(), entry.getValue());
                        }
                    }
                    tokenResponse.setExtraParameters(mapWithAdditionalEntry.entrySet());
                }
                SpanExtension.current().setAttribute(AttributeName.ccs_request_id.name(), ccsRequestId);
            }
        }
        return result;
    }

    protected String getBodyFromSuccessfulResponse(@NonNull String responseBody) throws ClientException {
        if (responseBody == null) {
            throw new NullPointerException("responseBody is marked non-null but is null");
        }
        return responseBody;
    }

    protected String getBodyFromUnsuccessfulResponse(@NonNull String responseBody) throws ClientException {
        if (responseBody == null) {
            throw new NullPointerException("responseBody is marked non-null but is null");
        }
        String EMPTY_JSON_OBJECT = "{}";
        return responseBody.isEmpty() ? "{}" : responseBody;
    }

    @Override
    protected void validateTokenResponse(@NonNull MicrosoftStsTokenRequest request, @NonNull MicrosoftStsTokenResponse response) throws ClientException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.validateAuthScheme(request, response);
        this.validateTokensAreInResponse(request, response);
    }

    private void validateAuthScheme(@NonNull MicrosoftStsTokenRequest request, @NonNull MicrosoftStsTokenResponse response) throws ClientException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String requestTokenType = request.getTokenType();
        String responseAuthScheme = response.getTokenType();
        if (requestTokenType != null && !requestTokenType.equalsIgnoreCase(responseAuthScheme)) {
            throw new ClientException("auth_scheme_mismatch", "Expected: [" + requestTokenType + "]\nActual: [" + responseAuthScheme + "]");
        }
    }

    private void validateTokensAreInResponse(@NonNull MicrosoftStsTokenRequest request, @NonNull MicrosoftStsTokenResponse response) throws ClientException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String clientException = null;
        String tokens = "";
        String tokensMissingMessage = "Missing required tokens of type: %s";
        if (!StringUtil.containsSubString(request.getScope(), "urn:aad:tb:update:prt/.default") && StringUtil.isNullOrEmpty(response.getAccessToken())) {
            clientException = "tokens_missing";
            tokens = tokens.concat("access_token");
        }
        if (!"client_credentials".equalsIgnoreCase(request.getGrantType()) && StringUtil.isNullOrEmpty(response.getIdToken())) {
            clientException = "tokens_missing";
            tokens = tokens.concat(" id_token");
        }
        if (!"client_credentials".equalsIgnoreCase(request.getGrantType()) && StringUtil.isNullOrEmpty(response.getRefreshToken())) {
            clientException = "tokens_missing";
            tokens = tokens.concat(" refresh_token");
        }
        if (clientException != null) {
            throw new ClientException(clientException, String.format("Missing required tokens of type: %s", tokens));
        }
    }

    private String buildCloudSpecificTokenEndpoint(@NonNull MicrosoftStsAuthorizationResponse response) throws ClientException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (!StringUtil.isNullOrEmpty(response.getCloudInstanceHostName())) {
            try {
                return new CommonURIBuilder(this.mTokenEndpoint).setHost(response.getCloudInstanceHostName()).build().toString();
            }
            catch (URISyntaxException e) {
                throw new ClientException("malformed_url", "Failed to construct token endpoint from getCloudInstanceHostName()", e);
            }
        }
        return this.mTokenEndpoint;
    }

    private String getCloudSpecificTokenEndpoint(MicrosoftAuthorizationResponse response) throws ClientException {
        if (StringUtil.isNullOrEmpty(response.getCloudInstanceHostName())) {
            return this.mTokenEndpoint;
        }
        return this.buildCloudSpecificTokenEndpoint((MicrosoftStsAuthorizationResponse)response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getDeviceAtPopThumbprint() {
        if (this.mStrategyParameters.getAuthenticationScheme() instanceof PopAuthenticationSchemeWithClientKeyInternal) {
            return ((PopAuthenticationSchemeWithClientKeyInternal)this.mStrategyParameters.getAuthenticationScheme()).getKid();
        }
        String atPoPKid = null;
        IDevicePopManager devicePopManager = null;
        try {
            devicePopManager = this.mStrategyParameters.getPlatformComponents().getDefaultDevicePopManager();
        }
        catch (ClientException e) {
            Logger.error(TAG, e.getMessage(), e);
        }
        if (null != devicePopManager) {
            if (!devicePopManager.asymmetricKeyExists()) throw new RuntimeException("Symmetric keys do not exist.");
            try {
                return devicePopManager.getAsymmetricKeyThumbprint();
            }
            catch (ClientException e) {
                Logger.error(TAG, "Key exists. But failed to load thumbprint.", e);
                throw new RuntimeException(e);
            }
        }
        Logger.warn(TAG, "DevicePopManager does not exist.");
        return atPoPKid;
    }

    @Override
    public boolean validateCachedResult(@NonNull AbstractAuthenticationScheme authScheme, @NonNull ICacheRecord cacheRecord) {
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        if (cacheRecord == null) {
            throw new NullPointerException("cacheRecord is marked non-null but is null");
        }
        super.validateCachedResult(authScheme, cacheRecord);
        if (authScheme instanceof PopAuthenticationSchemeInternal) {
            return this.cachedAccessTokenKidMatchesKeystoreKid(cacheRecord.getAccessToken().getKid());
        }
        if (authScheme instanceof PopAuthenticationSchemeWithClientKeyInternal) {
            return ((PopAuthenticationSchemeWithClientKeyInternal)authScheme).getKid().equalsIgnoreCase(cacheRecord.getAccessToken().getKid());
        }
        return true;
    }

    private boolean cachedAccessTokenKidMatchesKeystoreKid(@Nullable String atKid) {
        String deviceKid = this.getDeviceAtPopThumbprint();
        if (StringUtil.isNullOrEmpty(deviceKid)) {
            return false;
        }
        return deviceKid.equals(atKid);
    }

    private void loadOpenIdProviderConfiguration() {
        try {
            OpenIdProviderConfigurationClient client = new OpenIdProviderConfigurationClient();
            this.mOpenIdProviderConfiguration = client.loadOpenIdProviderConfigurationFromAuthority(((MicrosoftStsOAuth2Configuration)this.mConfig).getAuthorityUrl().toString());
        }
        catch (ServiceException e) {
            Logger.error(TAG, "There was a problem with loading the openIdConfiguration", e);
        }
    }

    @SuppressFBWarnings
    private void loadOpenIdProviderConfiguration(@NonNull String extraParams) {
        if (extraParams == null) {
            throw new NullPointerException("extraParams is marked non-null but is null");
        }
        try {
            OpenIdProviderConfigurationClient client = new OpenIdProviderConfigurationClient();
            this.mOpenIdProviderConfiguration = client.loadOpenIdProviderConfigurationFromAuthorityWithExtraParams(((MicrosoftStsOAuth2Configuration)this.mConfig).getAuthorityUrl().toString(), extraParams);
        }
        catch (ServiceException e) {
            Logger.error(TAG, "There was a problem with loading the openIdConfiguration", e);
        }
    }
}

