/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.google.gson.Gson;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.net.HttpClient;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdProviderConfiguration;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.TaskCompletedCallbackWithError;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.NonNull;

public class OpenIdProviderConfigurationClient {
    private static final String TAG = OpenIdProviderConfigurationClient.class.getSimpleName();
    private static final String HTTPS_SCHEME = "https";
    private static final String WELL_KNOWN_CONFIG_HOST = "login.microsoftonline.com";
    private static final String WELL_KNOWN_CONFIG_PATH = "/.well-known/openid-configuration";
    private static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();
    private static final Map<URI, OpenIdProviderConfiguration> sConfigCache = new HashMap<URI, OpenIdProviderConfiguration>();
    private static final HttpClient httpClient = UrlConnectionHttpClient.getDefaultInstance();
    private static final Gson GSON = new Gson();

    private String sanitize(@NonNull String issuer) {
        if (issuer == null) {
            throw new NullPointerException("issuer is marked non-null but is null");
        }
        String sanitizedIssuer = issuer.trim();
        if (issuer.endsWith("/")) {
            sanitizedIssuer = issuer.substring(0, sanitizedIssuer.length() - 1);
        }
        return sanitizedIssuer;
    }

    public void loadOpenIdProviderConfiguration(final @NonNull OpenIdProviderConfigurationCallback callback, final @NonNull String authority) {
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (authority == null) {
            throw new NullPointerException("authority is marked non-null but is null");
        }
        sBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onTaskCompleted(OpenIdProviderConfigurationClient.this.loadOpenIdProviderConfigurationFromAuthority(authority));
                }
                catch (ServiceException e) {
                    callback.onError(e);
                }
            }
        });
    }

    public synchronized OpenIdProviderConfiguration loadOpenIdProviderConfigurationFromTenant(@NonNull String tenantIdentifier) throws ServiceException {
        if (tenantIdentifier == null) {
            throw new NullPointerException("tenantIdentifier is marked non-null but is null");
        }
        try {
            String tenantedAuthorityUrl = new CommonURIBuilder().setScheme(HTTPS_SCHEME).setHost(WELL_KNOWN_CONFIG_HOST).setPathSegments(new String[]{tenantIdentifier}).build().toString();
            return this.loadOpenIdProviderConfigurationInternal(tenantedAuthorityUrl, null);
        }
        catch (URISyntaxException e) {
            throw new ServiceException("failed_to_load_openid_configuration", "IOException while requesting metadata", e);
        }
    }

    public synchronized OpenIdProviderConfiguration loadOpenIdProviderConfigurationFromAuthority(@NonNull String authorityUrl) throws ServiceException {
        if (authorityUrl == null) {
            throw new NullPointerException("authorityUrl is marked non-null but is null");
        }
        return this.loadOpenIdProviderConfigurationInternal(authorityUrl, null);
    }

    public synchronized OpenIdProviderConfiguration loadOpenIdProviderConfigurationFromAuthorityWithExtraParams(@NonNull String authorityUrl, @NonNull String extraParams) throws ServiceException {
        if (authorityUrl == null) {
            throw new NullPointerException("authorityUrl is marked non-null but is null");
        }
        if (extraParams == null) {
            throw new NullPointerException("extraParams is marked non-null but is null");
        }
        return this.loadOpenIdProviderConfigurationInternal(authorityUrl, extraParams);
    }

    private synchronized OpenIdProviderConfiguration loadOpenIdProviderConfigurationInternal(@NonNull String tenantedAuthorityString, String extraParams) throws ServiceException {
        if (tenantedAuthorityString == null) {
            throw new NullPointerException("tenantedAuthorityString is marked non-null but is null");
        }
        String methodName = ":loadOpenIdProviderConfiguration";
        try {
            String uriString = extraParams != null ? this.sanitize(tenantedAuthorityString) + WELL_KNOWN_CONFIG_PATH + extraParams : this.sanitize(tenantedAuthorityString) + WELL_KNOWN_CONFIG_PATH;
            URI configUrl = new URI(uriString);
            OpenIdProviderConfiguration cacheResult = sConfigCache.get(configUrl);
            if (null != cacheResult) {
                Logger.info(TAG + ":loadOpenIdProviderConfiguration", "Using cached metadata result.");
                return cacheResult;
            }
            Logger.verbose(TAG + ":loadOpenIdProviderConfiguration", "Config URL is valid.");
            Logger.verbosePII(TAG + ":loadOpenIdProviderConfiguration", "Using request URL: " + configUrl);
            HttpResponse providerConfigResponse = httpClient.get(configUrl.toURL(), new HashMap<String, String>());
            int statusCode = providerConfigResponse.getStatusCode();
            if (200 != statusCode || StringUtil.isNullOrEmpty(providerConfigResponse.getBody())) {
                throw new ServiceException("failed_to_load_openid_configuration", "OpenId Provider Configuration metadata failed to load with status: " + statusCode, null);
            }
            OpenIdProviderConfiguration parsedConfig = this.parseMetadata(providerConfigResponse.getBody());
            this.cacheConfiguration(configUrl, parsedConfig);
            return parsedConfig;
        }
        catch (IOException | URISyntaxException e) {
            throw new ServiceException("failed_to_load_openid_configuration", "IOException while requesting metadata", e);
        }
    }

    private void cacheConfiguration(@NonNull URI configUrl, @NonNull OpenIdProviderConfiguration parsedConfig) {
        if (configUrl == null) {
            throw new NullPointerException("configUrl is marked non-null but is null");
        }
        if (parsedConfig == null) {
            throw new NullPointerException("parsedConfig is marked non-null but is null");
        }
        sConfigCache.put(configUrl, parsedConfig);
    }

    private OpenIdProviderConfiguration parseMetadata(@NonNull String body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return (OpenIdProviderConfiguration)GSON.fromJson(body, OpenIdProviderConfiguration.class);
    }

    public static interface OpenIdProviderConfigurationCallback
    extends TaskCompletedCallbackWithError<OpenIdProviderConfiguration, Exception> {
    }
}

