/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.registry;

import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.java.cache.NameValueStorageFileManagerSimpleCacheImpl;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.registry.BrokerApplicationRegistryData;
import com.microsoft.identity.common.java.registry.IBrokerApplicationRegistry;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Type;
import java.util.List;
import lombok.NonNull;

public class DefaultBrokerApplicationRegistry
extends NameValueStorageFileManagerSimpleCacheImpl<BrokerApplicationRegistryData>
implements IBrokerApplicationRegistry {
    private static final String TAG = DefaultBrokerApplicationRegistry.class.getSimpleName();
    private static final String DEFAULT_APP_REGISTRY_CACHE_NAME = "com.microsoft.identity.app-registry";
    private static final String KEY_APP_REGISTRY = "app-registry";

    public DefaultBrokerApplicationRegistry(@NonNull IPlatformComponents context) {
        super(context, DEFAULT_APP_REGISTRY_CACHE_NAME, KEY_APP_REGISTRY);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    @Override
    public Type getListTypeToken() {
        return TypeToken.getParameterized(List.class, (Type[])new Type[]{BrokerApplicationRegistryData.class}).getType();
    }

    @Override
    public BrokerApplicationRegistryData getMetadata(@NonNull String clientId, @Nullable String environment, int processUid) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        String methodName = ":getMetadata";
        List allMetadata = this.getAll();
        BrokerApplicationRegistryData result = null;
        for (BrokerApplicationRegistryData metadata : allMetadata) {
            if (!clientId.equals(metadata.getClientId()) || processUid != metadata.getUid() || null != environment && !environment.equals(metadata.getEnvironment())) continue;
            Logger.verbose(TAG + metadata, "Metadata located.");
            result = metadata;
            break;
        }
        if (null == result) {
            Logger.warn(TAG + ":getMetadata", "Metadata could not be found for clientId, environment: [" + clientId + ", " + environment + "]");
        }
        return result;
    }
}

