/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.IResult;
import com.microsoft.identity.common.java.util.ObjectMapper;
import lombok.NonNull;

public class ResultUtil {
    public static void logResult(@NonNull String tag, @NonNull IResult result) {
        AuthorizationResult authResult;
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        String TAG = tag + ":" + result.getClass().getSimpleName();
        if (result.getSuccess()) {
            Logger.info(TAG, "Success Result");
            ResultUtil.logExposedFieldsOfObject(TAG, result.getSuccessResponse());
        } else {
            Logger.warn(TAG, "Failure Result");
            if (result.getErrorResponse() != null) {
                if (result.getErrorResponse().getError() != null) {
                    Logger.warn(TAG, "Error: " + result.getErrorResponse().getError());
                }
                if (result.getErrorResponse().getErrorDescription() != null) {
                    Logger.warnPII(TAG, "Description: " + result.getErrorResponse().getErrorDescription());
                }
                ResultUtil.logExposedFieldsOfObject(TAG, result.getErrorResponse());
            }
        }
        if (result instanceof AuthorizationResult && (authResult = (AuthorizationResult)result).getAuthorizationStatus() != null) {
            Logger.info(TAG, "Authorization Status: " + authResult.getAuthorizationStatus().toString());
        }
    }

    public static void logExposedFieldsOfObject(@NonNull String tag, @NonNull Object object) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        String TAG = tag + ":" + object.getClass().getSimpleName();
        Logger.info(TAG, ObjectMapper.serializeExposedFieldsOfObjectToJsonString(object));
    }
}

