/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authorities;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.authorities.AccountsInOneOrganization;
import com.microsoft.identity.common.java.authorities.AllAccounts;
import com.microsoft.identity.common.java.authorities.AnyOrganizationalAccount;
import com.microsoft.identity.common.java.authorities.AnyPersonalAccount;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdProviderConfiguration;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdProviderConfigurationClient;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;

public abstract class AzureActiveDirectoryAudience {
    private static final String TAG = AzureActiveDirectoryAudience.class.getSimpleName();
    private String mCloudUrl;
    @SerializedName(value="tenant_id")
    private String mTenantId;
    public static final String ORGANIZATIONS = "organizations";
    public static final String CONSUMERS = "consumers";
    public static final String ALL = "common";
    public static final String MSA_MEGA_TENANT_ID = "9188040d-6c67-4c5b-b112-36a304b66dad";

    public String getCloudUrl() {
        if (this.mCloudUrl == null) {
            return AzureActiveDirectory.getDefaultCloudUrl();
        }
        return this.mCloudUrl;
    }

    public void setCloudUrl(String cloudUrl) {
        this.mCloudUrl = cloudUrl;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public String getTenantUuidForAlias(@NonNull String authority) throws ServiceException, ClientException {
        CommonURIBuilder issuerUri;
        if (authority == null) {
            throw new NullPointerException("authority is marked non-null but is null");
        }
        if (StringUtil.isUuid(this.mTenantId)) {
            return this.mTenantId;
        }
        OpenIdProviderConfiguration providerConfiguration = AzureActiveDirectoryAudience.loadOpenIdProviderConfigurationMetadata(authority);
        String issuer = providerConfiguration.getIssuer();
        try {
            issuerUri = new CommonURIBuilder(issuer);
        }
        catch (URISyntaxException e) {
            throw new ClientException("malformed_url", "Failed to construct issuerUri", e);
        }
        List paths = issuerUri.getPathSegments();
        if (paths.isEmpty()) {
            String errMsg = "OpenId Metadata did not contain a path to the tenant";
            Logger.error(TAG, "OpenId Metadata did not contain a path to the tenant", null);
            throw new ClientException("OpenId Metadata did not contain a path to the tenant");
        }
        String tenantUUID = (String)paths.get(0);
        if (!StringUtil.isUuid(tenantUUID)) {
            String errMsg = "OpenId Metadata did not contain UUID in the path ";
            Logger.error(TAG, "OpenId Metadata did not contain UUID in the path ", null);
            throw new ClientException("OpenId Metadata did not contain UUID in the path ");
        }
        return tenantUUID;
    }

    public static boolean isHomeTenantAlias(@NonNull String tenantId) {
        if (tenantId == null) {
            throw new NullPointerException("tenantId is marked non-null but is null");
        }
        return tenantId.equalsIgnoreCase(ALL) || tenantId.equalsIgnoreCase(CONSUMERS) || tenantId.equalsIgnoreCase(ORGANIZATIONS);
    }

    private static OpenIdProviderConfiguration loadOpenIdProviderConfigurationMetadata(@NonNull String requestAuthority) throws ServiceException, ClientException {
        if (requestAuthority == null) {
            throw new NullPointerException("requestAuthority is marked non-null but is null");
        }
        String methodName = ":loadOpenIdProviderConfigurationMetadata";
        Logger.info(TAG + ":loadOpenIdProviderConfigurationMetadata", "Loading OpenId Provider Metadata...");
        OpenIdProviderConfigurationClient client = new OpenIdProviderConfigurationClient();
        return client.loadOpenIdProviderConfigurationFromAuthority(requestAuthority);
    }

    public void setTenantId(String tenantId) {
        this.mTenantId = tenantId;
    }

    public static AzureActiveDirectoryAudience getAzureActiveDirectoryAudience(String cloudUrl, String tenantId) {
        String methodName = ":getAzureActiveDirectoryAudience";
        AzureActiveDirectoryAudience audience = null;
        switch (tenantId.toLowerCase(Locale.ROOT)) {
            case "organizations": {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AnyOrganizationalAccount");
                audience = new AnyOrganizationalAccount(cloudUrl);
                break;
            }
            case "consumers": {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AnyPersonalAccount");
                audience = new AnyPersonalAccount(cloudUrl);
                break;
            }
            case "common": {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AllAccounts");
                audience = new AllAccounts(cloudUrl);
                break;
            }
            default: {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AccountsInOneOrganization");
                audience = new AccountsInOneOrganization(cloudUrl, tenantId);
            }
        }
        return audience;
    }
}

