/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authorities;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.authorities.AllAccounts;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public class AzureActiveDirectoryAuthority
extends Authority {
    private static final transient String TAG = AzureActiveDirectoryAuthority.class.getSimpleName();
    @SerializedName(value="audience")
    public AzureActiveDirectoryAudience mAudience;
    @SerializedName(value="flight_parameters")
    public Map<String, String> mFlightParameters;
    private boolean mMultipleCloudsSupported = false;

    @Nullable
    private static synchronized AzureActiveDirectoryCloud getAzureActiveDirectoryCloud(@NonNull AzureActiveDirectoryAudience audience) {
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        String methodName = ":getAzureActiveDirectoryCloud";
        try {
            return AzureActiveDirectory.getAzureActiveDirectoryCloud(new URL(audience.getCloudUrl()));
        }
        catch (MalformedURLException e) {
            Logger.errorPII(TAG + ":getAzureActiveDirectoryCloud", "AAD cloud URL was malformed.", e);
            return null;
        }
    }

    public AzureActiveDirectoryAuthority(AzureActiveDirectoryAudience signInAudience) {
        this.mAudience = signInAudience;
        this.mAuthorityTypeString = "AAD";
    }

    public AzureActiveDirectoryAuthority() {
        this.mAudience = new AllAccounts();
        this.mAuthorityTypeString = "AAD";
        this.mMultipleCloudsSupported = false;
    }

    @Override
    public URI getAuthorityUri() {
        try {
            AzureActiveDirectoryCloud cloud = AzureActiveDirectoryAuthority.getAzureActiveDirectoryCloud(this.mAudience);
            CommonURIBuilder issuer = cloud == null ? new CommonURIBuilder(this.mAudience.getCloudUrl()) : new CommonURIBuilder("https://" + cloud.getPreferredNetworkHostName());
            if (!StringUtil.isNullOrEmpty(this.mAudience.getTenantId())) {
                ArrayList<String> pathSegments = new ArrayList<String>(issuer.getPathSegments());
                pathSegments.add(this.mAudience.getTenantId());
                issuer.setPathSegments(pathSegments);
            }
            return issuer.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Authority URI is invalid.", e);
        }
    }

    protected MicrosoftStsOAuth2Configuration createOAuth2Configuration() {
        String methodName = ":createOAuth2Configuration";
        Logger.verbose(TAG + ":createOAuth2Configuration", "Creating OAuth2Configuration");
        MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
        config.setAuthorityUrl(this.getAuthorityURL());
        if (this.mSlice != null) {
            Logger.info(TAG + ":createOAuth2Configuration", "Setting slice parameters...");
            AzureActiveDirectorySlice slice = new AzureActiveDirectorySlice();
            slice.setSlice(this.mSlice.getSlice());
            slice.setDataCenter(this.mSlice.getDataCenter());
            config.setSlice(slice);
        }
        if (this.mFlightParameters != null) {
            Logger.info(TAG + ":createOAuth2Configuration", "Setting flight parameters...");
            for (Map.Entry<String, String> entry : this.mFlightParameters.entrySet()) {
                config.getFlightParameters().put(entry.getKey(), entry.getValue());
            }
        }
        config.setMultipleCloudsSupported(this.mMultipleCloudsSupported);
        return config;
    }

    @Override
    public OAuth2Strategy createOAuth2Strategy(@NonNull OAuth2StrategyParameters parameters) throws ClientException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        MicrosoftStsOAuth2Configuration config = this.createOAuth2Configuration();
        return new MicrosoftStsOAuth2Strategy(config, parameters);
    }

    public synchronized boolean isSameCloudAsAuthority(@NonNull AzureActiveDirectoryAuthority authorityToCheck) throws IOException, URISyntaxException {
        if (authorityToCheck == null) {
            throw new NullPointerException("authorityToCheck is marked non-null but is null");
        }
        if (!AzureActiveDirectory.isInitialized()) {
            AzureActiveDirectory.performCloudDiscovery();
        }
        AzureActiveDirectoryCloud cloudOfThisAuthority = AzureActiveDirectoryAuthority.getAzureActiveDirectoryCloud(this.mAudience);
        AzureActiveDirectoryCloud cloudOfAuthorityToCheck = AzureActiveDirectoryAuthority.getAzureActiveDirectoryCloud(authorityToCheck.getAudience());
        if (cloudOfThisAuthority == null && cloudOfAuthorityToCheck == null) {
            return false;
        }
        return Objects.equals(cloudOfThisAuthority, cloudOfAuthorityToCheck);
    }

    @NonNull
    public static String convertToDefaultAuthority(@NonNull String authorityUrl) throws ClientException {
        if (authorityUrl == null) {
            throw new NullPointerException("authorityUrl is marked non-null but is null");
        }
        try {
            CommonURIBuilder builder = new CommonURIBuilder(authorityUrl);
            builder.setPath("common");
            return builder.toString();
        }
        catch (URISyntaxException e) {
            throw new ClientException("malformed_url", "Cannot construct common authority URL", e);
        }
    }

    public AzureActiveDirectoryAudience getAudience() {
        return this.mAudience;
    }

    public boolean isMultipleCloudsSupported() {
        return this.mMultipleCloudsSupported;
    }

    public void setMultipleCloudsSupported(boolean mMultipleCloudsSupported) {
        this.mMultipleCloudsSupported = mMultipleCloudsSupported;
    }
}

