/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.google.gson.Gson;
import com.microsoft.identity.common.java.cache.IListTypeToken;
import com.microsoft.identity.common.java.cache.ISimpleCache;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public abstract class NameValueStorageFileManagerSimpleCacheImpl<T>
implements ISimpleCache<T>,
IListTypeToken {
    private static final String TAG = NameValueStorageFileManagerSimpleCacheImpl.class.getSimpleName();
    private static final String EMTPY_ARRAY = "[]";
    private static final String TIMING_TAG = "execWithTiming";
    private final IPlatformComponents mComponents;
    private final INameValueStorage<String> mStorage;
    private final String mKeySingleEntry;
    private final boolean mForceReinsertionOfDuplicates;
    private final Gson mGson = new Gson();

    public NameValueStorageFileManagerSimpleCacheImpl(@NonNull IPlatformComponents components, @NonNull String name, @NonNull String singleKey) {
        this(components, name, singleKey, false);
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (singleKey == null) {
            throw new NullPointerException("singleKey is marked non-null but is null");
        }
    }

    public NameValueStorageFileManagerSimpleCacheImpl(@NonNull IPlatformComponents components, @NonNull String name, @NonNull String singleKey, boolean forceReinsertionOfDuplicates) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (singleKey == null) {
            throw new NullPointerException("singleKey is marked non-null but is null");
        }
        Logger.verbose(TAG + "::ctor", "Init");
        this.mComponents = components;
        this.mStorage = components.getStorageSupplier().getUnencryptedNameValueStore(name, String.class);
        this.mKeySingleEntry = singleKey;
        this.mForceReinsertionOfDuplicates = forceReinsertionOfDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V execWithTiming(@NonNull NamedRunnable<V> runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        long startTime = this.mComponents.getPlatformUtil().getNanosecondTime();
        V v = null;
        try {
            v = runnable.call();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Logger.error(TAG + TIMING_TAG, "Error during operation", e);
        }
        finally {
            long execTime = this.mComponents.getPlatformUtil().getNanosecondTime() - startTime;
            Logger.verbose(TAG + TIMING_TAG, runnable.getName() + " finished in: " + execTime + " " + TimeUnit.NANOSECONDS.name());
        }
        return v;
    }

    @Override
    public boolean insert(final T t) {
        return this.execWithTiming(new NamedRunnable<Boolean>(){

            @Override
            public String getName() {
                return "insert";
            }

            @Override
            public Boolean call() {
                HashSet allMetadata = new HashSet(NameValueStorageFileManagerSimpleCacheImpl.this.getAll());
                if (NameValueStorageFileManagerSimpleCacheImpl.this.mForceReinsertionOfDuplicates) {
                    allMetadata.remove(t);
                }
                allMetadata.add(t);
                String json = NameValueStorageFileManagerSimpleCacheImpl.this.mGson.toJson(allMetadata);
                NameValueStorageFileManagerSimpleCacheImpl.this.mStorage.put(NameValueStorageFileManagerSimpleCacheImpl.this.mKeySingleEntry, json);
                return true;
            }
        });
    }

    @Override
    public boolean remove(final T t) {
        return this.execWithTiming(new NamedRunnable<Boolean>(){

            @Override
            public String getName() {
                return "remove";
            }

            @Override
            public Boolean call() {
                HashSet allMetadata = new HashSet(NameValueStorageFileManagerSimpleCacheImpl.this.getAll());
                allMetadata.remove(t);
                String json = NameValueStorageFileManagerSimpleCacheImpl.this.mGson.toJson(allMetadata);
                NameValueStorageFileManagerSimpleCacheImpl.this.mStorage.put(NameValueStorageFileManagerSimpleCacheImpl.this.mKeySingleEntry, json);
                return true;
            }
        });
    }

    @Override
    public List<T> getAll() {
        return (List)this.execWithTiming(new NamedRunnable<List<T>>(){

            @Override
            public String getName() {
                return "getAll";
            }

            @Override
            public List<T> call() {
                String jsonList = (String)NameValueStorageFileManagerSimpleCacheImpl.this.mStorage.get(NameValueStorageFileManagerSimpleCacheImpl.this.mKeySingleEntry);
                if (StringUtil.isNullOrEmpty(jsonList)) {
                    jsonList = NameValueStorageFileManagerSimpleCacheImpl.EMTPY_ARRAY;
                }
                List result = (List)NameValueStorageFileManagerSimpleCacheImpl.this.mGson.fromJson(jsonList, NameValueStorageFileManagerSimpleCacheImpl.this.getListTypeToken());
                return result;
            }
        });
    }

    @Override
    public boolean clear() {
        return this.execWithTiming(new NamedRunnable<Boolean>(){

            @Override
            public String getName() {
                return "clear";
            }

            @Override
            public Boolean call() {
                NameValueStorageFileManagerSimpleCacheImpl.this.mStorage.clear();
                return true;
            }
        });
    }

    private static interface NamedRunnable<V>
    extends Callable<V> {
        public String getName();
    }
}

