/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands;

import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.ICommand;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
public abstract class BaseCommand<T>
implements ICommand<T> {
    @NonNull
    private final CommandParameters parameters;
    @NonNull
    private final CommandCallback callback;
    @NonNull
    private final List<BaseController> controllers;
    @NonNull
    private final String publicApiId;

    public BaseCommand(@NonNull CommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
        this.parameters = parameters;
        this.callback = callback;
        this.controllers = Collections.unmodifiableList(Arrays.asList(controller));
        this.publicApiId = publicApiId;
    }

    public BaseCommand(@NonNull CommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controllers == null) {
            throw new NullPointerException("controllers is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
        this.parameters = parameters;
        this.controllers = Collections.unmodifiableList(new ArrayList<BaseController>(controllers));
        this.callback = callback;
        this.publicApiId = publicApiId;
    }

    @Override
    public abstract T execute() throws Exception;

    public BaseController getDefaultController() {
        return this.controllers.get(0);
    }

    @Override
    public boolean isEligibleForCaching() {
        return false;
    }

    @Override
    public String getCorrelationId() {
        return this.getParameters().getCorrelationId();
    }

    @Override
    public boolean willReachTokenEndpoint() {
        return false;
    }

    protected BaseCommand(BaseCommandBuilder<T, ?, ?> b) {
        this.parameters = ((BaseCommandBuilder)b).parameters;
        if (this.parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.callback = ((BaseCommandBuilder)b).callback;
        if (this.callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        this.controllers = ((BaseCommandBuilder)b).controllers;
        if (this.controllers == null) {
            throw new NullPointerException("controllers is marked non-null but is null");
        }
        this.publicApiId = ((BaseCommandBuilder)b).publicApiId;
        if (this.publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
    }

    @NonNull
    public CommandParameters getParameters() {
        return this.parameters;
    }

    @NonNull
    public CommandCallback getCallback() {
        return this.callback;
    }

    @NonNull
    public List<BaseController> getControllers() {
        return this.controllers;
    }

    @NonNull
    public String getPublicApiId() {
        return this.publicApiId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCommand)) {
            return false;
        }
        BaseCommand other = (BaseCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommandParameters this$parameters = this.getParameters();
        CommandParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<BaseController> this$controllers = this.getControllers();
        List<BaseController> other$controllers = other.getControllers();
        return !(this$controllers == null ? other$controllers != null : !((Object)this$controllers).equals(other$controllers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommandParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List<BaseController> $controllers = this.getControllers();
        result = result * 59 + ($controllers == null ? 43 : ((Object)$controllers).hashCode());
        return result;
    }

    public static abstract class BaseCommandBuilder<T, C extends BaseCommand<T>, B extends BaseCommandBuilder<T, C, B>> {
        private CommandParameters parameters;
        private CommandCallback callback;
        private List<BaseController> controllers;
        private String publicApiId;

        protected B $fillValuesFrom(C instance) {
            BaseCommandBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <T> void $fillValuesFromInstanceIntoBuilder(BaseCommand<T> instance, BaseCommandBuilder<T, ?, ?> b) {
            b.parameters(((BaseCommand)instance).parameters);
            b.callback(((BaseCommand)instance).callback);
            b.controllers(((BaseCommand)instance).controllers);
            b.publicApiId(((BaseCommand)instance).publicApiId);
        }

        protected abstract B self();

        public abstract C build();

        public B parameters(@NonNull CommandParameters parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters is marked non-null but is null");
            }
            this.parameters = parameters;
            return this.self();
        }

        public B callback(@NonNull CommandCallback callback) {
            if (callback == null) {
                throw new NullPointerException("callback is marked non-null but is null");
            }
            this.callback = callback;
            return this.self();
        }

        public B controllers(@NonNull List<BaseController> controllers) {
            if (controllers == null) {
                throw new NullPointerException("controllers is marked non-null but is null");
            }
            this.controllers = controllers;
            return this.self();
        }

        public B publicApiId(@NonNull String publicApiId) {
            if (publicApiId == null) {
                throw new NullPointerException("publicApiId is marked non-null but is null");
            }
            this.publicApiId = publicApiId;
            return this.self();
        }

        public String toString() {
            return "BaseCommand.BaseCommandBuilder(parameters=" + this.parameters + ", callback=" + this.callback + ", controllers=" + this.controllers + ", publicApiId=" + this.publicApiId + ")";
        }
    }
}

