/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.exception.ClientException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import lombok.NonNull;

public class ProviderFactory {
    @NonNull
    public static Signature getSignature(@NonNull String algorithm, @Nullable Provider provider) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        try {
            if (provider != null) {
                return Signature.getInstance(algorithm, provider);
            }
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
    }

    @NonNull
    public static Cipher getCipher(@NonNull String algorithm, @Nullable Provider provider) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        try {
            if (provider != null) {
                return Cipher.getInstance(algorithm, provider);
            }
            return Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new ClientException("no_such_padding", e.getMessage(), e);
        }
    }

    @NonNull
    public static Mac getMac(@NonNull String algorithm, @Nullable Provider provider) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        try {
            if (provider != null) {
                return Mac.getInstance(algorithm, provider);
            }
            return Mac.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
    }

    @NonNull
    public static KeyPairGenerator getKeyPairGenerator(@NonNull String algorithm, @Nullable Provider provider) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        try {
            if (provider != null) {
                return KeyPairGenerator.getInstance(algorithm, provider);
            }
            return KeyPairGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
    }

    @NonNull
    public static KeyFactory getKeyFactory(@NonNull String algorithm, @Nullable Provider provider) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        try {
            if (provider != null) {
                return KeyFactory.getInstance(algorithm, provider);
            }
            return KeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
    }
}

