/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.logging;

import com.microsoft.identity.common.java.logging.IRequestContext;
import com.microsoft.identity.common.java.logging.RequestContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public enum DiagnosticContext {
    INSTANCE;

    public static final String CORRELATION_ID = "correlation_id";
    public static final String THREAD_ID = "thread_id";
    @SuppressFBWarnings(value={"SE_BAD_FIELD_STORE"})
    private final transient ThreadLocal<IRequestContext> REQUEST_CONTEXT_THREAD_LOCAL = new ThreadLocal<IRequestContext>(){

        @Override
        protected RequestContext initialValue() {
            RequestContext defaultRequestContext = new RequestContext();
            defaultRequestContext.put(DiagnosticContext.THREAD_ID, String.valueOf(Thread.currentThread().getId()));
            defaultRequestContext.put(DiagnosticContext.CORRELATION_ID, "UNSET");
            return defaultRequestContext;
        }
    };

    public void setRequestContext(IRequestContext requestContext) {
        if (null == requestContext) {
            this.clear();
            return;
        }
        requestContext.put(THREAD_ID, String.valueOf(Thread.currentThread().getId()));
        this.REQUEST_CONTEXT_THREAD_LOCAL.set(requestContext);
    }

    public IRequestContext getRequestContext() {
        return this.REQUEST_CONTEXT_THREAD_LOCAL.get();
    }

    public void clear() {
        this.REQUEST_CONTEXT_THREAD_LOCAL.remove();
    }
}

