/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.net;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class HttpRequest {
    private static final String HOST = "Host";
    private final URL mRequestUrl;
    private final byte[] mRequestContent;
    private final String mRequestContentType;
    private final String mRequestMethod;
    private final Map<String, String> mRequestHeaders = new HashMap<String, String>();

    public byte[] getRequestContent() {
        if (this.mRequestContent == null) {
            return null;
        }
        return Arrays.copyOf(this.mRequestContent, this.mRequestContent.length);
    }

    Map<String, String> getRequestHeaders() {
        return Collections.unmodifiableMap(this.mRequestHeaders);
    }

    public HttpRequest(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @NonNull String requestMethod, byte[] requestContent, String requestContentType) {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        if (requestMethod == null) {
            throw new NullPointerException("requestMethod is marked non-null but is null");
        }
        this.mRequestUrl = requestUrl;
        this.mRequestHeaders.put(HOST, requestUrl.getAuthority());
        this.mRequestHeaders.putAll(requestHeaders);
        this.mRequestMethod = requestMethod;
        this.mRequestContent = requestContent != null ? Arrays.copyOf(requestContent, requestContent.length) : null;
        this.mRequestContentType = requestContentType;
    }

    public URL getRequestUrl() {
        return this.mRequestUrl;
    }

    public String getRequestContentType() {
        return this.mRequestContentType;
    }

    public String getRequestMethod() {
        return this.mRequestMethod;
    }
}

