/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.opentelemetry;

import io.opentelemetry.api.NoopOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.metrics.NoopMeterProvider;
import io.opentelemetry.api.trace.Tracer;
import lombok.NonNull;

public class OpenTelemetryHolder {
    private static final OpenTelemetry NOOP;
    @NonNull
    private static OpenTelemetry sOpenTelemetry;
    private static final MeterProvider NOOP_METER_PROVIDER;

    public static Tracer getTracer(String instrumentationScopeName) {
        return sOpenTelemetry.getTracerProvider().get(instrumentationScopeName);
    }

    public static Meter getMeter(String instrumentationScopeName) {
        try {
            return sOpenTelemetry.getMeterProvider().get(instrumentationScopeName);
        }
        catch (AbstractMethodError error) {
            return NOOP_METER_PROVIDER.get(instrumentationScopeName);
        }
    }

    public static void setOpenTelemetry(@NonNull OpenTelemetry sOpenTelemetry) {
        if (sOpenTelemetry == null) {
            throw new NullPointerException("sOpenTelemetry is marked non-null but is null");
        }
        OpenTelemetryHolder.sOpenTelemetry = sOpenTelemetry;
    }

    @NonNull
    public static OpenTelemetry getOpenTelemetry() {
        return sOpenTelemetry;
    }

    static {
        sOpenTelemetry = NOOP = new NoopOpenTelemetry();
        NOOP_METER_PROVIDER = NoopMeterProvider.getInstance();
    }
}

