/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.platform;

import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.platform.IDeviceMetadata;
import com.microsoft.identity.common.java.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import net.jcip.annotations.GuardedBy;

public class Device {
    private static final String TAG = Device.class.getSimpleName();
    protected static final String NOT_SET = "NOT_SET";
    private static IDeviceMetadata sDeviceMetadata;
    private static final ReentrantReadWriteLock sLock;

    @GuardedBy(value="sLock")
    public static void setDeviceMetadata(@NonNull IDeviceMetadata deviceMetadata) {
        if (deviceMetadata == null) {
            throw new NullPointerException("deviceMetadata is marked non-null but is null");
        }
        sLock.writeLock().lock();
        try {
            sDeviceMetadata = deviceMetadata;
        }
        finally {
            sLock.writeLock().unlock();
        }
    }

    @GuardedBy(value="sLock")
    public static void clearDeviceMetadata() {
        sLock.writeLock().lock();
        try {
            sDeviceMetadata = null;
        }
        finally {
            sLock.writeLock().unlock();
        }
    }

    @GuardedBy(value="sLock")
    @NonNull
    public static Map<String, String> getPlatformIdParameters() {
        sLock.readLock().lock();
        try {
            HashMap<String, String> platformParameters = new HashMap<String, String>();
            if (sDeviceMetadata != null) {
                platformParameters.put("x-client-CPU", sDeviceMetadata.getCpu());
                platformParameters.put("x-client-OS", sDeviceMetadata.getOsForEsts());
                platformParameters.put("x-client-DM", sDeviceMetadata.getDeviceModel());
            } else {
                platformParameters.put("x-client-CPU", NOT_SET);
                platformParameters.put("x-client-OS", NOT_SET);
                platformParameters.put("x-client-DM", NOT_SET);
            }
            Map<String, String> map = Collections.unmodifiableMap(platformParameters);
            return map;
        }
        finally {
            sLock.readLock().unlock();
        }
    }

    @NonNull
    public static String getProductVersion() {
        String methodName = ":getProductVersion";
        String version = (String)DiagnosticContext.INSTANCE.getRequestContext().get("x-client-Ver");
        if (StringUtil.isNullOrEmpty(version)) {
            Logger.warn(TAG + ":getProductVersion", "Product version is not set.", null);
            return StringUtil.isNullOrEmpty("") ? "1.5.9-default" : "-default";
        }
        return version;
    }

    @GuardedBy(value="sLock")
    @NonNull
    public static String getDeviceType() {
        sLock.readLock().lock();
        try {
            if (sDeviceMetadata != null) {
                String string = sDeviceMetadata.getDeviceType();
                return string;
            }
            String string = NOT_SET;
            return string;
        }
        finally {
            sLock.readLock().unlock();
        }
    }

    @GuardedBy(value="sLock")
    @NonNull
    public static String getCpu() {
        sLock.readLock().lock();
        try {
            if (sDeviceMetadata != null) {
                String string = sDeviceMetadata.getCpu();
                return string;
            }
            String string = NOT_SET;
            return string;
        }
        finally {
            sLock.readLock().unlock();
        }
    }

    @GuardedBy(value="sLock")
    @NonNull
    public static String getOsForEsts() {
        sLock.readLock().lock();
        try {
            if (sDeviceMetadata != null) {
                String string = sDeviceMetadata.getOsForEsts();
                return string;
            }
            String string = NOT_SET;
            return string;
        }
        finally {
            sLock.readLock().unlock();
        }
    }

    @GuardedBy(value="sLock")
    @NonNull
    public static String getOsForDrs() {
        sLock.readLock().lock();
        try {
            if (sDeviceMetadata != null) {
                String string = sDeviceMetadata.getOsForDrs();
                return string;
            }
            String string = NOT_SET;
            return string;
        }
        finally {
            sLock.readLock().unlock();
        }
    }

    @GuardedBy(value="sLock")
    @NonNull
    public static String getManufacturer() {
        sLock.readLock().lock();
        try {
            if (sDeviceMetadata != null) {
                String string = sDeviceMetadata.getManufacturer();
                return string;
            }
            String string = NOT_SET;
            return string;
        }
        finally {
            sLock.readLock().unlock();
        }
    }

    @GuardedBy(value="sLock")
    @NonNull
    public static String getModel() {
        sLock.readLock().lock();
        try {
            if (sDeviceMetadata != null) {
                String string = sDeviceMetadata.getDeviceModel();
                return string;
            }
            String string = NOT_SET;
            return string;
        }
        finally {
            sLock.readLock().unlock();
        }
    }

    @NonNull
    public static String getDeviceDisplayName() {
        return Device.getManufacturer() + Device.getModel();
    }

    static {
        sLock = new ReentrantReadWriteLock();
    }

    public static final class PlatformIdParameters {
        public static final String CPU_PLATFORM = "x-client-CPU";
        public static final String OS = "x-client-OS";
        public static final String DEVICE_MODEL = "x-client-DM";
        public static final String BROKER_VERSION = "x-client-brkrver";
    }
}

