/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import edu.umd.cs.findbugs.annotations.Nullable;

public class OAuth2StrategyParameters {
    @Nullable
    private final transient IPlatformComponents mPlatformComponents;
    @Nullable
    private final transient AbstractAuthenticationScheme mAuthenticationScheme;
    private transient boolean mUsingOpenIdConfiguration;

    OAuth2StrategyParameters(@Nullable IPlatformComponents platformComponents, @Nullable AbstractAuthenticationScheme authenticationScheme, boolean usingOpenIdConfiguration) {
        this.mPlatformComponents = platformComponents;
        this.mAuthenticationScheme = authenticationScheme;
        this.mUsingOpenIdConfiguration = usingOpenIdConfiguration;
    }

    public static OAuth2StrategyParametersBuilder builder() {
        return new OAuth2StrategyParametersBuilder();
    }

    @Nullable
    public IPlatformComponents getPlatformComponents() {
        return this.mPlatformComponents;
    }

    @Nullable
    public AbstractAuthenticationScheme getAuthenticationScheme() {
        return this.mAuthenticationScheme;
    }

    public boolean isUsingOpenIdConfiguration() {
        return this.mUsingOpenIdConfiguration;
    }

    public void setUsingOpenIdConfiguration(boolean mUsingOpenIdConfiguration) {
        this.mUsingOpenIdConfiguration = mUsingOpenIdConfiguration;
    }

    public static class OAuth2StrategyParametersBuilder {
        private IPlatformComponents platformComponents;
        private AbstractAuthenticationScheme authenticationScheme;
        private boolean usingOpenIdConfiguration;

        OAuth2StrategyParametersBuilder() {
        }

        public OAuth2StrategyParametersBuilder platformComponents(@Nullable IPlatformComponents platformComponents) {
            this.platformComponents = platformComponents;
            return this;
        }

        public OAuth2StrategyParametersBuilder authenticationScheme(@Nullable AbstractAuthenticationScheme authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        public OAuth2StrategyParametersBuilder usingOpenIdConfiguration(boolean usingOpenIdConfiguration) {
            this.usingOpenIdConfiguration = usingOpenIdConfiguration;
            return this;
        }

        public OAuth2StrategyParameters build() {
            return new OAuth2StrategyParameters(this.platformComponents, this.authenticationScheme, this.usingOpenIdConfiguration);
        }

        public String toString() {
            return "OAuth2StrategyParameters.OAuth2StrategyParametersBuilder(platformComponents=" + this.platformComponents + ", authenticationScheme=" + this.authenticationScheme + ", usingOpenIdConfiguration=" + this.usingOpenIdConfiguration + ")";
        }
    }
}

