/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.regex.Pattern;

public class CliTelemInfo
implements Serializable {
    private static final String TAG = CliTelemInfo.class.getSimpleName();
    private static final long serialVersionUID = -7200606162774338466L;
    private static final Pattern HEADER_FORMAT_REGULAR_EXPRESSION = Pattern.compile("^[1-9]+\\.?[0-9|\\.]*,[0-9|\\.]*,[0-9|\\.]*,[^,]*[0-9\\.]*,[^,]*$");
    private String mVersion;
    private String mServerErrorCode;
    private String mServerSubErrorCode;
    private String mRefreshTokenAge;
    private String mSpeRing;

    public CliTelemInfo() {
    }

    public CliTelemInfo(CliTelemInfo copy) {
        if (null != copy) {
            this.mVersion = copy.mVersion;
            this.mServerErrorCode = copy.mServerErrorCode;
            this.mServerSubErrorCode = copy.mServerSubErrorCode;
            this.mRefreshTokenAge = copy.mRefreshTokenAge;
            this.mSpeRing = copy.mSpeRing;
        }
    }

    public String getVersion() {
        return this.mVersion;
    }

    protected void setVersion(String version) {
        this.mVersion = version;
    }

    public String getServerErrorCode() {
        return this.mServerErrorCode;
    }

    protected void setServerErrorCode(String serverErrorCode) {
        this.mServerErrorCode = serverErrorCode;
    }

    public String getServerSubErrorCode() {
        return this.mServerSubErrorCode;
    }

    protected void setServerSubErrorCode(String serverSubErrorCode) {
        this.mServerSubErrorCode = serverSubErrorCode;
    }

    public String getRefreshTokenAge() {
        return this.mRefreshTokenAge;
    }

    public void setRefreshTokenAge(String refreshTokenAge) {
        this.mRefreshTokenAge = refreshTokenAge;
    }

    public String getSpeRing() {
        return this.mSpeRing;
    }

    public void setSpeRing(String speRing) {
        this.mSpeRing = speRing;
    }

    @Nullable
    public static CliTelemInfo fromXMsCliTelemHeader(String headerValue) {
        if (StringUtil.isNullOrEmpty(headerValue)) {
            return null;
        }
        String[] headerSegments = headerValue.split(",");
        if (0 == headerSegments.length) {
            Logger.warn(TAG, "SPE Ring header missing version field.");
            return null;
        }
        String headerVersion = headerSegments[0];
        CliTelemInfo cliTelemInfo = new CliTelemInfo();
        cliTelemInfo.setVersion(headerVersion);
        if (headerVersion.equals("1")) {
            int delimCount = 4;
            if (!HEADER_FORMAT_REGULAR_EXPRESSION.matcher(headerValue).matches()) {
                Logger.warn(TAG, "Malformed x-ms-clitelem header");
                return null;
            }
        } else {
            Logger.warn(TAG, "Unrecognized x-ms-clitelem header version");
            return null;
        }
        headerSegments = headerValue.split(",", 5);
        boolean indexErrorCode = true;
        int indexSubErrorCode = 2;
        int indexTokenAge = 3;
        int indexSpeInfo = 4;
        cliTelemInfo.setServerErrorCode(headerSegments[1]);
        cliTelemInfo.setServerSubErrorCode(headerSegments[2]);
        cliTelemInfo.setRefreshTokenAge(headerSegments[3]);
        cliTelemInfo.setSpeRing(headerSegments[4]);
        return cliTelemInfo;
    }
}

