/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry.adapter;

import com.microsoft.identity.common.java.telemetry.adapter.ITelemetryAdapter;
import com.microsoft.identity.common.java.telemetry.observers.ITelemetryDefaultObserver;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class TelemetryDefaultAdapter
implements ITelemetryAdapter<List<Map<String, String>>> {
    private ITelemetryDefaultObserver mObserver;

    public TelemetryDefaultAdapter(@NonNull ITelemetryDefaultObserver observer) {
        if (observer == null) {
            throw new NullPointerException("observer is marked non-null but is null");
        }
        this.mObserver = observer;
    }

    public ITelemetryDefaultObserver getObserver() {
        return this.mObserver;
    }

    @Override
    public void process(@NonNull List<Map<String, String>> rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData is marked non-null but is null");
        }
        if (null == this.mObserver) {
            return;
        }
        this.mObserver.onReceived(rawData);
    }
}

