/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.util.StringUtil;
import javax.annotation.Nullable;
import lombok.NonNull;

public class BrokerProtocolVersionUtil {
    public static final String MSAL_TO_BROKER_PROTOCOL_COMPRESSION_CHANGES_MINIMUM_VERSION = "5.0";
    public static final String MSAL_TO_BROKER_PROTOCOL_ACCOUNT_FROM_PRT_CHANGES_MINIMUM_VERSION = "8.0";
    public static final String MSAL_TO_BROKER_PROTOCOL_PKEYAUTH_HEADER_CHANGES_MINIMUM_VERSION = "9.0";
    public static final String MSAL_TO_BROKER_PROTOCOL_POP_SCHEME_WITH_CLIENT_KEY_MINIMUM_VERSION = "11.0";
    public static final String MSAL_TO_BROKER_PROTOCOL_BROKER_MSA_SUPPORT_MINIMUM_VERSION = "14.0";
    public static final String MSAL_TO_BROKER_PROTOCOL_NAA_MINIMUM_VERSION = "15.0";

    public static boolean canSupportMsaAccountsInBroker(@Nullable String negotiatedBrokerProtocol) {
        return BrokerProtocolVersionUtil.isProvidedBrokerProtocolLargerOrEqualThanRequiredBrokerProtocol(negotiatedBrokerProtocol, MSAL_TO_BROKER_PROTOCOL_BROKER_MSA_SUPPORT_MINIMUM_VERSION);
    }

    public static final boolean canCompressBrokerPayloads(@Nullable String negotiatedBrokerProtocol) {
        return BrokerProtocolVersionUtil.isProvidedBrokerProtocolLargerOrEqualThanRequiredBrokerProtocol(negotiatedBrokerProtocol, MSAL_TO_BROKER_PROTOCOL_COMPRESSION_CHANGES_MINIMUM_VERSION);
    }

    public static final boolean canFociAppsConstructAccountsFromPrtIdTokens(@Nullable String clientRequiredBrokerProtocolVersion) {
        return BrokerProtocolVersionUtil.isProvidedBrokerProtocolLargerOrEqualThanRequiredBrokerProtocol(clientRequiredBrokerProtocolVersion, MSAL_TO_BROKER_PROTOCOL_ACCOUNT_FROM_PRT_CHANGES_MINIMUM_VERSION);
    }

    public static boolean canSendPKeyAuthHeaderToTheTokenEndpoint(@Nullable String clientRequiredBrokerProtocolVersion) {
        return BrokerProtocolVersionUtil.isProvidedBrokerProtocolLargerOrEqualThanRequiredBrokerProtocol(clientRequiredBrokerProtocolVersion, MSAL_TO_BROKER_PROTOCOL_PKEYAUTH_HEADER_CHANGES_MINIMUM_VERSION);
    }

    public static boolean canSupportPopAuthenticationSchemeWithClientKey(@Nullable String clientRequiredBrokerProtocolVersion) {
        return BrokerProtocolVersionUtil.isProvidedBrokerProtocolLargerOrEqualThanRequiredBrokerProtocol(clientRequiredBrokerProtocolVersion, MSAL_TO_BROKER_PROTOCOL_POP_SCHEME_WITH_CLIENT_KEY_MINIMUM_VERSION);
    }

    public static boolean canSupportNestedAppAuthentication(@Nullable String clientRequiredBrokerProtocolVersion) {
        return BrokerProtocolVersionUtil.isProvidedBrokerProtocolLargerOrEqualThanRequiredBrokerProtocol(clientRequiredBrokerProtocolVersion, MSAL_TO_BROKER_PROTOCOL_NAA_MINIMUM_VERSION);
    }

    protected static final boolean isProvidedBrokerProtocolLargerOrEqualThanRequiredBrokerProtocol(@Nullable String providedBrokerProtocol, @NonNull String requiredBrokerProtocol) {
        if (requiredBrokerProtocol == null) {
            throw new NullPointerException("requiredBrokerProtocol is marked non-null but is null");
        }
        if (StringUtil.isNullOrEmpty(providedBrokerProtocol)) {
            return false;
        }
        return BrokerProtocolVersionUtil.isFirstVersionNewerOrEqual(providedBrokerProtocol, requiredBrokerProtocol);
    }

    public static boolean isFirstVersionOlderOrEqual(@NonNull String first, @Nullable String second) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        return BrokerProtocolVersionUtil.compareSemanticVersion(first, second) <= 0;
    }

    public static boolean isFirstVersionNewerOrEqual(@NonNull String first, @Nullable String second) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        return BrokerProtocolVersionUtil.compareSemanticVersion(first, second) >= 0;
    }

    public static final int compareSemanticVersion(@NonNull String thisVersion, @Nullable String thatVersion) {
        if (thisVersion == null) {
            throw new NullPointerException("thisVersion is marked non-null but is null");
        }
        if (thatVersion == null) {
            return 1;
        }
        String[] thisParts = thisVersion.split("\\.");
        String[] thatParts = thatVersion.split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }
}

