/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.ported.ObjectUtils;
import cz.msebera.android.httpclient.extras.Base64;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.NonNull;

public class StringUtil {
    private static String TAG = StringUtil.class.getSimpleName();
    private static final String RFC3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String TOKEN_HASH_ALGORITHM = "SHA256";

    public static boolean isNullOrEmpty(@Nullable String message) {
        return message == null || message.trim().length() == 0;
    }

    public static boolean containsSubString(String str, String substr) {
        if (StringUtil.isNullOrEmpty(str)) {
            return false;
        }
        return str.contains(substr);
    }

    public static boolean equalsIgnoreCase(@Nullable String one, @Nullable String two) {
        return ObjectUtils.equals(one, two) || one != null && one.equalsIgnoreCase(two);
    }

    public static Map.Entry<String, String> getTenantInfo(@NonNull String homeAccountId) {
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        int EXPECTED_LENGTH = 2;
        boolean INDEX_UID = false;
        boolean INDEX_UTID = true;
        String[] uidUtidArray = homeAccountId.split("\\.");
        String uid = null;
        String utid = null;
        if (2 == uidUtidArray.length && !StringUtil.isNullOrEmpty(uidUtidArray[0]) && !StringUtil.isNullOrEmpty(uidUtidArray[1])) {
            uid = uidUtidArray[0];
            utid = uidUtidArray[1];
        } else {
            Logger.warn(TAG, "We had a home account id that could not be split correctly, We expected it to split into 2 parts but instead we had " + uidUtidArray.length + " when splitting the string on dot ('.')");
            Logger.warnPII(TAG, "We had a home account id that could not be split correctly, Its value was: '" + homeAccountId + "', and we expected it to split into " + 2 + " parts but instead we had " + uidUtidArray.length + " when splitting the string on dot ('.')");
        }
        return new AbstractMap.SimpleEntry<String, String>(uid, utid);
    }

    @Nullable
    public static String getUIdFromHomeAccountId(@Nullable String homeAccountId) {
        String methodName = ":getUIdFromHomeAccountId";
        String DELIMITER_TENANTED_USER_ID = ".";
        int EXPECTED_ARGS_LEN = 2;
        boolean INDEX_USER_ID = false;
        if (!StringUtil.isNullOrEmpty(homeAccountId)) {
            String[] homeAccountIdSplit = homeAccountId.split(Pattern.quote("."));
            if (homeAccountIdSplit.length == 2) {
                Logger.info(TAG + ":getUIdFromHomeAccountId", "Home account id is tenanted, returning uid ");
                return homeAccountIdSplit[0];
            }
            if (homeAccountIdSplit.length == 1) {
                Logger.info(TAG + ":getUIdFromHomeAccountId", "Home account id not tenanted, it's the uid added by v1 broker ");
                return homeAccountIdSplit[0];
            }
        }
        Logger.warn(TAG + ":getUIdFromHomeAccountId", "Home Account id doesn't have uid or tenant id information, returning null ");
        return null;
    }

    public static boolean hasPrefixInHeader(String value, String prefix) {
        return value.startsWith(prefix) && value.length() > prefix.length() + 2 && Character.isWhitespace(value.charAt(prefix.length()));
    }

    public static List<String> getStringTokens(String items, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(items, delimiter);
        ArrayList<String> itemList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            if (StringUtil.isNullOrEmpty(name)) continue;
            itemList.add(name);
        }
        return itemList;
    }

    public static ArrayList<String> splitWithQuotes(String input, char delimiter) {
        String item;
        ArrayList<String> items = new ArrayList<String>();
        int startIndex = 0;
        boolean insideString = false;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == delimiter && !insideString) {
                item = input.substring(startIndex, i);
                if (!StringUtil.isNullOrEmpty(item.trim())) {
                    items.add(item);
                }
                startIndex = i + 1;
                continue;
            }
            if (input.charAt(i) != '\"') continue;
            insideString = !insideString;
        }
        item = input.substring(startIndex);
        if (!StringUtil.isNullOrEmpty(item.trim())) {
            items.add(item);
        }
        return items;
    }

    public static String removeQuoteInHeaderValue(String value) {
        if (!StringUtil.isNullOrEmpty(value)) {
            return value.replace("\"", "");
        }
        return null;
    }

    public static String urlFormDecode(String source) throws UnsupportedEncodingException {
        if (StringUtil.isNullOrEmpty(source)) {
            return "";
        }
        return URLDecoder.decode(source, "UTF-8");
    }

    public static String getStackTraceAsString(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return pw.toString();
    }

    public static String fromByteArray(byte[] bytes) {
        return new String(bytes, AuthenticationConstants.ENCODING_UTF8);
    }

    public static byte[] toByteArray(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        return string.getBytes(AuthenticationConstants.ENCODING_UTF8);
    }

    @NonNull
    public static String RFC3339DateToString(@NonNull Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        String methodName = "RFC3339DateToString";
        Logger.verbose(TAG + "RFC3339DateToString", "RFC3339DateToString is called.");
        SimpleDateFormat RFC3339DateFormat = new SimpleDateFormat(RFC3339_DATE_FORMAT, Locale.US);
        RFC3339DateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return RFC3339DateFormat.format(date);
    }

    @NonNull
    public static Date RFC3339StringToDate(@NonNull String dateStr) throws ParseException {
        if (dateStr == null) {
            throw new NullPointerException("dateStr is marked non-null but is null");
        }
        SimpleDateFormat RFC3339DateFormat = new SimpleDateFormat(RFC3339_DATE_FORMAT, Locale.US);
        RFC3339DateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return RFC3339DateFormat.parse(dateStr);
    }

    public static boolean isUuid(@NonNull String inputString) {
        if (inputString == null) {
            throw new NullPointerException("inputString is marked non-null but is null");
        }
        try {
            UUID.fromString(inputString);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String encodeUrlSafeString(@NonNull byte[] bytesToEncode) {
        if (bytesToEncode == null) {
            throw new NullPointerException("bytesToEncode is marked non-null but is null");
        }
        return Base64.encodeToString((byte[])bytesToEncode, (int)11);
    }

    public static String encodeUrlSafeString(@NonNull String stringToEncode) {
        if (stringToEncode == null) {
            throw new NullPointerException("stringToEncode is marked non-null but is null");
        }
        return Base64.encodeToString((byte[])StringUtil.toByteArray(stringToEncode), (int)11);
    }

    public static String createHash(String msg) throws NoSuchAlgorithmException {
        if (!StringUtil.isNullOrEmpty(msg)) {
            MessageDigest digester = MessageDigest.getInstance(TOKEN_HASH_ALGORITHM);
            byte[] msgInBytes = msg.getBytes(AuthenticationConstants.ENCODING_UTF8);
            return new String(Base64.encode((byte[])digester.digest(msgInBytes), (int)2), AuthenticationConstants.ENCODING_UTF8);
        }
        return msg;
    }

    public static boolean equalsIgnoreCaseTrimBoth(@Nullable String one, @Nullable String two) {
        return StringUtil.equalsIgnoreCaseTrim(one != null ? one.trim() : null, two);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="This is an intentional reference comparison")
    public static boolean equalsIgnoreCaseTrim(@Nullable String one, @Nullable String two) {
        return one == two || two != null && StringUtil.equalsIgnoreCase(one, two.trim());
    }

    public static String sanitizeNull(String input) {
        return null == input ? "" : input;
    }

    public static String sanitizeNullAndLowercaseAndTrim(String input) {
        String outValue = null == input ? "" : input.toLowerCase(Locale.US).trim();
        return outValue;
    }

    public static String urlFormEncode(String source) throws UnsupportedEncodingException {
        return URLEncoder.encode(source, "UTF-8");
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.encodeToString((byte[])bytes, (int)2);
    }

    public static byte[] base64Decode(@NonNull String encodedString) {
        if (encodedString == null) {
            throw new NullPointerException("encodedString is marked non-null but is null");
        }
        return Base64.decode((String)encodedString, (int)2);
    }

    public static byte[] base64DecodeUrlSafeString(@NonNull String encodedString) {
        if (encodedString == null) {
            throw new NullPointerException("encodedString is marked non-null but is null");
        }
        return Base64.decode((String)encodedString, (int)11);
    }

    public static <T extends CharSequence> String join(CharSequence separator, @NonNull Iterable<T> segments) {
        if (segments == null) {
            throw new NullPointerException("segments is marked non-null but is null");
        }
        Iterator<T> itr = segments.iterator();
        if (!itr.hasNext()) {
            return "";
        }
        CharSequence first = (CharSequence)itr.next();
        if (!itr.hasNext()) {
            if (first instanceof String) {
                return (String)first;
            }
            return first.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        while (itr.hasNext()) {
            sb.append(separator);
            sb.append((CharSequence)itr.next());
        }
        return sb.toString();
    }

    public static void throwIfArgumentIsNullOrEmpty(@Nullable String argument, @NonNull String argumentName, @NonNull String methodName) throws NullPointerException {
        if (argumentName == null) {
            throw new NullPointerException("argumentName is marked non-null but is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        if (StringUtil.isNullOrEmpty(argument)) {
            Logger.error(TAG + methodName, argumentName + " is null or empty.", null);
            throw new NullPointerException(argumentName + " is null or empty.");
        }
    }

    public static byte[] base64Decode(@NonNull String input, int flags, @NonNull String failureMessage) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (failureMessage == null) {
            throw new NullPointerException("failureMessage is marked non-null but is null");
        }
        String methodTag = TAG + ":base64Decode";
        try {
            return Base64.decode((String)input, (int)flags);
        }
        catch (IllegalArgumentException e) {
            Logger.error(methodTag, failureMessage + " " + e.getMessage(), null);
            throw e;
        }
    }
}

