/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.cache.IAccountCredentialCache;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.PrimaryRefreshTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;

public abstract class AbstractAccountCredentialCache
implements IAccountCredentialCache {
    private static final String TAG = AbstractAccountCredentialCache.class.getSimpleName();
    private static final String NEW_LINE = "\n";
    protected final INameValueStorage<String> mSharedPreferencesFileManager;

    protected AbstractAccountCredentialCache(@NonNull INameValueStorage<String> sharedPreferencesFileManager) {
        if (sharedPreferencesFileManager == null) {
            throw new NullPointerException("sharedPreferencesFileManager is marked non-null but is null");
        }
        this.mSharedPreferencesFileManager = sharedPreferencesFileManager;
    }

    @Nullable
    protected Class<? extends Credential> getTargetClassForCredentialType(@Nullable String cacheKey, @NonNull CredentialType targetType) {
        if (targetType == null) {
            throw new NullPointerException("targetType is marked non-null but is null");
        }
        Class credentialClass = null;
        switch (targetType) {
            case AccessToken: 
            case AccessToken_With_AuthScheme: {
                credentialClass = AccessTokenRecord.class;
                break;
            }
            case RefreshToken: {
                credentialClass = RefreshTokenRecord.class;
                break;
            }
            case IdToken: 
            case V1IdToken: {
                credentialClass = IdTokenRecord.class;
                break;
            }
            case PrimaryRefreshToken: {
                credentialClass = PrimaryRefreshTokenRecord.class;
                break;
            }
            default: {
                Logger.warn(TAG, "Could not match CredentialType to class. Did you forget to update this method with a new type?");
                if (null == cacheKey) break;
                Logger.warnPII(TAG, "Sought key was: [" + cacheKey + "]");
            }
        }
        return credentialClass;
    }

    @NonNull
    protected List<AccountRecord> getAccountsFilteredByInternal(@Nullable String homeAccountId, @Nullable String environment, @Nullable String realm, @NonNull List<AccountRecord> allAccounts) {
        if (allAccounts == null) {
            throw new NullPointerException("allAccounts is marked non-null but is null");
        }
        boolean mustMatchOnHomeAccountId = !StringUtil.isNullOrEmpty(homeAccountId);
        boolean mustMatchOnEnvironment = !StringUtil.isNullOrEmpty(environment);
        boolean mustMatchOnRealm = !StringUtil.isNullOrEmpty(realm);
        Logger.verbose(TAG, "Account lookup filtered by home_account_id? [" + mustMatchOnHomeAccountId + "]" + NEW_LINE + "Account lookup filtered by realm? [" + mustMatchOnRealm + "]");
        ArrayList<AccountRecord> matchingAccounts = new ArrayList<AccountRecord>();
        for (AccountRecord account : allAccounts) {
            boolean matches = true;
            if (mustMatchOnHomeAccountId) {
                matches = StringUtil.equalsIgnoreCaseTrimBoth(homeAccountId, account.getHomeAccountId());
            }
            if (mustMatchOnEnvironment) {
                boolean bl = matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(environment, account.getEnvironment());
            }
            if (mustMatchOnRealm) {
                boolean bl = matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(realm, account.getRealm());
            }
            if (!matches) continue;
            matchingAccounts.add(account);
        }
        Logger.verbose(TAG, "Found [" + matchingAccounts.size() + "] matching accounts");
        return matchingAccounts;
    }

    protected List<Credential> getCredentialsFilteredByInternal(@NonNull List<Credential> allCredentials, @Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String applicationIdentifier, @Nullable String mamEnrollmentIdentifier, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @Nullable String requestedClaims, @Nullable String kid) {
        if (allCredentials == null) {
            throw new NullPointerException("allCredentials is marked non-null but is null");
        }
        boolean mustMatchOnEnvironment = !StringUtil.isNullOrEmpty(environment);
        boolean mustMatchOnHomeAccountId = !StringUtil.isNullOrEmpty(homeAccountId);
        boolean mustMatchOnRealm = !StringUtil.isNullOrEmpty(realm);
        boolean mustMatchOnTarget = !StringUtil.isNullOrEmpty(target);
        boolean mustMatchOnClientId = !StringUtil.isNullOrEmpty(clientId);
        boolean mustMatchOnApplicationIdentifier = !StringUtil.isNullOrEmpty(applicationIdentifier);
        boolean mustMatchOnMamEnrollmentIdentifier = !StringUtil.isNullOrEmpty(mamEnrollmentIdentifier);
        boolean mustMatchOnCredentialType = null != credentialType;
        boolean mustMatchOnAuthScheme = mustMatchOnCredentialType && !StringUtil.isNullOrEmpty(authScheme) && credentialType == CredentialType.AccessToken_With_AuthScheme;
        boolean mustMatchOnKid = !StringUtil.isNullOrEmpty(kid);
        boolean mustMatchOnRequestedClaims = !StringUtil.isNullOrEmpty(requestedClaims);
        Logger.verbose(TAG, "Credential lookup filtered by home_account_id? [" + mustMatchOnHomeAccountId + "]" + NEW_LINE + "Credential lookup filtered by realm? [" + mustMatchOnRealm + "]" + NEW_LINE + "Credential lookup filtered by target? [" + mustMatchOnTarget + "]" + NEW_LINE + "Credential lookup filtered by clientId? [" + mustMatchOnClientId + "]" + NEW_LINE + "Credential lookup filtered by applicationIdentifier? [" + mustMatchOnApplicationIdentifier + "]" + NEW_LINE + "Credential lookup filtered by mamEnrollmentIdentifier? [" + mustMatchOnMamEnrollmentIdentifier + "]" + NEW_LINE + "Credential lookup filtered by credential type? [" + mustMatchOnCredentialType + "]" + NEW_LINE + "Credential lookup filtered by auth scheme? [" + mustMatchOnAuthScheme + "]" + NEW_LINE + "Credential lookup filtered by requested claims? [" + mustMatchOnRequestedClaims + "]");
        ArrayList<Credential> matchingCredentials = new ArrayList<Credential>();
        for (Credential credential : allCredentials) {
            AccessTokenRecord accessToken;
            boolean matches = true;
            if (mustMatchOnHomeAccountId) {
                matches = StringUtil.equalsIgnoreCaseTrimBoth(homeAccountId, credential.getHomeAccountId());
            }
            if (mustMatchOnEnvironment) {
                boolean bl = matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(environment, credential.getEnvironment());
            }
            if (mustMatchOnCredentialType) {
                boolean bl = matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(credentialType.name(), credential.getCredentialType());
            }
            if (mustMatchOnClientId) {
                boolean bl = matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(clientId, credential.getClientId());
            }
            if (mustMatchOnApplicationIdentifier) {
                if (credential instanceof AccessTokenRecord) {
                    accessToken = (AccessTokenRecord)credential;
                    matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(applicationIdentifier, accessToken.getApplicationIdentifier());
                } else {
                    Logger.verbose(TAG, "Query specified applicationIdentifier match, but credential type does not have application identifier");
                }
            }
            if (mustMatchOnMamEnrollmentIdentifier) {
                if (credential instanceof AccessTokenRecord) {
                    accessToken = (AccessTokenRecord)credential;
                    matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(mamEnrollmentIdentifier, accessToken.getMamEnrollmentIdentifier());
                } else {
                    Logger.verbose(TAG, "Query specified mamEnrollmentIdentifier match, but credential type does not have MAM enrollment identifier");
                }
            }
            if (mustMatchOnRealm && credential instanceof AccessTokenRecord) {
                accessToken = (AccessTokenRecord)credential;
                boolean bl = matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(realm, accessToken.getRealm());
            }
            if (mustMatchOnRealm && credential instanceof IdTokenRecord) {
                IdTokenRecord idToken = (IdTokenRecord)credential;
                boolean bl = matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(realm, idToken.getRealm());
            }
            if (mustMatchOnTarget) {
                if (credential instanceof AccessTokenRecord) {
                    accessToken = (AccessTokenRecord)credential;
                    matches = matches && AbstractAccountCredentialCache.targetsIntersect(target, accessToken.getTarget(), true);
                } else if (credential instanceof RefreshTokenRecord) {
                    RefreshTokenRecord refreshToken = (RefreshTokenRecord)credential;
                    matches = matches && AbstractAccountCredentialCache.targetsIntersect(target, refreshToken.getTarget(), true);
                } else {
                    Logger.verbose(TAG, "Query specified target-match, but no target to match.");
                }
            }
            if (mustMatchOnAuthScheme && credential instanceof AccessTokenRecord) {
                accessToken = (AccessTokenRecord)credential;
                String atType = accessToken.getAccessTokenType();
                if (null != atType) {
                    atType = atType.trim();
                }
                if ("pop".equalsIgnoreCase(atType)) {
                    matches = matches && (authScheme.equalsIgnoreCase("PoP_With_Client_Key") || authScheme.equalsIgnoreCase("PoP"));
                } else {
                    boolean bl = matches = matches && authScheme.equalsIgnoreCase(atType);
                }
            }
            if (mustMatchOnKid && credential instanceof AccessTokenRecord) {
                accessToken = (AccessTokenRecord)credential;
                boolean bl = matches = matches && kid.equalsIgnoreCase(accessToken.getKid());
            }
            if (mustMatchOnRequestedClaims) {
                if (credential instanceof AccessTokenRecord) {
                    accessToken = (AccessTokenRecord)credential;
                    matches = matches && StringUtil.equalsIgnoreCaseTrimBoth(requestedClaims, accessToken.getRequestedClaims());
                } else {
                    Logger.verbose(TAG, "Query specified requested_claims-match, but attempted to match with non-AT credential type.");
                }
            }
            if (!matches) continue;
            matchingCredentials.add(credential);
        }
        return matchingCredentials;
    }

    static boolean targetsIntersect(@NonNull String targetToMatch, @NonNull String credentialTarget, boolean omitDefaultScopes) {
        if (targetToMatch == null) {
            throw new NullPointerException("targetToMatch is marked non-null but is null");
        }
        if (credentialTarget == null) {
            throw new NullPointerException("credentialTarget is marked non-null but is null");
        }
        String splitCriteria = "\\s+";
        String[] targetToMatchArray = targetToMatch.trim().split("\\s+");
        String[] credentialTargetArray = credentialTarget.trim().split("\\s+");
        HashSet<String> soughtTargetSet = new HashSet<String>();
        HashSet<String> credentialTargetSet = new HashSet<String>();
        for (String target : targetToMatchArray) {
            soughtTargetSet.add(target.toLowerCase(Locale.ROOT));
        }
        for (String target : credentialTargetArray) {
            credentialTargetSet.add(target.toLowerCase(Locale.ROOT));
        }
        if (omitDefaultScopes) {
            soughtTargetSet.removeAll(AuthenticationConstants.DEFAULT_SCOPES);
            credentialTargetSet.removeAll(AuthenticationConstants.DEFAULT_SCOPES);
        }
        return credentialTargetSet.containsAll(soughtTargetSet);
    }
}

