/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.challengehandlers;

import com.microsoft.identity.common.java.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class PKeyAuthChallengeFactory {
    private static final String TAG = PKeyAuthChallengeFactory.class.getSimpleName();
    private static final String CHALLENGE_REQUEST_CERT_AUTH_DELIMITER = ";";

    public PKeyAuthChallenge getPKeyAuthChallengeFromWebViewRedirect(@NonNull String redirectUri) throws ClientException {
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        Map<String, String> parameters = UrlUtil.getParameters(redirectUri);
        this.validatePKeyAuthChallengeFromWebViewRedirect(parameters);
        PKeyAuthChallenge.PKeyAuthChallengeBuilder builder = new PKeyAuthChallenge.PKeyAuthChallengeBuilder();
        builder.nonce(parameters.get(PKeyAuthChallenge.RequestField.Nonce.name().toLowerCase(Locale.US))).context(parameters.get(PKeyAuthChallenge.RequestField.Context.name())).version(parameters.get(PKeyAuthChallenge.RequestField.Version.name())).submitUrl(parameters.get(PKeyAuthChallenge.RequestField.SubmitUrl.name())).tenantId(parameters.get(PKeyAuthChallenge.RequestField.TenantId.name()));
        if (parameters.containsKey(PKeyAuthChallenge.RequestField.CertAuthorities.name())) {
            String authorities = parameters.get(PKeyAuthChallenge.RequestField.CertAuthorities.name());
            builder.certAuthorities(StringUtil.getStringTokens(authorities, CHALLENGE_REQUEST_CERT_AUTH_DELIMITER));
        }
        return builder.build();
    }

    public PKeyAuthChallenge getPKeyAuthChallengeFromTokenEndpointResponse(@NonNull String header, @NonNull String authority) throws ClientException, UnsupportedEncodingException {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (authority == null) {
            throw new NullPointerException("authority is marked non-null but is null");
        }
        this.validateHeaderForPkeyAuthChallenge(header);
        Map<String, String> headerItems = this.getPKeyAuthHeader(header);
        this.validatePKeyAuthChallengeFromTokenEndpointResponse(headerItems);
        PKeyAuthChallenge.PKeyAuthChallengeBuilder builder = new PKeyAuthChallenge.PKeyAuthChallengeBuilder();
        builder.submitUrl(authority).nonce(headerItems.get(PKeyAuthChallenge.RequestField.Nonce.name().toLowerCase(Locale.US))).context(headerItems.get(PKeyAuthChallenge.RequestField.Context.name())).version(headerItems.get(PKeyAuthChallenge.RequestField.Version.name())).tenantId(headerItems.get(PKeyAuthChallenge.RequestField.TenantId.name()));
        if (!StringUtil.isNullOrEmpty(headerItems.get(PKeyAuthChallenge.RequestField.CertThumbprint.name()))) {
            builder.thumbprint(headerItems.get(PKeyAuthChallenge.RequestField.CertThumbprint.name()));
        } else if (headerItems.containsKey(PKeyAuthChallenge.RequestField.CertAuthorities.name())) {
            String authorities = headerItems.get(PKeyAuthChallenge.RequestField.CertAuthorities.name());
            builder.certAuthorities(StringUtil.getStringTokens(authorities, CHALLENGE_REQUEST_CERT_AUTH_DELIMITER));
        }
        return builder.build();
    }

    private void validateHeaderForPkeyAuthChallenge(@NonNull String header) throws ClientException {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (StringUtil.isNullOrEmpty(header)) {
            throw new ClientException("Device certificate request is invalid", "header value is empty.");
        }
        if (!StringUtil.hasPrefixInHeader(header, "PKeyAuth")) {
            throw new ClientException("Device certificate request is invalid", "challenge response type is wrong.");
        }
    }

    private void validatePKeyAuthChallengeFromTokenEndpointResponse(Map<String, String> headerItems) throws ClientException {
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.Nonce.name()) && !headerItems.containsKey(PKeyAuthChallenge.RequestField.Nonce.name().toLowerCase(Locale.US))) {
            throw new ClientException("Device certificate request is invalid", "Nonce is empty.");
        }
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.Context.name())) {
            throw new ClientException("Device certificate request is invalid", "Context is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.Version.name())) {
            throw new ClientException("Device certificate request is invalid", "Version name is empty");
        }
    }

    private void validatePKeyAuthChallengeFromWebViewRedirect(Map<String, String> headerItems) throws ClientException {
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.Nonce.name()) && !headerItems.containsKey(PKeyAuthChallenge.RequestField.Nonce.name().toLowerCase(Locale.US))) {
            throw new ClientException("Device certificate request is invalid", "Nonce is empty.");
        }
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.Context.name())) {
            throw new ClientException("Device certificate request is invalid", "Context is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.Version.name())) {
            throw new ClientException("Device certificate request is invalid", "Version name is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.SubmitUrl.name())) {
            throw new ClientException("Device certificate request is invalid", "SubmitUrl is empty");
        }
    }

    private Map<String, String> getPKeyAuthHeader(String headerStr) throws ClientException, UnsupportedEncodingException {
        String authenticateHeader = headerStr.substring("PKeyAuth".length());
        ArrayList<String> queryPairs = StringUtil.splitWithQuotes(authenticateHeader, ',');
        HashMap<String, String> headerItems = new HashMap<String, String>();
        for (String queryPair : queryPairs) {
            ArrayList<String> pair = StringUtil.splitWithQuotes(queryPair, '=');
            if (pair.size() == 2 && !StringUtil.isNullOrEmpty(pair.get(0)) && !StringUtil.isNullOrEmpty(pair.get(1))) {
                String key = pair.get(0);
                String value = pair.get(1);
                key = StringUtil.urlFormDecode(key);
                value = StringUtil.urlFormDecode(value);
                key = key.trim();
                value = StringUtil.removeQuoteInHeaderValue(value.trim());
                headerItems.put(key, value);
                continue;
            }
            if (pair.size() == 1 && !StringUtil.isNullOrEmpty(pair.get(0))) {
                headerItems.put(StringUtil.urlFormDecode(pair.get(0)).trim(), StringUtil.urlFormDecode(""));
                continue;
            }
            throw new ClientException("Device certificate request is invalid", authenticateHeader);
        }
        return headerItems;
    }
}

