/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands;

import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.TokenCommand;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.UiRequiredException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.List;
import lombok.NonNull;

public class SilentTokenCommand
extends TokenCommand {
    public static final int ACQUIRE_TOKEN_SILENT_DEFAULT_TIMEOUT_MILLISECONDS = 30000;
    private static final String TAG = SilentTokenCommand.class.getSimpleName();

    public SilentTokenCommand(@NonNull SilentTokenCommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controller, callback, publicApiId);
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
    }

    public SilentTokenCommand(@NonNull SilentTokenCommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controllers, callback, publicApiId);
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controllers == null) {
            throw new NullPointerException("controllers is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AcquireTokenResult execute() throws Exception {
        AcquireTokenResult result = null;
        String methodName = ":execute";
        Span span = SpanExtension.current();
        span.setAttribute(AttributeName.application_name.name(), this.getParameters().getApplicationName());
        span.setAttribute(AttributeName.public_api_id.name(), this.getPublicApiId());
        try (Scope scope = SpanExtension.makeCurrentSpan(span);){
            for (int ii = 0; ii < this.getControllers().size(); ++ii) {
                BaseController controller = this.getControllers().get(ii);
                span.setAttribute(AttributeName.controller_name.name(), controller.getClass().getSimpleName());
                try {
                    Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
                    result = controller.acquireTokenSilent((SilentTokenCommandParameters)this.getParameters());
                    if (!result.getSucceeded().booleanValue()) continue;
                    Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName() + ": Succeeded");
                    span.setAttribute(AttributeName.is_serviced_from_cache.name(), result.getLocalAuthenticationResult().isServicedFromCache());
                    span.setStatus(StatusCode.OK);
                    AcquireTokenResult acquireTokenResult = result;
                    return acquireTokenResult;
                }
                catch (ClientException | UiRequiredException e) {
                    if (e.getErrorCode().equals("invalid_grant") && this.getControllers().size() > ii + 1) continue;
                    if (!e.getErrorCode().equals("no_tokens_found")) {
                        if (!e.getErrorCode().equals("no_account_found")) throw e;
                    }
                    if (this.getControllers().size() <= ii + 1) throw e;
                }
            }
            if (result == null) {
                span.setStatus(StatusCode.ERROR, "empty result");
            } else if (result.getSucceeded().booleanValue()) {
                span.setStatus(StatusCode.OK);
            } else {
                BaseException exception = ExceptionAdapter.exceptionFromAcquireTokenResult(result, this.getParameters());
                if (exception != null) {
                    span.recordException((Throwable)exception);
                    span.setStatus(StatusCode.ERROR);
                } else {
                    span.setStatus(StatusCode.ERROR, "empty exception");
                }
            }
            AcquireTokenResult acquireTokenResult = result;
            return acquireTokenResult;
        }
        catch (Throwable throwable) {
            span.setStatus(StatusCode.ERROR);
            span.recordException(throwable);
            throw throwable;
        }
    }

    @Override
    public boolean isEligibleForCaching() {
        return true;
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SilentTokenCommand)) {
            return false;
        }
        SilentTokenCommand other = (SilentTokenCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SilentTokenCommand;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

