/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.controllers;

import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.DeviceCodeFlowAuthResultCommand;
import com.microsoft.identity.common.java.commands.DeviceCodeFlowCommand;
import com.microsoft.identity.common.java.commands.DeviceCodeFlowTokenResultCommand;
import com.microsoft.identity.common.java.commands.ICommandResult;
import com.microsoft.identity.common.java.commands.InteractiveTokenCommand;
import com.microsoft.identity.common.java.commands.SilentTokenCommand;
import com.microsoft.identity.common.java.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.controllers.CommandResult;
import com.microsoft.identity.common.java.controllers.CommandResultCache;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.UserCancelException;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.logging.RequestContext;
import com.microsoft.identity.common.java.marker.CodeMarkerManager;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OtelContextExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.result.FinalizableResultFuture;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.java.result.VoidResult;
import com.microsoft.identity.common.java.telemetry.Telemetry;
import com.microsoft.identity.common.java.util.BiConsumer;
import com.microsoft.identity.common.java.util.IPlatformUtil;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.LocalBroadcaster;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;

public class CommandDispatcher {
    private static final String TAG = CommandDispatcher.class.getSimpleName();
    private static final int SILENT_REQUEST_THREAD_POOL_SIZE = 5;
    private static final int DCF_REQUEST_THREAD_POOL_SIZE = 5;
    private static ExecutorService sInteractiveExecutor = Executors.newSingleThreadExecutor();
    private static ExecutorService sSilentExecutor = Executors.newFixedThreadPool(5);
    private static final ExecutorService sDCFExecutor = Executors.newFixedThreadPool(5);
    private static final Object sLock = new Object();
    private static InteractiveTokenCommand sCommand = null;
    private static final CommandResultCache sCommandResultCache = new CommandResultCache();
    private static final Object mapAccessLock = new Object();
    private static ConcurrentMap<BaseCommand, FinalizableResultFuture<CommandResult>> sExecutingCommandMap = new ConcurrentHashMap<BaseCommand, FinalizableResultFuture<CommandResult>>();

    private static void cleanMap(BaseCommand command) {
        ConcurrentHashMap<BaseCommand, FinalizableResultFuture<CommandResult>> newMap = new ConcurrentHashMap<BaseCommand, FinalizableResultFuture<CommandResult>>();
        for (Map.Entry e : sExecutingCommandMap.entrySet()) {
            if (command == e.getKey()) continue;
            newMap.put((BaseCommand)e.getKey(), (FinalizableResultFuture)e.getValue());
        }
        sExecutingCommandMap = newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int outstandingCommands() {
        Object object = mapAccessLock;
        synchronized (object) {
            return sExecutingCommandMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCommandOutstanding(BaseCommand c) {
        Object object = mapAccessLock;
        synchronized (object) {
            for (Map.Entry e : sExecutingCommandMap.entrySet()) {
                if (e.getKey() != c) continue;
                System.out.println("Command out there " + c);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearState() throws Exception {
        Object object = mapAccessLock;
        synchronized (object) {
            sExecutingCommandMap.clear();
        }
        sSilentExecutor.shutdownNow();
        sInteractiveExecutor.shutdownNow();
        Field f = CommandDispatcher.class.getDeclaredField("sSilentExecutor");
        f.setAccessible(true);
        f.set(null, Executors.newFixedThreadPool(5));
        f.setAccessible(false);
        f = CommandDispatcher.class.getDeclaredField("sInteractiveExecutor");
        f.setAccessible(true);
        f.set(null, Executors.newSingleThreadExecutor());
        f.setAccessible(false);
    }

    public static void submitSilent(@NonNull BaseCommand command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        CommandDispatcher.submitSilentReturningFuture(command);
    }

    public static AuthorizationResult submitDcfAuthResultSilent(@NonNull DeviceCodeFlowAuthResultCommand command) throws BaseException {
        CommandResult commandResult;
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        try {
            commandResult = (CommandResult)CommandDispatcher.submitSilentReturningFuture(command).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionAdapter.baseExceptionFromException(e);
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.COMPLETED) {
            return (AuthorizationResult)commandResult.getResult();
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.ERROR) {
            throw ExceptionAdapter.baseExceptionFromException((Throwable)commandResult.getResult());
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.CANCEL) {
            throw new UserCancelException("User cancelled", "Request cancelled by user");
        }
        throw new ClientException("unknown_error", "Unexpected CommandResult status");
    }

    public static ILocalAuthenticationResult submitDcfTokenResultSilent(@NonNull DeviceCodeFlowTokenResultCommand command) throws BaseException {
        CommandResult commandResult;
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        try {
            commandResult = (CommandResult)CommandDispatcher.submitSilentReturningFuture(command).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionAdapter.baseExceptionFromException(e);
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.COMPLETED) {
            return (ILocalAuthenticationResult)commandResult.getResult();
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.ERROR) {
            throw ExceptionAdapter.baseExceptionFromException((Throwable)commandResult.getResult());
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.CANCEL) {
            throw new UserCancelException("User cancelled", "Request cancelled by user");
        }
        throw new ClientException("unknown_error", "Unexpected CommandResult status");
    }

    public static ILocalAuthenticationResult submitAcquireTokenSilentSync(@NonNull SilentTokenCommand command) throws BaseException {
        CommandResult commandResult;
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        try {
            commandResult = (CommandResult)CommandDispatcher.submitSilentReturningFuture(command).get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw ExceptionAdapter.baseExceptionFromException(e);
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.COMPLETED) {
            return (ILocalAuthenticationResult)commandResult.getResult();
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.ERROR) {
            throw ExceptionAdapter.baseExceptionFromException((Throwable)commandResult.getResult());
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.CANCEL) {
            throw new UserCancelException("User cancelled", "Request cancelled by user");
        }
        throw new ClientException("unknown_error", "Unexpected CommandResult status");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FinalizableResultFuture<CommandResult> submitSilentReturningFuture(final @NonNull BaseCommand command) {
        String methodName;
        ExecutorService commandExecutor;
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        final CodeMarkerManager codeMarkerManager = CodeMarkerManager.getInstance();
        final CommandParameters commandParameters = command.getParameters();
        final String correlationId = CommandDispatcher.initializeDiagnosticContext(commandParameters.getCorrelationId(), commandParameters.getSdkType() == null ? SdkType.UNKNOWN.getProductName() : commandParameters.getSdkType().getProductName(), commandParameters.getSdkVersion());
        commandParameters.setCorrelationId(correlationId);
        final boolean isDeviceCodeFlowRequest = CommandDispatcher.isDeviceCodeFlowRequest(command);
        if (isDeviceCodeFlowRequest) {
            commandExecutor = sDCFExecutor;
            codeMarkerManager.markCode("10015");
            methodName = ":submitDCF";
        } else {
            commandExecutor = sSilentExecutor;
            codeMarkerManager.markCode("10011");
            methodName = ":submitSilent";
        }
        CommandDispatcher.logParameters(TAG + methodName, correlationId, commandParameters, command.getPublicApiId());
        Object object = mapAccessLock;
        synchronized (object) {
            FinalizableResultFuture<CommandResult> finalFuture;
            if (command.isEligibleForCaching()) {
                FinalizableResultFuture<CommandResult> future = (FinalizableResultFuture<CommandResult>)sExecutingCommandMap.get(command);
                if (null == future) {
                    future = new FinalizableResultFuture<CommandResult>();
                    FinalizableResultFuture<CommandResult> putValue = sExecutingCommandMap.putIfAbsent(command, future);
                    if (null != putValue) {
                        putValue.whenComplete(CommandDispatcher.getCommandResultConsumer(command));
                        return putValue;
                    }
                } else {
                    future.whenComplete(CommandDispatcher.getCommandResultConsumer(command));
                    return future;
                }
                future.whenComplete(CommandDispatcher.getCommandResultConsumer(command));
                finalFuture = future;
            } else {
                finalFuture = new FinalizableResultFuture<CommandResult>();
                finalFuture.whenComplete(CommandDispatcher.getCommandResultConsumer(command));
            }
            SpanExtension.current().setAttribute(AttributeName.num_concurrent_silent_requests.name(), (long)sExecutingCommandMap.size());
            commandExecutor.execute(OtelContextExtension.wrap(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object commandResult;
                    codeMarkerManager.markCode(isDeviceCodeFlowRequest ? "10016" : "10012");
                    try {
                        CommandDispatcher.initializeDiagnosticContext(correlationId, commandParameters.getSdkType() == null ? SdkType.UNKNOWN.getProductName() : commandParameters.getSdkType().getProductName(), commandParameters.getSdkVersion());
                        CommandDispatcher.initTelemetryForCommand(command);
                        EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                        commandResult = null;
                        if (command.getParameters() instanceof SilentTokenCommandParameters) {
                            EstsTelemetry.getInstance().emitForceRefresh(((SilentTokenCommandParameters)command.getParameters()).isForceRefresh());
                        }
                        codeMarkerManager.markCode(isDeviceCodeFlowRequest ? "10017" : "10013");
                        try {
                            commandResult = CommandDispatcher.executeCommand(command);
                            codeMarkerManager.markCode(isDeviceCodeFlowRequest ? "10018" : "10014");
                        }
                        catch (Throwable throwable) {
                            codeMarkerManager.markCode(isDeviceCodeFlowRequest ? "10018" : "10014");
                            throw throwable;
                        }
                        Logger.info(TAG + methodName, "Completed silent request as owner for correlation id : **" + correlationId + ", with the status : " + ((CommandResult)commandResult).getStatus().getLogStatus() + " is cacheable : " + command.isEligibleForCaching());
                        EstsTelemetry.getInstance().flush(command, (ICommandResult)commandResult);
                        finalFuture.setResult(commandResult);
                    }
                    catch (Throwable t) {
                        Logger.info(TAG + methodName, "Request encountered an exception with correlation id : **" + correlationId);
                        finalFuture.setException(new ExecutionException(t));
                    }
                    finally {
                        commandResult = mapAccessLock;
                        synchronized (commandResult) {
                            FinalizableResultFuture mapFuture;
                            if (command.isEligibleForCaching() && (mapFuture = (FinalizableResultFuture)sExecutingCommandMap.remove(command)) == null) {
                                Logger.error(TAG, "The command in the map has mutated " + command.getClass().getCanonicalName() + " the calling application was " + command.getParameters().getApplicationName(), null);
                                CommandDispatcher.cleanMap(command);
                            }
                            finalFuture.setCleanedUp();
                        }
                        DiagnosticContext.INSTANCE.clear();
                    }
                    codeMarkerManager.markCode(isDeviceCodeFlowRequest ? "10019" : "10020");
                }
            }));
            return finalFuture;
        }
    }

    public static void submitAndForget(@NonNull BaseCommand command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        CommandDispatcher.submitAndForgetReturningFuture(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FinalizableResultFuture<CommandResult> submitAndForgetReturningFuture(final @NonNull BaseCommand command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        String methodName = ":submit";
        final CommandParameters commandParameters = command.getParameters();
        final String correlationId = CommandDispatcher.initializeDiagnosticContext(commandParameters.getCorrelationId(), commandParameters.getSdkType() == null ? SdkType.UNKNOWN.getProductName() : commandParameters.getSdkType().getProductName(), commandParameters.getSdkVersion());
        commandParameters.setCorrelationId(correlationId);
        CommandDispatcher.logParameters(TAG + ":submit", correlationId, commandParameters, command.getPublicApiId());
        Logger.info(TAG, "RefreshOnCommand with CorrelationId: " + correlationId);
        Object object = mapAccessLock;
        synchronized (object) {
            final FinalizableResultFuture<CommandResult> finalFuture = new FinalizableResultFuture<CommandResult>();
            finalFuture.whenComplete(CommandDispatcher.getCommandResultConsumer(command));
            sSilentExecutor.execute(OtelContextExtension.wrap(new Runnable(){

                @Override
                public void run() {
                    try {
                        CommandDispatcher.initializeDiagnosticContext(correlationId, commandParameters.getSdkType() == null ? SdkType.UNKNOWN.getProductName() : commandParameters.getSdkType().getProductName(), commandParameters.getSdkVersion());
                        EstsTelemetry.getInstance().initTelemetryForCommand(command);
                        EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                        CommandResult commandResult = CommandDispatcher.executeCommand(command);
                        Logger.info(TAG + ":submit", "Completed as owner for correlation id : **" + correlationId + CommandDispatcher.statusMsg(commandResult.getStatus().getLogStatus()) + " is cacheable : " + command.isEligibleForCaching());
                        EstsTelemetry.getInstance().flush(command, commandResult);
                        finalFuture.setResult(commandResult);
                    }
                    catch (Throwable t) {
                        Logger.info(TAG + ":submit", "Request encountered an exception with correlation id : **" + correlationId);
                        finalFuture.setException(new ExecutionException(t));
                    }
                    finally {
                        DiagnosticContext.INSTANCE.clear();
                    }
                }
            }));
            return finalFuture;
        }
    }

    private static void initTelemetryForCommand(@NonNull BaseCommand<?> command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        EstsTelemetry.getInstance().setUp(command.getParameters().getPlatformComponents());
        EstsTelemetry.getInstance().initTelemetryForCommand(command);
    }

    private static void logParameters(@NonNull String tag, @NonNull String correlationId, @NonNull Object parameters, @Nullable String publicApiId) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (correlationId == null) {
            throw new NullPointerException("correlationId is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String TAG = tag + ":" + parameters.getClass().getSimpleName();
        Logger.info(TAG, "Starting request with request context: " + DiagnosticContext.INSTANCE.getRequestContext().toJsonString() + ", with PublicApiId: " + publicApiId);
        if (Logger.isAllowPii()) {
            Logger.infoPII(TAG, ObjectMapper.serializeObjectToJsonString(parameters));
        } else {
            Logger.info(TAG, ObjectMapper.serializeExposedFieldsOfObjectToJsonString(parameters));
        }
    }

    private static BiConsumer<CommandResult, Throwable> getCommandResultConsumer(final @NonNull BaseCommand command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        String methodName = ":getCommandResultConsumer";
        return new BiConsumer<CommandResult, Throwable>(){

            @Override
            public void accept(CommandResult result, final Throwable throwable) {
                if (null != throwable) {
                    Logger.info(TAG + ":getCommandResultConsumer", "Request encountered an exception (this maybe a duplicate request which caries the exception encountered by the original request)");
                    command.getParameters().getPlatformComponents().getPlatformUtil().postCommandResult(new Runnable(){

                        @Override
                        public void run() {
                            CommandDispatcher.commandCallBackOnError(command, throwable);
                        }
                    });
                    return;
                }
                if (!StringUtil.isNullOrEmpty(result.getCorrelationId()) && !command.getParameters().getCorrelationId().equals(result.getCorrelationId())) {
                    Logger.info(TAG + ":getCommandResultConsumer", "Completed duplicate request with correlation id : **" + command.getParameters().getCorrelationId() + ", having the same result as : " + result.getCorrelationId() + ", with the status : " + result.getStatus().getLogStatus());
                }
                CommandDispatcher.returnCommandResult(command, result);
            }
        };
    }

    private static void commandCallBackOnError(@NonNull BaseCommand command, Throwable throwable) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        command.getCallback().onError(ExceptionAdapter.baseExceptionFromException(throwable));
    }

    public static void clearCommandCache() {
        sCommandResultCache.clear();
    }

    private static CommandResult executeCommand(BaseCommand command) {
        Object result = null;
        BaseException baseException = null;
        CommandResult<Object> commandResult = null;
        try {
            result = command.execute();
        }
        catch (Exception e) {
            baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
        }
        String correlationId = command.getParameters().getCorrelationId();
        commandResult = baseException != null ? (baseException instanceof UserCancelException ? CommandResult.ofNull(ICommandResult.ResultStatus.CANCEL, correlationId) : CommandResult.of(ICommandResult.ResultStatus.ERROR, baseException, correlationId)) : (result != null && result instanceof AcquireTokenResult ? CommandDispatcher.getCommandResultFromTokenResult((AcquireTokenResult)result, command.getParameters()) : (result instanceof VoidResult ? new CommandResult<Object>(ICommandResult.ResultStatus.VOID, result, command.getParameters().getCorrelationId()) : (result == null ? CommandResult.ofNull(ICommandResult.ResultStatus.COMPLETED, correlationId) : new CommandResult<Object>(ICommandResult.ResultStatus.COMPLETED, result, correlationId))));
        CommandDispatcher.setCorrelationIdOnResult(commandResult, correlationId);
        CommandDispatcher.setTelemetryOnResultAndFlush(commandResult, correlationId);
        return commandResult;
    }

    private static void setTelemetryOnResultAndFlush(@NonNull CommandResult commandResult, @NonNull String correlationId) {
        if (commandResult == null) {
            throw new NullPointerException("commandResult is marked non-null but is null");
        }
        if (correlationId == null) {
            throw new NullPointerException("correlationId is marked non-null but is null");
        }
        List<Map<String, String>> telemetryMap = Telemetry.getInstance().getMap(correlationId);
        commandResult.setTelemetryMap(telemetryMap);
        if (commandResult.getResult() instanceof LocalAuthenticationResult) {
            ((LocalAuthenticationResult)commandResult.getResult()).setTelemetry(telemetryMap);
        } else if (commandResult.getResult() instanceof BaseException) {
            ((BaseException)commandResult.getResult()).setTelemetry(telemetryMap);
        } else if (commandResult.getResult() != null) {
            Logger.verbose(TAG + ":setTelemetryOnResult", "Not setting telemetry on result as result type is " + commandResult.getResult().getClass().getCanonicalName() + " and doesn't support telemetry at this time.");
        }
        Telemetry.getInstance().flush(correlationId);
    }

    private static void returnCommandResult(final @NonNull BaseCommand command, final @NonNull CommandResult result) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        IPlatformUtil platformUtil = command.getParameters().getPlatformComponents().getPlatformUtil();
        platformUtil.onReturnCommandResult(command);
        platformUtil.postCommandResult(new Runnable(){

            @Override
            public void run() {
                switch (result.getStatus()) {
                    case ERROR: {
                        CommandDispatcher.commandCallbackOnError(command, result);
                        break;
                    }
                    case COMPLETED: {
                        CommandDispatcher.commandCallbackOnTaskCompleted(command, result);
                        break;
                    }
                    case CANCEL: {
                        command.getCallback().onCancel();
                        break;
                    }
                }
            }
        });
    }

    private static void commandCallbackOnError(BaseCommand command, CommandResult result) {
        command.getCallback().onError(ExceptionAdapter.baseExceptionFromException((Throwable)result.getResult()));
    }

    private static void commandCallbackOnTaskCompleted(BaseCommand command, CommandResult result) {
        command.getCallback().onTaskCompleted(result.getResult());
    }

    private static void cacheCommandResult(BaseCommand command, CommandResult commandResult) {
        if (command.isEligibleForCaching() && CommandDispatcher.eligibleToCache(commandResult)) {
            sCommandResultCache.put(command, commandResult);
        }
    }

    private static CommandResult getCommandResultFromTokenResult(@NonNull AcquireTokenResult result, @NonNull CommandParameters commandParameters) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        if (commandParameters == null) {
            throw new NullPointerException("commandParameters is marked non-null but is null");
        }
        if (result.getSucceeded().booleanValue()) {
            return new CommandResult<ILocalAuthenticationResult>(ICommandResult.ResultStatus.COMPLETED, result.getLocalAuthenticationResult(), commandParameters.getCorrelationId());
        }
        BaseException baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result, commandParameters);
        if (baseException instanceof UserCancelException) {
            return CommandResult.ofNull(ICommandResult.ResultStatus.CANCEL, commandParameters.getCorrelationId());
        }
        return new CommandResult<BaseException>(ICommandResult.ResultStatus.ERROR, baseException, commandParameters.getCorrelationId());
    }

    private static boolean eligibleToCache(@NonNull CommandResult commandResult) {
        if (commandResult == null) {
            throw new NullPointerException("commandResult is marked non-null but is null");
        }
        String methodName = ":eligibleToCache";
        switch (commandResult.getStatus()) {
            case ERROR: {
                if (commandResult.getResult() instanceof BaseException) {
                    return ((BaseException)commandResult.getResult()).isCacheable();
                }
                Logger.warn(TAG + ":eligibleToCache", "Get status ERROR, but result is not a BaseException");
                return true;
            }
            case COMPLETED: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginInteractive(final InteractiveTokenCommand command) {
        String methodName = ":beginInteractive";
        Object object = sLock;
        synchronized (object) {
            if (LibraryConfiguration.getInstance().isAuthorizationInCurrentTask() || command.getParameters() instanceof BrokerInteractiveTokenCommandParameters) {
                if (LocalBroadcaster.INSTANCE.hasReceivers("cancel_authorization_request")) {
                    LocalBroadcaster.INSTANCE.broadcast("cancel_authorization_request", new PropertyBag());
                } else if (LocalBroadcaster.INSTANCE.hasReceivers("return_authorization_request_result")) {
                    Logger.info(TAG + ":beginInteractive", "The previous interactive request was queued but never got processed and is blocking the interactive thread. Restarting the interactive executor service to enable processing interactive requests again.");
                    List<Runnable> cancelledRequests = sInteractiveExecutor.shutdownNow();
                    sInteractiveExecutor = Executors.newSingleThreadExecutor();
                    Logger.info(TAG + ":beginInteractive", "Cancelled execution of " + cancelledRequests.size() + " interactive requests.");
                }
            }
            sInteractiveExecutor.execute(OtelContextExtension.wrap(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CommandParameters commandParameters = command.getParameters();
                    String correlationId = CommandDispatcher.initializeDiagnosticContext(commandParameters.getCorrelationId(), commandParameters.getSdkType() == null ? SdkType.UNKNOWN.getProductName() : commandParameters.getSdkType().getProductName(), commandParameters.getSdkVersion());
                    try {
                        commandParameters.setCorrelationId(correlationId);
                        CommandDispatcher.logParameters(TAG + ":beginInteractive", correlationId, commandParameters, command.getPublicApiId());
                        CommandDispatcher.initTelemetryForCommand(command);
                        EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                        LocalBroadcaster.IReceiverCallback resultReceiver = new LocalBroadcaster.IReceiverCallback(){

                            @Override
                            public void onReceive(@NonNull PropertyBag dataBag) {
                                if (dataBag == null) {
                                    throw new NullPointerException("dataBag is marked non-null but is null");
                                }
                                CommandDispatcher.completeInteractive(dataBag);
                            }
                        };
                        LocalBroadcaster.INSTANCE.registerCallback("return_authorization_request_result", resultReceiver);
                        sCommand = command;
                        CommandResult commandResult = CommandDispatcher.executeCommand(command);
                        sCommand = null;
                        LocalBroadcaster.INSTANCE.unregisterCallback("return_authorization_request_result");
                        Logger.info(TAG + ":beginInteractive", "Completed interactive request for correlation id : **" + correlationId + CommandDispatcher.statusMsg(commandResult.getStatus().getLogStatus()));
                        EstsTelemetry.getInstance().flush(command, commandResult);
                        CommandDispatcher.returnCommandResult(command, commandResult);
                    }
                    finally {
                        DiagnosticContext.INSTANCE.clear();
                    }
                }
            }));
        }
    }

    private static void completeInteractive(PropertyBag propertyBag) {
        String methodName = ":completeInteractive";
        int requestCode = propertyBag.getOrDefault("com.microsoft.identity.client.request.code", -1);
        int resultCode = propertyBag.getOrDefault("com.microsoft.identity.client.result.code", -1);
        if (sCommand != null) {
            sCommand.onFinishAuthorizationSession(requestCode, resultCode, propertyBag);
        } else {
            Logger.warn(TAG + ":completeInteractive", "sCommand is null, No interactive call in progress to complete.");
        }
    }

    public static String initializeDiagnosticContext(@Nullable String requestCorrelationId, String sdkType, String sdkVersion) {
        String methodName = ":initializeDiagnosticContext";
        String correlationId = StringUtil.isNullOrEmpty(requestCorrelationId) ? UUID.randomUUID().toString() : requestCorrelationId;
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        rc.put("x-client-SKU", sdkType);
        rc.put("x-client-Ver", sdkVersion);
        DiagnosticContext.INSTANCE.setRequestContext(rc);
        Logger.verbose(TAG + ":initializeDiagnosticContext", "Initialized new DiagnosticContext");
        return correlationId;
    }

    public static int getCachedResultCount() {
        return sCommandResultCache.getSize();
    }

    private static void setCorrelationIdOnResult(@NonNull CommandResult commandResult, @NonNull String correlationId) {
        if (commandResult == null) {
            throw new NullPointerException("commandResult is marked non-null but is null");
        }
        if (correlationId == null) {
            throw new NullPointerException("correlationId is marked non-null but is null");
        }
        if (commandResult.getResult() != null && commandResult.getResult() instanceof LocalAuthenticationResult) {
            LocalAuthenticationResult localAuthenticationResult = (LocalAuthenticationResult)commandResult.getResult();
            localAuthenticationResult.setCorrelationId(correlationId);
        }
    }

    private static String statusMsg(String status) {
        return ", with the status : " + status;
    }

    private static boolean isDeviceCodeFlowRequest(BaseCommand command) {
        return command instanceof DeviceCodeFlowCommand || command instanceof DeviceCodeFlowAuthResultCommand || command instanceof DeviceCodeFlowTokenResultCommand;
    }

    public static void stopSilentRequestExecutor() {
        String methodTag = TAG + ":stopSilentRequestExecutor";
        Logger.info(methodTag, "shutting down..");
        sSilentExecutor.shutdown();
        try {
            if (!sSilentExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                Logger.warn(methodTag, "terminating now");
                sSilentExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Logger.warn(methodTag, "terminating again");
            sSilentExecutor.shutdownNow();
        }
    }

    public static void resetSilentRequestExecutor() {
        Logger.info(TAG + ":resetSilentRequestExecutor", "Resetting silent Executor");
        sSilentExecutor = Executors.newFixedThreadPool(5);
    }
}

