/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.eststelemetry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.microsoft.identity.common.java.eststelemetry.IRequestTelemetryCache;
import com.microsoft.identity.common.java.eststelemetry.LastRequestTelemetry;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.logging.Logger;
import lombok.NonNull;

public class LastRequestTelemetryCache
implements IRequestTelemetryCache<LastRequestTelemetry> {
    static final String LAST_TELEMETRY_OBJECT_CACHE_KEY = "last_telemetry_object";
    static final String LAST_TELEMETRY_HEADER_STRING_CACHE_KEY = "last_telemetry_header_string";
    static final String LAST_TELEMETRY_SCHEMA_VERSION_CACHE_KEY = "last_telemetry_schema_version";
    private static final String TAG = LastRequestTelemetryCache.class.getSimpleName();
    private static final Gson mGson = new Gson();
    private final INameValueStorage<String> mStorage;

    public LastRequestTelemetryCache(@NonNull INameValueStorage<String> keyPairStorage) {
        if (keyPairStorage == null) {
            throw new NullPointerException("keyPairStorage is marked non-null but is null");
        }
        Logger.verbose(TAG, "Init: " + TAG);
        this.mStorage = keyPairStorage;
    }

    @Override
    public synchronized LastRequestTelemetry getRequestTelemetryFromCache() {
        String methodName = ":getRequestTelemetryFromCache";
        try {
            String cacheValue = this.mStorage.get(LAST_TELEMETRY_OBJECT_CACHE_KEY);
            if (cacheValue == null) {
                Logger.info(TAG + ":getRequestTelemetryFromCache", "There is no last request telemetry saved in the cache. Returning NULL");
                return null;
            }
            LastRequestTelemetry lastRequestTelemetry = (LastRequestTelemetry)mGson.fromJson(cacheValue, LastRequestTelemetry.class);
            if (lastRequestTelemetry == null) {
                Logger.warn(TAG + ":getRequestTelemetryFromCache", "Last Request Telemetry deserialization failed");
            }
            return lastRequestTelemetry;
        }
        catch (JsonSyntaxException e) {
            Logger.error(TAG + ":getRequestTelemetryFromCache", "Last Request Telemetry deserialization failed", e);
            return null;
        }
        catch (OutOfMemoryError e) {
            this.mStorage.clear();
            throw e;
        }
    }

    @Override
    public void clear() {
        this.mStorage.clear();
    }

    @Override
    public synchronized void saveRequestTelemetryToCache(@NonNull LastRequestTelemetry requestTelemetry) {
        if (requestTelemetry == null) {
            throw new NullPointerException("requestTelemetry is marked non-null but is null");
        }
        Logger.verbose(TAG, "Saving Last Request Telemetry to cache...");
        this.saveRequestTelemetryObjectToCache(requestTelemetry);
        this.saveTelemetryHeaderStringToCache(requestTelemetry);
        this.saveTelemetrySchemaVersionToCache(requestTelemetry);
    }

    private void saveRequestTelemetryObjectToCache(@NonNull LastRequestTelemetry requestTelemetry) {
        if (requestTelemetry == null) {
            throw new NullPointerException("requestTelemetry is marked non-null but is null");
        }
        String cacheValue = this.generateCacheValue(requestTelemetry);
        this.saveToTelemetryCache(LAST_TELEMETRY_OBJECT_CACHE_KEY, cacheValue);
    }

    private void saveTelemetryHeaderStringToCache(@NonNull LastRequestTelemetry requestTelemetry) {
        if (requestTelemetry == null) {
            throw new NullPointerException("requestTelemetry is marked non-null but is null");
        }
        String cacheValue = requestTelemetry.getCompleteHeaderString();
        this.saveToTelemetryCache(LAST_TELEMETRY_HEADER_STRING_CACHE_KEY, cacheValue);
    }

    private void saveTelemetrySchemaVersionToCache(@NonNull LastRequestTelemetry requestTelemetry) {
        if (requestTelemetry == null) {
            throw new NullPointerException("requestTelemetry is marked non-null but is null");
        }
        String cacheValue = requestTelemetry.getSchemaVersion();
        this.saveToTelemetryCache(LAST_TELEMETRY_SCHEMA_VERSION_CACHE_KEY, cacheValue);
    }

    private void saveToTelemetryCache(@NonNull String cacheKey, @NonNull String cacheValue) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        if (cacheValue == null) {
            throw new NullPointerException("cacheValue is marked non-null but is null");
        }
        this.mStorage.put(cacheKey, cacheValue);
    }

    private String generateCacheValue(LastRequestTelemetry requestTelemetry) {
        JsonElement outboundElement = mGson.toJsonTree((Object)requestTelemetry);
        JsonObject outboundObject = outboundElement.getAsJsonObject();
        return mGson.toJson((JsonElement)outboundObject);
    }
}

