/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.exception;

import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.BrokerSilentTokenCommandParameters;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.regex.Pattern;

public class IntuneAppProtectionPolicyRequiredException
extends ServiceException {
    private static final String TAG = IntuneAppProtectionPolicyRequiredException.class.getSimpleName();
    public static final String sName = "com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException";
    private static final long serialVersionUID = -620109887467926354L;
    private String mAccountUpn;
    private String mAccountUserId;
    private String mTenantId;
    private String mAuthorityUrl;

    public IntuneAppProtectionPolicyRequiredException(String errorCode, String errorMessage) {
        super(errorCode, errorMessage, null);
    }

    public IntuneAppProtectionPolicyRequiredException(String errorCode, String errorMessage, Throwable throwable) {
        super(errorCode, errorMessage, throwable);
    }

    public IntuneAppProtectionPolicyRequiredException(String errorCode, String errorMessage, BrokerInteractiveTokenCommandParameters originalParameters) {
        super(errorCode, errorMessage, null);
        String upn = originalParameters.getBrokerAccount() != null ? originalParameters.getBrokerAccount().getUsername() : originalParameters.getLoginHint();
        String uId = originalParameters.getLocalAccountId();
        if (StringUtil.isNullOrEmpty(uId)) {
            Logger.info(TAG, "Local account id is empty, attempting get user id from home account id");
            uId = this.getUIdFromHomeAccountId(originalParameters.getHomeAccountId());
        }
        Authority authority = originalParameters.getAuthority();
        this.setAuthorityUrl(authority.getAuthorityURL().toString());
        String homeAccountId = originalParameters.getHomeAccountId();
        String tenantId = null;
        if (homeAccountId != null) {
            tenantId = StringUtil.getTenantInfo(homeAccountId).getValue();
        }
        if (StringUtil.isNullOrEmpty(tenantId) && authority instanceof AzureActiveDirectoryAuthority) {
            tenantId = ((AzureActiveDirectoryAuthority)authority).mAudience.getTenantId();
        }
        if (StringUtil.isNullOrEmpty(uId)) {
            Logger.verbose(TAG, "IntuneAppProtectionPolicyException property user id was null or empty.");
        }
        if (StringUtil.isNullOrEmpty(upn)) {
            Logger.verbose(TAG, "IntuneAppProtectionPolicyException property upn was null or empty.");
        }
        if (StringUtil.isNullOrEmpty(tenantId)) {
            Logger.verbose(TAG, "IntuneAppProtectionPolicyException property tenant id was null or empty.");
        }
        Logger.verbose(TAG, "Setting IntuneAppProtectionPolicyException properties");
        Logger.verbosePII(TAG, String.format("Setting IntuneAppProtectionPolicyException properties.  AccountId: %s, UPN: %s, TenantId: %s", uId, upn, tenantId));
        this.setAccountUserId(uId);
        this.setAccountUpn(upn);
        this.setTenantId(tenantId);
    }

    public IntuneAppProtectionPolicyRequiredException(String errorCode, String errorMessage, BrokerSilentTokenCommandParameters originalParameters) {
        super(errorCode, errorMessage, null);
        String upn = originalParameters.getBrokerAccount() != null ? originalParameters.getBrokerAccount().getUsername() : originalParameters.getLoginHint();
        this.setAccountUpn(upn);
        String uId = originalParameters.getLocalAccountId();
        if (StringUtil.isNullOrEmpty(uId)) {
            Logger.info(TAG, "Local account id is empty, attempting get user id from home account id");
            uId = this.getUIdFromHomeAccountId(originalParameters.getHomeAccountId());
        }
        this.setAccountUserId(uId);
        Authority authority = originalParameters.getAuthority();
        this.setAuthorityUrl(authority.getAuthorityURL().toString());
        String homeAccountId = originalParameters.getHomeAccountId();
        String tenantId = null;
        if (homeAccountId != null) {
            tenantId = StringUtil.getTenantInfo(homeAccountId).getValue();
        }
        if (StringUtil.isNullOrEmpty(tenantId) && authority instanceof AzureActiveDirectoryAuthority) {
            tenantId = ((AzureActiveDirectoryAuthority)authority).mAudience.getTenantId();
        }
        this.setTenantId(tenantId);
    }

    @Nullable
    private String getUIdFromHomeAccountId(@Nullable String homeAccountId) {
        String methodName = ":getUIdFromHomeAccountId";
        String DELIMITER_TENANTED_USER_ID = ".";
        int EXPECTED_ARGS_LEN = 2;
        boolean INDEX_USER_ID = false;
        if (!StringUtil.isNullOrEmpty(homeAccountId)) {
            String[] homeAccountIdSplit = homeAccountId.split(Pattern.quote("."));
            if (homeAccountIdSplit.length == 2) {
                Logger.info(TAG + ":getUIdFromHomeAccountId", "Home account id is tenanted, returning uid ");
                return homeAccountIdSplit[0];
            }
            if (homeAccountIdSplit.length == 1) {
                Logger.info(TAG + ":getUIdFromHomeAccountId", "Home account id not tenanted, it's the uid added by v1 broker ");
                return homeAccountIdSplit[0];
            }
        }
        Logger.warn(TAG + ":getUIdFromHomeAccountId", "Home Account id doesn't have uid or tenant id information, returning null ");
        return null;
    }

    public String getAccountUpn() {
        return this.mAccountUpn;
    }

    public void setAccountUpn(String accountUpn) {
        this.mAccountUpn = accountUpn;
    }

    public String getAccountUserId() {
        return this.mAccountUserId;
    }

    public void setAccountUserId(String accountUserId) {
        this.mAccountUserId = accountUserId;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public void setTenantId(String tenantId) {
        this.mTenantId = tenantId;
    }

    public String getAuthorityUrl() {
        return this.mAuthorityUrl;
    }

    public void setAuthorityUrl(String authorityUrl) {
        this.mAuthorityUrl = authorityUrl;
    }

    @Override
    public String getExceptionName() {
        return sName;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }
}

