/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.marker;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.marker.CodeMarker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class CodeMarkerManager {
    private static final String TAG = CodeMarkerManager.class.getSimpleName();
    private boolean enableCodeMarker = false;
    private static final int MAX_SIZE_CODE_MARKER = 1000;
    private final List<CodeMarker> codeMarkers = Collections.synchronizedList(new ArrayList());
    private long baseMilliSeconds = 0L;
    private String scenarioCode = null;

    private CodeMarkerManager() {
    }

    public static CodeMarkerManager getInstance() {
        return CodeMarkerHolder.INSTANCE;
    }

    public void markCode(String marker) {
        if (this.enableCodeMarker) {
            Logger.info(TAG + ":markCode", "Marking code with " + marker);
            if (this.codeMarkers.size() >= 1000) {
                this.clearMarkers();
            }
            long currentMilliSeconds = System.currentTimeMillis();
            if (this.codeMarkers.size() == 0) {
                this.baseMilliSeconds = currentMilliSeconds;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            String applicableMarker = (this.scenarioCode == null ? "" : this.scenarioCode) + marker;
            long timeDiff = currentMilliSeconds - this.baseMilliSeconds;
            String date = dateFormat.format(new Date());
            long threadId = Thread.currentThread().getId();
            CodeMarker codeMarker = new CodeMarker(applicableMarker, timeDiff, date, threadId);
            this.codeMarkers.add(codeMarker);
        }
    }

    public void setPrefixScenarioCode(String scenarioCode) {
        this.scenarioCode = scenarioCode;
    }

    public boolean codeMarkerIsEnabled() {
        return this.enableCodeMarker;
    }

    public void setEnableCodeMarker(boolean enableCodeMarker) {
        this.enableCodeMarker = enableCodeMarker;
    }

    public void clearMarkers() {
        this.codeMarkers.clear();
    }

    public void clearAll() {
        this.clearMarkers();
        this.scenarioCode = null;
    }

    public String getFileContent() {
        return this.getCsvContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCsvContent() {
        if (this.codeMarkers.isEmpty()) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        content.append(this.codeMarkers.get(0).getCsvHeader());
        List<CodeMarker> list = this.codeMarkers;
        synchronized (list) {
            for (CodeMarker codeMarker : this.codeMarkers) {
                content.append('\n');
                content.append(codeMarker.getCsvLine());
            }
        }
        return content.toString();
    }

    private static class CodeMarkerHolder {
        static final CodeMarkerManager INSTANCE = new CodeMarkerManager();

        private CodeMarkerHolder() {
        }
    }
}

