/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.commands.parameters;

import com.google.gson.annotations.Expose;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.exception.TerminalException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.BaseNativeAuthCommandParameters;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class AcquireTokenNoFixedScopesCommandParameters
extends BaseNativeAuthCommandParameters {
    private static final String TAG = AcquireTokenNoFixedScopesCommandParameters.class.getSimpleName();
    private static final Object sLock = new Object();
    private final IAccountRecord account;
    @Expose
    @NonNull
    private final AbstractAuthenticationScheme authenticationScheme;
    @Expose
    private final boolean forceRefresh;
    private final String loginHint;
    private final List<Map.Entry<String, String>> extraOptions;

    public void validate() throws ArgumentException {
        String methodName = ":validate";
        Logger.verbose(TAG + ":validate", "Validating operation params...");
        if (null == this.authenticationScheme) {
            throw new ArgumentException("acquireTokenNoFixedScope", "authentication_scheme", "authentication scheme is undefined");
        }
        if (this.getAccount() == null) {
            Logger.warn(TAG, "The account set on silent operation parameters is NULL.");
        }
    }

    private boolean authorityMatchesAccountEnvironment() {
        String errorCode;
        Exception cause;
        String methodName = ":authorityMatchesAccountEnvironment";
        try {
            AzureActiveDirectoryCloud cloud;
            if (!AzureActiveDirectory.isInitialized()) {
                AcquireTokenNoFixedScopesCommandParameters.performCloudDiscovery();
            }
            return (cloud = AzureActiveDirectory.getAzureActiveDirectoryCloudFromHostName(this.getAccount().getEnvironment())) != null && cloud.getPreferredNetworkHostName().equals(this.getAuthority().getAuthorityURL().getAuthority());
        }
        catch (IOException e) {
            cause = e;
            errorCode = "io_error";
        }
        catch (URISyntaxException e) {
            cause = e;
            errorCode = "malformed_url";
        }
        Logger.error(TAG + ":authorityMatchesAccountEnvironment", "Unable to perform cloud discovery", cause);
        throw new TerminalException("Unable to perform cloud discovery in order to validate request authority", cause, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCloudDiscovery() throws IOException, URISyntaxException {
        String methodName = ":performCloudDiscovery";
        Logger.verbose(TAG + ":performCloudDiscovery", "Performing cloud discovery...");
        Object object = sLock;
        synchronized (object) {
            AzureActiveDirectory.performCloudDiscovery();
        }
    }

    protected AcquireTokenNoFixedScopesCommandParameters(AcquireTokenNoFixedScopesCommandParametersBuilder<?, ?> b) {
        super((BaseNativeAuthCommandParameters.BaseNativeAuthCommandParametersBuilder<?, ?>)b);
        this.account = ((AcquireTokenNoFixedScopesCommandParametersBuilder)b).account;
        this.authenticationScheme = ((AcquireTokenNoFixedScopesCommandParametersBuilder)b).authenticationScheme;
        if (this.authenticationScheme == null) {
            throw new NullPointerException("authenticationScheme is marked non-null but is null");
        }
        this.forceRefresh = ((AcquireTokenNoFixedScopesCommandParametersBuilder)b).forceRefresh;
        this.loginHint = ((AcquireTokenNoFixedScopesCommandParametersBuilder)b).loginHint;
        this.extraOptions = ((AcquireTokenNoFixedScopesCommandParametersBuilder)b).extraOptions;
    }

    public static AcquireTokenNoFixedScopesCommandParametersBuilder<?, ?> builder() {
        return new AcquireTokenNoFixedScopesCommandParametersBuilderImpl();
    }

    @Override
    public AcquireTokenNoFixedScopesCommandParametersBuilder<?, ?> toBuilder() {
        return new AcquireTokenNoFixedScopesCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    public IAccountRecord getAccount() {
        return this.account;
    }

    @NonNull
    public AbstractAuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public boolean isForceRefresh() {
        return this.forceRefresh;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public List<Map.Entry<String, String>> getExtraOptions() {
        return this.extraOptions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcquireTokenNoFixedScopesCommandParameters)) {
            return false;
        }
        AcquireTokenNoFixedScopesCommandParameters other = (AcquireTokenNoFixedScopesCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isForceRefresh() != other.isForceRefresh()) {
            return false;
        }
        IAccountRecord this$account = this.getAccount();
        IAccountRecord other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        AbstractAuthenticationScheme this$authenticationScheme = this.getAuthenticationScheme();
        AbstractAuthenticationScheme other$authenticationScheme = other.getAuthenticationScheme();
        if (this$authenticationScheme == null ? other$authenticationScheme != null : !((Object)this$authenticationScheme).equals(other$authenticationScheme)) {
            return false;
        }
        String this$loginHint = this.getLoginHint();
        String other$loginHint = other.getLoginHint();
        if (this$loginHint == null ? other$loginHint != null : !this$loginHint.equals(other$loginHint)) {
            return false;
        }
        List<Map.Entry<String, String>> this$extraOptions = this.getExtraOptions();
        List<Map.Entry<String, String>> other$extraOptions = other.getExtraOptions();
        return !(this$extraOptions == null ? other$extraOptions != null : !((Object)this$extraOptions).equals(other$extraOptions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AcquireTokenNoFixedScopesCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isForceRefresh() ? 79 : 97);
        IAccountRecord $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        AbstractAuthenticationScheme $authenticationScheme = this.getAuthenticationScheme();
        result = result * 59 + ($authenticationScheme == null ? 43 : ((Object)$authenticationScheme).hashCode());
        String $loginHint = this.getLoginHint();
        result = result * 59 + ($loginHint == null ? 43 : $loginHint.hashCode());
        List<Map.Entry<String, String>> $extraOptions = this.getExtraOptions();
        result = result * 59 + ($extraOptions == null ? 43 : ((Object)$extraOptions).hashCode());
        return result;
    }

    private static final class AcquireTokenNoFixedScopesCommandParametersBuilderImpl
    extends AcquireTokenNoFixedScopesCommandParametersBuilder<AcquireTokenNoFixedScopesCommandParameters, AcquireTokenNoFixedScopesCommandParametersBuilderImpl> {
        private AcquireTokenNoFixedScopesCommandParametersBuilderImpl() {
        }

        @Override
        protected AcquireTokenNoFixedScopesCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public AcquireTokenNoFixedScopesCommandParameters build() {
            return new AcquireTokenNoFixedScopesCommandParameters(this);
        }
    }

    public static abstract class AcquireTokenNoFixedScopesCommandParametersBuilder<C extends AcquireTokenNoFixedScopesCommandParameters, B extends AcquireTokenNoFixedScopesCommandParametersBuilder<C, B>>
    extends BaseNativeAuthCommandParameters.BaseNativeAuthCommandParametersBuilder<C, B> {
        private IAccountRecord account;
        private AbstractAuthenticationScheme authenticationScheme;
        private boolean forceRefresh;
        private String loginHint;
        private List<Map.Entry<String, String>> extraOptions;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AcquireTokenNoFixedScopesCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AcquireTokenNoFixedScopesCommandParameters instance, AcquireTokenNoFixedScopesCommandParametersBuilder<?, ?> b) {
            b.account(instance.account);
            b.authenticationScheme(instance.authenticationScheme);
            b.forceRefresh(instance.forceRefresh);
            b.loginHint(instance.loginHint);
            b.extraOptions(instance.extraOptions);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B account(IAccountRecord account) {
            this.account = account;
            return (B)this.self();
        }

        public B authenticationScheme(@NonNull AbstractAuthenticationScheme authenticationScheme) {
            if (authenticationScheme == null) {
                throw new NullPointerException("authenticationScheme is marked non-null but is null");
            }
            this.authenticationScheme = authenticationScheme;
            return (B)this.self();
        }

        public B forceRefresh(boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return (B)this.self();
        }

        public B loginHint(String loginHint) {
            this.loginHint = loginHint;
            return (B)this.self();
        }

        public B extraOptions(List<Map.Entry<String, String>> extraOptions) {
            this.extraOptions = extraOptions;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder(super=" + super.toString() + ", account=" + this.account + ", authenticationScheme=" + this.authenticationScheme + ", forceRefresh=" + this.forceRefresh + ", loginHint=" + this.loginHint + ", extraOptions=" + this.extraOptions + ")";
        }
    }
}

