/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers;

import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitNewPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInWithSLTCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartUsingPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitUserAttributesCommandParameters;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2Configuration;
import com.microsoft.identity.common.java.nativeauth.providers.interactors.ResetPasswordInteractor;
import com.microsoft.identity.common.java.nativeauth.providers.interactors.SignInInteractor;
import com.microsoft.identity.common.java.nativeauth.providers.interactors.SignUpInteractor;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordPollCompletionApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordStartApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordSubmitApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInInitiateApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInTokenApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpStartApiResult;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0013\u001a\u00020\u000eJ\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020%J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020*J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000eJ\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0017\u001a\u000200J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000eJ\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002052\u0006\u00106\u001a\u000209J\u000e\u0010:\u001a\u00020;2\u0006\u00106\u001a\u00020<J\u000e\u0010=\u001a\u00020;2\u0006\u00106\u001a\u00020>J\u000e\u0010?\u001a\u00020;2\u0006\u00106\u001a\u00020@R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Strategy;", "Lcom/microsoft/identity/common/java/providers/microsoft/microsoftsts/MicrosoftStsOAuth2Strategy;", "strategyParameters", "Lcom/microsoft/identity/common/java/providers/oauth2/OAuth2StrategyParameters;", "config", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;", "signInInteractor", "Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/SignInInteractor;", "signUpInteractor", "Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/SignUpInteractor;", "resetPasswordInteractor", "Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/ResetPasswordInteractor;", "(Lcom/microsoft/identity/common/java/providers/oauth2/OAuth2StrategyParameters;Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/SignInInteractor;Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/SignUpInteractor;Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/ResetPasswordInteractor;)V", "CACHE_IDENTIFIER_MOCK", "", "TAG", "kotlin.jvm.PlatformType", "getConfig", "()Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;", "getAuthority", "getIssuerCacheIdentifierFromTokenEndpoint", "performOOBTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResult;", "parameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitCodeCommandParameters;", "performPasswordTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitPasswordCommandParameters;", "performResetPasswordChallenge", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordChallengeApiResult;", "passwordResetToken", "performResetPasswordContinue", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordContinueApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitCodeCommandParameters;", "performResetPasswordPollCompletion", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordPollCompletionApiResult;", "performResetPasswordStart", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordStartApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordStartCommandParameters;", "performResetPasswordSubmit", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitNewPasswordCommandParameters;", "performSLTTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInWithSLTCommandParameters;", "performSignInChallenge", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInChallengeApiResult;", "credentialToken", "performSignInInitiate", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInStartCommandParameters;", "performSignUpChallenge", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResult;", "signUpToken", "performSignUpStart", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResult;", "commandParameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpStartCommandParameters;", "performSignUpStartUsingPassword", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpStartUsingPasswordCommandParameters;", "performSignUpSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpContinueApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitCodeCommandParameters;", "performSignUpSubmitPassword", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitPasswordCommandParameters;", "performSignUpSubmitUserAttributes", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitUserAttributesCommandParameters;", "common4j"})
public final class NativeAuthOAuth2Strategy
extends MicrosoftStsOAuth2Strategy {
    @NotNull
    private final OAuth2StrategyParameters strategyParameters;
    @NotNull
    private final NativeAuthOAuth2Configuration config;
    @NotNull
    private final SignInInteractor signInInteractor;
    @NotNull
    private final SignUpInteractor signUpInteractor;
    @NotNull
    private final ResetPasswordInteractor resetPasswordInteractor;
    private final String TAG;
    @NotNull
    private final String CACHE_IDENTIFIER_MOCK;

    public NativeAuthOAuth2Strategy(@NotNull OAuth2StrategyParameters strategyParameters, @NotNull NativeAuthOAuth2Configuration config, @NotNull SignInInteractor signInInteractor, @NotNull SignUpInteractor signUpInteractor, @NotNull ResetPasswordInteractor resetPasswordInteractor) {
        Intrinsics.checkNotNullParameter((Object)strategyParameters, (String)"strategyParameters");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)signInInteractor, (String)"signInInteractor");
        Intrinsics.checkNotNullParameter((Object)signUpInteractor, (String)"signUpInteractor");
        Intrinsics.checkNotNullParameter((Object)resetPasswordInteractor, (String)"resetPasswordInteractor");
        super(config, strategyParameters);
        this.strategyParameters = strategyParameters;
        this.config = config;
        this.signInInteractor = signInInteractor;
        this.signUpInteractor = signUpInteractor;
        this.resetPasswordInteractor = resetPasswordInteractor;
        this.TAG = NativeAuthOAuth2Strategy.class.getSimpleName();
        this.CACHE_IDENTIFIER_MOCK = "login.windows.net";
    }

    @NotNull
    public final NativeAuthOAuth2Configuration getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public String getIssuerCacheIdentifierFromTokenEndpoint() {
        if (this.config.getUseMockApiForNativeAuth()) {
            return this.CACHE_IDENTIFIER_MOCK;
        }
        String string = super.getIssuerCacheIdentifierFromTokenEndpoint();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.getIssuerCacheIdentifierFromTokenEndpoint()");
        return string;
    }

    @NotNull
    public final String getAuthority() {
        String string = this.config.getAuthorityUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.authorityUrl.toString()");
        return string;
    }

    @NotNull
    public final SignUpStartApiResult performSignUpStart(@NotNull SignUpStartCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performSignUpStart");
        return this.signUpInteractor.performSignUpStart(commandParameters);
    }

    @NotNull
    public final SignUpStartApiResult performSignUpStartUsingPassword(@NotNull SignUpStartUsingPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performSignUpStartUsingPassword");
        return this.signUpInteractor.performSignUpStartUsingPassword(commandParameters);
    }

    @NotNull
    public final SignUpChallengeApiResult performSignUpChallenge(@NotNull String signUpToken) {
        Intrinsics.checkNotNullParameter((Object)signUpToken, (String)"signUpToken");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performSignUpChallenge");
        return this.signUpInteractor.performSignUpChallenge(signUpToken);
    }

    @NotNull
    public final SignUpContinueApiResult performSignUpSubmitCode(@NotNull SignUpSubmitCodeCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performSignUpSubmitCode");
        return this.signUpInteractor.performSignUpSubmitCode(commandParameters);
    }

    @NotNull
    public final SignUpContinueApiResult performSignUpSubmitPassword(@NotNull SignUpSubmitPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performSignUpSubmitPassword");
        return this.signUpInteractor.performSignUpSubmitPassword(commandParameters);
    }

    @NotNull
    public final SignUpContinueApiResult performSignUpSubmitUserAttributes(@NotNull SignUpSubmitUserAttributesCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performSignUpSubmitUserAttributes");
        return this.signUpInteractor.performSignUpSubmitUserAttributes(commandParameters);
    }

    @NotNull
    public final SignInInitiateApiResult performSignInInitiate(@NotNull SignInStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performSignInInitiate");
        return this.signInInteractor.performSignInInitiate(parameters);
    }

    @NotNull
    public final SignInChallengeApiResult performSignInChallenge(@NotNull String credentialToken) {
        Intrinsics.checkNotNullParameter((Object)credentialToken, (String)"credentialToken");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performSignInChallenge");
        return this.signInInteractor.performSignInChallenge(credentialToken);
    }

    @NotNull
    public final SignInTokenApiResult performSLTTokenRequest(@NotNull SignInWithSLTCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performSLTTokenRequest");
        return this.signInInteractor.performSLTTokenRequest(parameters);
    }

    @NotNull
    public final SignInTokenApiResult performOOBTokenRequest(@NotNull SignInSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performOOBTokenRequest");
        return this.signInInteractor.performOOBTokenRequest(parameters);
    }

    @NotNull
    public final SignInTokenApiResult performPasswordTokenRequest(@NotNull SignInSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performPasswordTokenRequest");
        return this.signInInteractor.performPasswordTokenRequest(parameters);
    }

    @NotNull
    public final ResetPasswordStartApiResult performResetPasswordStart(@NotNull ResetPasswordStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performResetPasswordStart");
        return this.resetPasswordInteractor.performResetPasswordStart(parameters);
    }

    @NotNull
    public final ResetPasswordChallengeApiResult performResetPasswordChallenge(@NotNull String passwordResetToken) {
        Intrinsics.checkNotNullParameter((Object)passwordResetToken, (String)"passwordResetToken");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performResetPasswordChallenge");
        return this.resetPasswordInteractor.performResetPasswordChallenge(passwordResetToken);
    }

    @NotNull
    public final ResetPasswordContinueApiResult performResetPasswordContinue(@NotNull ResetPasswordSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performResetPasswordContinue");
        return this.resetPasswordInteractor.performResetPasswordContinue(parameters);
    }

    @NotNull
    public final ResetPasswordSubmitApiResult performResetPasswordSubmit(@NotNull ResetPasswordSubmitNewPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performResetPasswordSubmit");
        return this.resetPasswordInteractor.performResetPasswordSubmit(parameters);
    }

    @NotNull
    public final ResetPasswordPollCompletionApiResult performResetPasswordPollCompletion(@NotNull String passwordResetToken) {
        Intrinsics.checkNotNullParameter((Object)passwordResetToken, (String)"passwordResetToken");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".performResetPasswordPollCompletion");
        return this.resetPasswordInteractor.performResetPasswordPollCompletion(passwordResetToken);
    }
}

