/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers;

import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2Configuration;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2Strategy;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthRequestProvider;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthResponseHandler;
import com.microsoft.identity.common.java.nativeauth.providers.interactors.ResetPasswordInteractor;
import com.microsoft.identity.common.java.nativeauth.providers.interactors.SignInInteractor;
import com.microsoft.identity.common.java.nativeauth.providers.interactors.SignUpInteractor;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2StrategyFactory;", "", "()V", "Companion", "common4j"})
public final class NativeAuthOAuth2StrategyFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2StrategyFactory$Companion;", "", "()V", "createStrategy", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Strategy;", "config", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;", "strategyParameters", "Lcom/microsoft/identity/common/java/providers/oauth2/OAuth2StrategyParameters;", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativeAuthOAuth2Strategy createStrategy(@NotNull NativeAuthOAuth2Configuration config, @NotNull OAuth2StrategyParameters strategyParameters) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)strategyParameters, (String)"strategyParameters");
            UrlConnectionHttpClient urlConnectionHttpClient = UrlConnectionHttpClient.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)urlConnectionHttpClient, (String)"getDefaultInstance()");
            SignInInteractor signInInteractor = new SignInInteractor(urlConnectionHttpClient, new NativeAuthRequestProvider(config), new NativeAuthResponseHandler());
            UrlConnectionHttpClient urlConnectionHttpClient2 = UrlConnectionHttpClient.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)urlConnectionHttpClient2, (String)"getDefaultInstance()");
            SignUpInteractor signUpInteractor = new SignUpInteractor(urlConnectionHttpClient2, new NativeAuthRequestProvider(config), new NativeAuthResponseHandler());
            UrlConnectionHttpClient urlConnectionHttpClient3 = UrlConnectionHttpClient.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)urlConnectionHttpClient3, (String)"getDefaultInstance()");
            return new NativeAuthOAuth2Strategy(strategyParameters, config, signInInteractor, signUpInteractor, new ResetPasswordInteractor(urlConnectionHttpClient3, new NativeAuthRequestProvider(config), new NativeAuthResponseHandler()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

