/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers;

import com.microsoft.identity.common.java.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitNewPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInWithSLTCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartUsingPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitUserAttributesCommandParameters;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2Configuration;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordContinueRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordPollCompletionRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordStartRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordSubmitRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInInitiateRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInTokenRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signup.SignUpChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signup.SignUpContinueRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signup.SignUpStartRequest;
import com.microsoft.identity.common.java.platform.Device;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J\u0015\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u000200H\u0000\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u0002072\u0006\u0010\u0015\u001a\u000208H\u0000\u00a2\u0006\u0002\b9J\u0015\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b=J\u0015\u0010>\u001a\u00020?2\u0006\u0010,\u001a\u00020@H\u0000\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020C2\u0006\u0010,\u001a\u00020DH\u0000\u00a2\u0006\u0002\bEJ\u0015\u0010F\u001a\u00020C2\u0006\u0010,\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ\u0015\u0010I\u001a\u00020C2\u0006\u0010,\u001a\u00020JH\u0000\u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u00020?2\u0006\u0010,\u001a\u00020MH\u0000\u00a2\u0006\u0002\bNJ\u0016\u0010O\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060PH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;", "", "config", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;", "(Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;)V", "TAG", "", "kotlin.jvm.PlatformType", "resetPasswordChallengeEndpoint", "resetPasswordContinueEndpoint", "resetPasswordPollCompletionEndpoint", "resetPasswordStartEndpoint", "resetPasswordSubmitEndpoint", "signInChallengeEndpoint", "signInInitiateEndpoint", "signInTokenEndpoint", "signUpChallengeEndpoint", "signUpContinueEndpoint", "signUpStartEndpoint", "createOOBTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInTokenRequest;", "parameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitCodeCommandParameters;", "createOOBTokenRequest$common4j", "createPasswordTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitPasswordCommandParameters;", "createPasswordTokenRequest$common4j", "createResetPasswordChallengeRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordChallengeRequest;", "passwordResetToken", "createResetPasswordChallengeRequest$common4j", "createResetPasswordContinueRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordContinueRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitCodeCommandParameters;", "createResetPasswordContinueRequest$common4j", "createResetPasswordPollCompletionRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordPollCompletionRequest;", "createResetPasswordPollCompletionRequest$common4j", "createResetPasswordStartRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordStartRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordStartCommandParameters;", "createResetPasswordStartRequest$common4j", "createResetPasswordSubmitRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordSubmitRequest;", "commandParameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitNewPasswordCommandParameters;", "createResetPasswordSubmitRequest$common4j", "createSLTTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInWithSLTCommandParameters;", "createSLTTokenRequest$common4j", "createSignInChallengeRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInChallengeRequest;", "credentialToken", "createSignInChallengeRequest$common4j", "createSignInInitiateRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInInitiateRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInStartCommandParameters;", "createSignInInitiateRequest$common4j", "createSignUpChallengeRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signup/SignUpChallengeRequest;", "signUpToken", "createSignUpChallengeRequest$common4j", "createSignUpStartRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signup/SignUpStartRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpStartCommandParameters;", "createSignUpStartRequest$common4j", "createSignUpSubmitCodeRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signup/SignUpContinueRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitCodeCommandParameters;", "createSignUpSubmitCodeRequest$common4j", "createSignUpSubmitPasswordRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitPasswordCommandParameters;", "createSignUpSubmitPasswordRequest$common4j", "createSignUpSubmitUserAttributesRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitUserAttributesCommandParameters;", "createSignUpSubmitUserAttributesRequest$common4j", "createSignUpUsingPasswordStartRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpStartUsingPasswordCommandParameters;", "createSignUpUsingPasswordStartRequest$common4j", "getRequestHeaders", "", "common4j"})
public final class NativeAuthRequestProvider {
    @NotNull
    private final NativeAuthOAuth2Configuration config;
    private final String TAG;
    @NotNull
    private final String signUpStartEndpoint;
    @NotNull
    private final String signUpChallengeEndpoint;
    @NotNull
    private final String signUpContinueEndpoint;
    @NotNull
    private final String signInInitiateEndpoint;
    @NotNull
    private final String signInChallengeEndpoint;
    @NotNull
    private final String signInTokenEndpoint;
    @NotNull
    private final String resetPasswordStartEndpoint;
    @NotNull
    private final String resetPasswordChallengeEndpoint;
    @NotNull
    private final String resetPasswordContinueEndpoint;
    @NotNull
    private final String resetPasswordSubmitEndpoint;
    @NotNull
    private final String resetPasswordPollCompletionEndpoint;

    public NativeAuthRequestProvider(@NotNull NativeAuthOAuth2Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.TAG = NativeAuthRequestProvider.class.getSimpleName();
        String string = this.config.getSignUpStartEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.getSignUpStartEndpoint().toString()");
        this.signUpStartEndpoint = string;
        String string2 = this.config.getSignUpChallengeEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.getSignUpChallengeEndpoint().toString()");
        this.signUpChallengeEndpoint = string2;
        String string3 = this.config.getSignUpContinueEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"config.getSignUpContinueEndpoint().toString()");
        this.signUpContinueEndpoint = string3;
        String string4 = this.config.getSignInInitiateEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"config.getSignInInitiateEndpoint().toString()");
        this.signInInitiateEndpoint = string4;
        String string5 = this.config.getSignInChallengeEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"config.getSignInChallengeEndpoint().toString()");
        this.signInChallengeEndpoint = string5;
        String string6 = this.config.getSignInTokenEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"config.getSignInTokenEndpoint().toString()");
        this.signInTokenEndpoint = string6;
        String string7 = this.config.getResetPasswordStartEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"config.getResetPasswordStartEndpoint().toString()");
        this.resetPasswordStartEndpoint = string7;
        String string8 = this.config.getResetPasswordChallengeEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"config.getResetPasswordC\u2026engeEndpoint().toString()");
        this.resetPasswordChallengeEndpoint = string8;
        String string9 = this.config.getResetPasswordContinueEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"config.getResetPasswordC\u2026inueEndpoint().toString()");
        this.resetPasswordContinueEndpoint = string9;
        String string10 = this.config.getResetPasswordSubmitEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"config.getResetPasswordSubmitEndpoint().toString()");
        this.resetPasswordSubmitEndpoint = string10;
        String string11 = this.config.getResetPasswordPollCompletionEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"config.getResetPasswordP\u2026tionEndpoint().toString()");
        this.resetPasswordPollCompletionEndpoint = string11;
    }

    @NotNull
    public final SignInInitiateRequest createSignInInitiateRequest$common4j(@NotNull SignInStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createSignInInitiateRequest");
        String string2 = parameters.username;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameters.username");
        return SignInInitiateRequest.Companion.create(string2, this.config.getClientId(), this.config.getChallengeType(), this.signInInitiateEndpoint, this.getRequestHeaders());
    }

    @NotNull
    public final SignInChallengeRequest createSignInChallengeRequest$common4j(@NotNull String credentialToken) {
        Intrinsics.checkNotNullParameter((Object)credentialToken, (String)"credentialToken");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createSignInChallengeRequest");
        return SignInChallengeRequest.Companion.create(this.config.getClientId(), credentialToken, this.config.getChallengeType(), this.signInChallengeEndpoint, this.getRequestHeaders());
    }

    @NotNull
    public final SignInTokenRequest createOOBTokenRequest$common4j(@NotNull SignInSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createOOBTokenRequest");
        SignInTokenRequest.Companion companion = SignInTokenRequest.Companion;
        String string2 = parameters.code;
        List list = parameters.scopes;
        String string3 = parameters.credentialToken;
        String string4 = this.config.getClientId();
        String string5 = this.config.getChallengeType();
        String string6 = this.signInTokenEndpoint;
        Map<String, String> map = this.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"code");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"credentialToken");
        return companion.createOOBTokenRequest(string2, string3, string4, list, string5, string6, map);
    }

    @NotNull
    public final SignInTokenRequest createSLTTokenRequest$common4j(@NotNull SignInWithSLTCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createSLTTokenRequest");
        SignInTokenRequest.Companion companion = SignInTokenRequest.Companion;
        String string2 = parameters.signInSLT;
        List list = parameters.scopes;
        String string3 = this.config.getClientId();
        String string4 = parameters.username;
        String string5 = this.config.getChallengeType();
        String string6 = this.signInTokenEndpoint;
        Map<String, String> map = this.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signInSLT");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"username");
        return companion.createSltTokenRequest(string2, string3, string4, list, string5, string6, map);
    }

    @NotNull
    public final SignInTokenRequest createPasswordTokenRequest$common4j(@NotNull SignInSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createPasswordTokenRequest");
        SignInTokenRequest.Companion companion = SignInTokenRequest.Companion;
        char[] cArray = parameters.password;
        List list = parameters.scopes;
        String string2 = parameters.credentialToken;
        String string3 = this.config.getClientId();
        String string4 = this.config.getChallengeType();
        String string5 = this.signInTokenEndpoint;
        Map<String, String> map = this.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"password");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"credentialToken");
        return companion.createPasswordTokenRequest(cArray, string2, string3, list, string4, string5, map);
    }

    @NotNull
    public final ResetPasswordStartRequest createResetPasswordStartRequest$common4j(@NotNull ResetPasswordStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createResetPasswordStartRequest");
        String string2 = this.config.getClientId();
        String string3 = parameters.username;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.username");
        return ResetPasswordStartRequest.Companion.create(string2, string3, this.config.getChallengeType(), this.resetPasswordStartEndpoint, this.getRequestHeaders());
    }

    @NotNull
    public final ResetPasswordChallengeRequest createResetPasswordChallengeRequest$common4j(@NotNull String passwordResetToken) {
        Intrinsics.checkNotNullParameter((Object)passwordResetToken, (String)"passwordResetToken");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createResetPasswordChallengeRequest");
        return ResetPasswordChallengeRequest.Companion.create(this.config.getClientId(), passwordResetToken, this.config.getChallengeType(), this.resetPasswordChallengeEndpoint, this.getRequestHeaders());
    }

    @NotNull
    public final ResetPasswordContinueRequest createResetPasswordContinueRequest$common4j(@NotNull ResetPasswordSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createResetPasswordContinueRequest");
        String string2 = this.config.getClientId();
        String string3 = parameters.passwordResetToken;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.passwordResetToken");
        String string4 = parameters.code;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"parameters.code");
        return ResetPasswordContinueRequest.Companion.create(string2, string3, string4, this.resetPasswordContinueEndpoint, this.getRequestHeaders());
    }

    @NotNull
    public final SignUpStartRequest createSignUpStartRequest$common4j(@NotNull SignUpStartCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createSignUpStartRequest");
        SignUpStartRequest.Companion companion = SignUpStartRequest.Companion;
        String string2 = commandParameters.username;
        Map map = commandParameters.userAttributes;
        String string3 = this.config.getChallengeType();
        String string4 = this.config.getClientId();
        String string5 = this.signUpStartEndpoint;
        Map<String, String> map2 = this.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"username");
        return SignUpStartRequest.Companion.create$default(companion, string2, null, map, string4, string3, string5, map2, 2, null);
    }

    @NotNull
    public final SignUpStartRequest createSignUpUsingPasswordStartRequest$common4j(@NotNull SignUpStartUsingPasswordCommandParameters commandParameters) {
        block5: {
            block4: {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
                    String string = this.TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                    LogSession.Companion.logMethodCall(string, this.TAG + ".createSignUpUsingPasswordStartRequest");
                    Intrinsics.checkNotNullExpressionValue((Object)commandParameters.password, (String)"commandParameters.password");
                    if (commandParameters.password.length == 0) break block4;
                    Intrinsics.checkNotNullExpressionValue((Object)commandParameters.password, (String)"commandParameters.password");
                    char[] $this$all$iv = commandParameters.password;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int i = 0; i < n; ++i) {
                        char element$iv;
                        char it = element$iv = $this$all$iv[i];
                        boolean bl2 = false;
                        if (CharsKt.isWhitespace((char)it)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (!bl) break block5;
            }
            String msg = "password can't be empty or consists solely of whitespace characters";
            throw new ClientException(this.TAG + ' ' + msg, msg);
        }
        SignUpStartRequest.Companion companion = SignUpStartRequest.Companion;
        String string = commandParameters.username;
        char[] cArray = commandParameters.password;
        Map map = commandParameters.userAttributes;
        String string2 = this.config.getChallengeType();
        String string3 = this.config.getClientId();
        String string4 = this.signUpStartEndpoint;
        Map<String, String> map2 = this.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"username");
        return companion.create(string, cArray, map, string3, string2, string4, map2);
    }

    @NotNull
    public final ResetPasswordSubmitRequest createResetPasswordSubmitRequest$common4j(@NotNull ResetPasswordSubmitNewPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createResetPasswordSubmitRequest");
        String string2 = this.config.getClientId();
        String string3 = commandParameters.passwordSubmitToken;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandParameters.passwordSubmitToken");
        Intrinsics.checkNotNullExpressionValue((Object)commandParameters.newPassword, (String)"commandParameters.newPassword");
        return ResetPasswordSubmitRequest.Companion.create(string2, string3, commandParameters.newPassword, this.resetPasswordSubmitEndpoint, this.getRequestHeaders());
    }

    @NotNull
    public final ResetPasswordPollCompletionRequest createResetPasswordPollCompletionRequest$common4j(@NotNull String passwordResetToken) {
        Intrinsics.checkNotNullParameter((Object)passwordResetToken, (String)"passwordResetToken");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createResetPasswordPollCompletionRequest");
        return ResetPasswordPollCompletionRequest.Companion.create(this.config.getClientId(), passwordResetToken, this.resetPasswordPollCompletionEndpoint, this.getRequestHeaders());
    }

    @NotNull
    public final SignUpContinueRequest createSignUpSubmitCodeRequest$common4j(@NotNull SignUpSubmitCodeCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createSignUpSubmitCodeRequest");
        String string2 = commandParameters.code;
        String string3 = this.config.getClientId();
        String string4 = commandParameters.signupToken;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"commandParameters.signupToken");
        return SignUpContinueRequest.Companion.create$default(SignUpContinueRequest.Companion, null, null, string2, string3, string4, "oob", this.signUpContinueEndpoint, this.getRequestHeaders(), 3, null);
    }

    @NotNull
    public final SignUpContinueRequest createSignUpSubmitPasswordRequest$common4j(@NotNull SignUpSubmitPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createSignUpSubmitPasswordRequest");
        char[] cArray = commandParameters.password;
        String string2 = this.config.getClientId();
        String string3 = commandParameters.signupToken;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandParameters.signupToken");
        return SignUpContinueRequest.Companion.create$default(SignUpContinueRequest.Companion, cArray, null, null, string2, string3, "password", this.signUpContinueEndpoint, this.getRequestHeaders(), 6, null);
    }

    @NotNull
    public final SignUpContinueRequest createSignUpSubmitUserAttributesRequest$common4j(@NotNull SignUpSubmitUserAttributesCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createSignUpSubmitUserAttributesRequest");
        Map<String, String> map = commandParameters.userAttributes;
        String string2 = this.config.getClientId();
        String string3 = commandParameters.signupToken;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandParameters.signupToken");
        return SignUpContinueRequest.Companion.create$default(SignUpContinueRequest.Companion, null, map, null, string2, string3, "attributes", this.signUpContinueEndpoint, this.getRequestHeaders(), 5, null);
    }

    @NotNull
    public final SignUpChallengeRequest createSignUpChallengeRequest$common4j(@NotNull String signUpToken) {
        Intrinsics.checkNotNullParameter((Object)signUpToken, (String)"signUpToken");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, this.TAG + ".createSignUpChallengeRequest");
        return SignUpChallengeRequest.Companion.create(signUpToken, this.config.getClientId(), this.config.getChallengeType(), this.signUpChallengeEndpoint, this.getRequestHeaders());
    }

    private final Map<String, String> getRequestHeaders() {
        Map headers = new TreeMap();
        headers.put("client-request-id", DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id"));
        headers.put("x-client-SKU", DiagnosticContext.INSTANCE.getRequestContext().get("x-client-SKU"));
        headers.put("x-client-Ver", Device.getProductVersion());
        Map<String, String> map = Device.getPlatformIdParameters();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getPlatformIdParameters()");
        headers.putAll(map);
        Map<String, String> map2 = EstsTelemetry.getInstance().getTelemetryHeaders();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getInstance().telemetryHeaders");
        headers.putAll(map2);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return headers;
    }
}

