/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.interactors;

import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitNewPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthRequestProvider;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthResponseHandler;
import com.microsoft.identity.common.java.nativeauth.providers.requests.NativeAuthRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordContinueRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordPollCompletionRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordStartRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordSubmitRequest;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordChallengeApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordContinueApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordPollCompletionApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordPollCompletionApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordStartApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordStartApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordSubmitApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordSubmitApiResult;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.StringUtil;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u001aJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020 H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/ResetPasswordInteractor;", "", "httpClient", "Lcom/microsoft/identity/common/java/net/UrlConnectionHttpClient;", "nativeAuthRequestProvider", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;", "nativeAuthResponseHandler", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthResponseHandler;", "(Lcom/microsoft/identity/common/java/net/UrlConnectionHttpClient;Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthResponseHandler;)V", "TAG", "", "performResetPasswordChallenge", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordChallengeApiResult;", "request", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordChallengeRequest;", "passwordResetToken", "performResetPasswordContinue", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordContinueApiResult;", "parameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitCodeCommandParameters;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordContinueRequest;", "performResetPasswordPollCompletion", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordPollCompletionApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordPollCompletionRequest;", "performResetPasswordStart", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordStartApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordStartCommandParameters;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordStartRequest;", "performResetPasswordSubmit", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResult;", "commandParameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitNewPasswordCommandParameters;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordSubmitRequest;", "common4j"})
public final class ResetPasswordInteractor {
    @NotNull
    private final UrlConnectionHttpClient httpClient;
    @NotNull
    private final NativeAuthRequestProvider nativeAuthRequestProvider;
    @NotNull
    private final NativeAuthResponseHandler nativeAuthResponseHandler;
    @NotNull
    private final String TAG;

    public ResetPasswordInteractor(@NotNull UrlConnectionHttpClient httpClient, @NotNull NativeAuthRequestProvider nativeAuthRequestProvider, @NotNull NativeAuthResponseHandler nativeAuthResponseHandler) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)nativeAuthRequestProvider, (String)"nativeAuthRequestProvider");
        Intrinsics.checkNotNullParameter((Object)nativeAuthResponseHandler, (String)"nativeAuthResponseHandler");
        this.httpClient = httpClient;
        this.nativeAuthRequestProvider = nativeAuthRequestProvider;
        this.nativeAuthResponseHandler = nativeAuthResponseHandler;
        String string = ResetPasswordInteractor.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ResetPasswordInteractor::class.java.simpleName");
        this.TAG = string;
    }

    @NotNull
    public final ResetPasswordStartApiResult performResetPasswordStart(@NotNull ResetPasswordStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordStart(parameters: ResetPasswordStartCommandParameters)");
        ResetPasswordStartRequest request = this.nativeAuthRequestProvider.createResetPasswordStartRequest$common4j(parameters);
        return this.performResetPasswordStart(request);
    }

    private final ResetPasswordStartApiResult performResetPasswordStart(ResetPasswordStartRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordStart");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse httpResponse = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"httpResponse");
        ResetPasswordStartApiResponse apiResponse = this.nativeAuthResponseHandler.getResetPasswordStartApiResponseFromHttpResponse(httpResponse);
        return apiResponse.toResult();
    }

    @NotNull
    public final ResetPasswordChallengeApiResult performResetPasswordChallenge(@NotNull String passwordResetToken) {
        Intrinsics.checkNotNullParameter((Object)passwordResetToken, (String)"passwordResetToken");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordChallenge(passwordResetToken: String)");
        ResetPasswordChallengeRequest request = this.nativeAuthRequestProvider.createResetPasswordChallengeRequest$common4j(passwordResetToken);
        return this.performResetPasswordChallenge(request);
    }

    private final ResetPasswordChallengeApiResult performResetPasswordChallenge(ResetPasswordChallengeRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordChallenge");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse httpResponse = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"httpResponse");
        ResetPasswordChallengeApiResponse apiResponse = this.nativeAuthResponseHandler.getResetPasswordChallengeApiResponseFromHttpResponse(httpResponse);
        return apiResponse.toResult();
    }

    @NotNull
    public final ResetPasswordContinueApiResult performResetPasswordContinue(@NotNull ResetPasswordSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordContinue(parameters: ResetPasswordSubmitCodeCommandParameters)");
        ResetPasswordContinueRequest request = this.nativeAuthRequestProvider.createResetPasswordContinueRequest$common4j(parameters);
        return this.performResetPasswordContinue(request);
    }

    private final ResetPasswordContinueApiResult performResetPasswordContinue(ResetPasswordContinueRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordContinue");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse httpResponse = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"httpResponse");
        ResetPasswordContinueApiResponse apiResponse = this.nativeAuthResponseHandler.getResetPasswordContinueApiResponseFromHttpResponse(httpResponse);
        return apiResponse.toResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ResetPasswordSubmitApiResult performResetPasswordSubmit(@NotNull ResetPasswordSubmitNewPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordSubmit(commandParameters: ResetPasswordSubmitNewPasswordCommandParameters)");
        ResetPasswordSubmitRequest request = this.nativeAuthRequestProvider.createResetPasswordSubmitRequest$common4j(commandParameters);
        try {
            ResetPasswordSubmitApiResult resetPasswordSubmitApiResult = this.performResetPasswordSubmit(request);
            return resetPasswordSubmitApiResult;
        }
        finally {
            NativeAuthRequest.NativeAuthRequestParameters nativeAuthRequestParameters = request.getParameters();
            Intrinsics.checkNotNull((Object)nativeAuthRequestParameters, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordSubmitRequest.NativeAuthResetPasswordSubmitRequestBody");
            StringUtil.overwriteWithNull(((ResetPasswordSubmitRequest.NativeAuthResetPasswordSubmitRequestBody)nativeAuthRequestParameters).getNewPassword());
        }
    }

    private final ResetPasswordSubmitApiResult performResetPasswordSubmit(ResetPasswordSubmitRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordSubmit");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse httpResponse = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"httpResponse");
        ResetPasswordSubmitApiResponse apiResponse = this.nativeAuthResponseHandler.getResetPasswordSubmitApiResponseFromHttpResponse(httpResponse);
        return apiResponse.toResult();
    }

    @NotNull
    public final ResetPasswordPollCompletionApiResult performResetPasswordPollCompletion(@NotNull String passwordResetToken) {
        Intrinsics.checkNotNullParameter((Object)passwordResetToken, (String)"passwordResetToken");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordPollCompletion(passwordResetToken: String)");
        ResetPasswordPollCompletionRequest request = this.nativeAuthRequestProvider.createResetPasswordPollCompletionRequest$common4j(passwordResetToken);
        return this.performResetPasswordPollCompletion(request);
    }

    private final ResetPasswordPollCompletionApiResult performResetPasswordPollCompletion(ResetPasswordPollCompletionRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performResetPasswordPollCompletion");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse httpResponse = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"httpResponse");
        ResetPasswordPollCompletionApiResponse apiResponse = this.nativeAuthResponseHandler.getResetPasswordPollCompletionApiResponseFromHttpResponse(httpResponse);
        return apiResponse.toResult();
    }
}

