/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.interactors;

import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInWithSLTCommandParameters;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthRequestProvider;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthResponseHandler;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInInitiateRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInTokenRequest;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInChallengeApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInInitiateApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInInitiateApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInTokenApiResult;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.StringUtil;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0018H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u001cJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u001dH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/SignInInteractor;", "", "httpClient", "Lcom/microsoft/identity/common/java/net/UrlConnectionHttpClient;", "nativeAuthRequestProvider", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;", "nativeAuthResponseHandler", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthResponseHandler;", "(Lcom/microsoft/identity/common/java/net/UrlConnectionHttpClient;Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthResponseHandler;)V", "TAG", "", "performGetToken", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResult;", "request", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInTokenRequest;", "performOOBTokenRequest", "parameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitCodeCommandParameters;", "performPasswordTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitPasswordCommandParameters;", "performSLTTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInWithSLTCommandParameters;", "performSignInChallenge", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInChallengeApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInChallengeRequest;", "credentialToken", "performSignInInitiate", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInStartCommandParameters;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInInitiateRequest;", "common4j"})
public final class SignInInteractor {
    @NotNull
    private final UrlConnectionHttpClient httpClient;
    @NotNull
    private final NativeAuthRequestProvider nativeAuthRequestProvider;
    @NotNull
    private final NativeAuthResponseHandler nativeAuthResponseHandler;
    @NotNull
    private final String TAG;

    public SignInInteractor(@NotNull UrlConnectionHttpClient httpClient, @NotNull NativeAuthRequestProvider nativeAuthRequestProvider, @NotNull NativeAuthResponseHandler nativeAuthResponseHandler) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)nativeAuthRequestProvider, (String)"nativeAuthRequestProvider");
        Intrinsics.checkNotNullParameter((Object)nativeAuthResponseHandler, (String)"nativeAuthResponseHandler");
        this.httpClient = httpClient;
        this.nativeAuthRequestProvider = nativeAuthRequestProvider;
        this.nativeAuthResponseHandler = nativeAuthResponseHandler;
        String string = SignInInteractor.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SignInInteractor::class.java.simpleName");
        this.TAG = string;
    }

    @NotNull
    public final SignInInitiateApiResult performSignInInitiate(@NotNull SignInStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSignInInitiate(parameters: SignInStartCommandParameters)");
        SignInInitiateRequest request = this.nativeAuthRequestProvider.createSignInInitiateRequest$common4j(parameters);
        return this.performSignInInitiate(request);
    }

    private final SignInInitiateApiResult performSignInInitiate(SignInInitiateRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSignInInitiate");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse response = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        SignInInitiateApiResponse rawApiResponse = this.nativeAuthResponseHandler.getSignInInitiateResultFromHttpResponse(response);
        return rawApiResponse.toResult();
    }

    @NotNull
    public final SignInChallengeApiResult performSignInChallenge(@NotNull String credentialToken) {
        Intrinsics.checkNotNullParameter((Object)credentialToken, (String)"credentialToken");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSignInChallenge(credentialToken: String)");
        SignInChallengeRequest request = this.nativeAuthRequestProvider.createSignInChallengeRequest$common4j(credentialToken);
        return this.performSignInChallenge(request);
    }

    private final SignInChallengeApiResult performSignInChallenge(SignInChallengeRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSignInChallenge");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse response = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        SignInChallengeApiResponse result = this.nativeAuthResponseHandler.getSignInChallengeResultFromHttpResponse(response);
        return result.toResult();
    }

    @NotNull
    public final SignInTokenApiResult performOOBTokenRequest(@NotNull SignInSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performOOBTokenRequest");
        SignInTokenRequest request = this.nativeAuthRequestProvider.createOOBTokenRequest$common4j(parameters);
        return this.performGetToken(request);
    }

    @NotNull
    public final SignInTokenApiResult performSLTTokenRequest(@NotNull SignInWithSLTCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSLTTokenRequest");
        SignInTokenRequest request = this.nativeAuthRequestProvider.createSLTTokenRequest$common4j(parameters);
        return this.performGetToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SignInTokenApiResult performPasswordTokenRequest(@NotNull SignInSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performPasswordTokenRequest");
        SignInTokenRequest request = this.nativeAuthRequestProvider.createPasswordTokenRequest$common4j(parameters);
        try {
            SignInTokenApiResult signInTokenApiResult = this.performGetToken(request);
            return signInTokenApiResult;
        }
        finally {
            StringUtil.overwriteWithNull(request.getParameters().getPassword());
        }
    }

    private final SignInTokenApiResult performGetToken(SignInTokenRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performGetToken");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse response = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        return this.nativeAuthResponseHandler.getSignInTokenApiResultFromHttpResponse(response);
    }
}

