/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.interactors;

import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartUsingPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitUserAttributesCommandParameters;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthRequestProvider;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthResponseHandler;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signup.SignUpChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signup.SignUpContinueRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signup.SignUpStartRequest;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpChallengeApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpContinueApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpStartApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpStartApiResult;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.UrlConnectionHttpClient;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.StringUtil;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/SignUpInteractor;", "", "httpClient", "Lcom/microsoft/identity/common/java/net/UrlConnectionHttpClient;", "nativeAuthRequestProvider", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;", "nativeAuthResponseHandler", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthResponseHandler;", "(Lcom/microsoft/identity/common/java/net/UrlConnectionHttpClient;Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthResponseHandler;)V", "TAG", "", "performSignUpChallenge", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResult;", "request", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signup/SignUpChallengeRequest;", "signUpToken", "performSignUpContinue", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpContinueApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signup/SignUpContinueRequest;", "performSignUpStart", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResult;", "commandParameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpStartCommandParameters;", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signup/SignUpStartRequest;", "performSignUpStartUsingPassword", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpStartUsingPasswordCommandParameters;", "performSignUpSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitCodeCommandParameters;", "performSignUpSubmitPassword", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitPasswordCommandParameters;", "performSignUpSubmitUserAttributes", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitUserAttributesCommandParameters;", "common4j"})
public final class SignUpInteractor {
    @NotNull
    private final UrlConnectionHttpClient httpClient;
    @NotNull
    private final NativeAuthRequestProvider nativeAuthRequestProvider;
    @NotNull
    private final NativeAuthResponseHandler nativeAuthResponseHandler;
    @NotNull
    private final String TAG;

    public SignUpInteractor(@NotNull UrlConnectionHttpClient httpClient, @NotNull NativeAuthRequestProvider nativeAuthRequestProvider, @NotNull NativeAuthResponseHandler nativeAuthResponseHandler) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)nativeAuthRequestProvider, (String)"nativeAuthRequestProvider");
        Intrinsics.checkNotNullParameter((Object)nativeAuthResponseHandler, (String)"nativeAuthResponseHandler");
        this.httpClient = httpClient;
        this.nativeAuthRequestProvider = nativeAuthRequestProvider;
        this.nativeAuthResponseHandler = nativeAuthResponseHandler;
        String string = SignUpInteractor.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SignUpInteractor::class.java.simpleName");
        this.TAG = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SignUpStartApiResult performSignUpStart(@NotNull SignUpStartCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSignUpStart");
        SignUpStartRequest request = this.nativeAuthRequestProvider.createSignUpStartRequest$common4j(commandParameters);
        try {
            SignUpStartApiResult signUpStartApiResult = this.performSignUpStart(request);
            return signUpStartApiResult;
        }
        finally {
            StringUtil.overwriteWithNull(request.getParameters().getPassword());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SignUpStartApiResult performSignUpStartUsingPassword(@NotNull SignUpStartUsingPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSignUpStartUsingPassword");
        SignUpStartRequest request = this.nativeAuthRequestProvider.createSignUpUsingPasswordStartRequest$common4j(commandParameters);
        try {
            SignUpStartApiResult signUpStartApiResult = this.performSignUpStart(request);
            return signUpStartApiResult;
        }
        finally {
            StringUtil.overwriteWithNull(request.getParameters().getPassword());
        }
    }

    private final SignUpStartApiResult performSignUpStart(SignUpStartRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSignUpStart");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse response = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        SignUpStartApiResponse rawApiResponse = this.nativeAuthResponseHandler.getSignUpStartResultFromHttpResponse(response);
        return rawApiResponse.toResult();
    }

    @NotNull
    public final SignUpChallengeApiResult performSignUpChallenge(@NotNull String signUpToken) {
        Intrinsics.checkNotNullParameter((Object)signUpToken, (String)"signUpToken");
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSignUpChallenge");
        SignUpChallengeRequest request = this.nativeAuthRequestProvider.createSignUpChallengeRequest$common4j(signUpToken);
        return this.performSignUpChallenge(request);
    }

    private final SignUpChallengeApiResult performSignUpChallenge(SignUpChallengeRequest request) {
        LogSession.Companion.logMethodCall(this.TAG, this.TAG + ".performSignUpChallenge");
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse response = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        SignUpChallengeApiResponse rawApiResponse = this.nativeAuthResponseHandler.getSignUpChallengeResultFromHttpResponse(response);
        return rawApiResponse.toResult();
    }

    @NotNull
    public final SignUpContinueApiResult performSignUpSubmitCode(@NotNull SignUpSubmitCodeCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        SignUpContinueRequest request = this.nativeAuthRequestProvider.createSignUpSubmitCodeRequest$common4j(commandParameters);
        return this.performSignUpContinue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SignUpContinueApiResult performSignUpSubmitPassword(@NotNull SignUpSubmitPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        SignUpContinueRequest request = this.nativeAuthRequestProvider.createSignUpSubmitPasswordRequest$common4j(commandParameters);
        try {
            SignUpContinueApiResult signUpContinueApiResult = this.performSignUpContinue(request);
            return signUpContinueApiResult;
        }
        finally {
            StringUtil.overwriteWithNull(request.getParameters().getPassword());
        }
    }

    @NotNull
    public final SignUpContinueApiResult performSignUpSubmitUserAttributes(@NotNull SignUpSubmitUserAttributesCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        SignUpContinueRequest request = this.nativeAuthRequestProvider.createSignUpSubmitUserAttributesRequest$common4j(commandParameters);
        return this.performSignUpContinue(request);
    }

    private final SignUpContinueApiResult performSignUpContinue(SignUpContinueRequest request) {
        String string = ObjectMapper.serializeObjectToFormUrlEncoded(request.getParameters());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToFormUrl\u2026coded(request.parameters)");
        String encodedRequest = string;
        Map<String, String> headers = request.getHeaders();
        URL requestUrl = request.getRequestUrl();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = encodedRequest.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        HttpResponse response = this.httpClient.post(requestUrl, headers, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        SignUpContinueApiResponse rawApiResponse = this.nativeAuthResponseHandler.getSignUpContinueResultFromHttpResponse(response);
        return rawApiResponse.toResult();
    }
}

