/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.interactors.InnerError;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordSubmitApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u001a\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f\u0018\u00010\u000b\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u001f\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020#R*\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0018\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "passwordResetToken", "", "pollInterval", "error", "errorDescription", "errorUri", "details", "", "", "innerErrors", "Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/InnerError;", "(ILjava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getDetails", "()Ljava/util/List;", "getError", "()Ljava/lang/String;", "getErrorDescription", "getErrorUri", "getInnerErrors", "getPasswordResetToken", "getPollInterval", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getStatusCode", "()I", "setStatusCode", "(I)V", "clampPollInterval", "pollIntervalInSeconds", "(Ljava/lang/Integer;)I", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResult;", "Companion", "common4j"})
public final class ResetPasswordSubmitApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @Expose
    @SerializedName(value="password_reset_token")
    @Nullable
    private final String passwordResetToken;
    @Expose
    @SerializedName(value="poll_interval")
    @Nullable
    private final Integer pollInterval;
    @Expose
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @Expose
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @Expose
    @SerializedName(value="error_uri")
    @Nullable
    private final String errorUri;
    @Expose
    @SerializedName(value="details")
    @Nullable
    private final List<Map<String, String>> details;
    @Expose
    @SerializedName(value="inner_errors")
    @Nullable
    private final List<InnerError> innerErrors;
    private static final String TAG = ResetPasswordSubmitApiResponse.class.getSimpleName();
    private static final int MINIMUM_POLL_COMPLETION_INTERVAL_IN_SECONDS = 1;
    private static final int MAXIMUM_POLL_COMPLETION_INTERVAL_IN_SECONDS = 15;
    private static final int DEFAULT_POLL_COMPLETION_INTERVAL_IN_SECONDS = 2;

    public ResetPasswordSubmitApiResponse(int statusCode, @Nullable String passwordResetToken, @Nullable Integer pollInterval, @Nullable String error, @Nullable String errorDescription, @Nullable String errorUri, @Nullable List<? extends Map<String, String>> details, @Nullable List<InnerError> innerErrors) {
        super(statusCode);
        this.statusCode = statusCode;
        this.passwordResetToken = passwordResetToken;
        this.pollInterval = pollInterval;
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
        this.details = details;
        this.innerErrors = innerErrors;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getPasswordResetToken() {
        return this.passwordResetToken;
    }

    @Nullable
    public final Integer getPollInterval() {
        return this.pollInterval;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getErrorUri() {
        return this.errorUri;
    }

    @Nullable
    public final List<Map<String, String>> getDetails() {
        return this.details;
    }

    @Nullable
    public final List<InnerError> getInnerErrors() {
        return this.innerErrors;
    }

    @NotNull
    public final ResetPasswordSubmitApiResult toResult() {
        ResetPasswordSubmitApiResult resetPasswordSubmitApiResult;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, TAG + ".toResult");
        switch (this.getStatusCode()) {
            case 400: {
                ResetPasswordSubmitApiResult resetPasswordSubmitApiResult2;
                if (ApiErrorResponseUtilKt.isPasswordBanned(this.error) || ApiErrorResponseUtilKt.isPasswordTooShort(this.error) || ApiErrorResponseUtilKt.isPasswordTooLong(this.error) || ApiErrorResponseUtilKt.isPasswordRecentlyUsed(this.error) || ApiErrorResponseUtilKt.isPasswordTooWeak(this.error)) {
                    String string2;
                    String string3 = this.error;
                    if (string3 == null) {
                        string3 = "";
                    }
                    if ((string2 = this.errorDescription) == null) {
                        string2 = "";
                    }
                    resetPasswordSubmitApiResult2 = new ResetPasswordSubmitApiResult.PasswordInvalid(string3, string2);
                } else if (ApiErrorResponseUtilKt.isExpiredToken(this.error)) {
                    String string4;
                    String string5 = this.error;
                    if (string5 == null) {
                        string5 = "";
                    }
                    if ((string4 = this.errorDescription) == null) {
                        string4 = "";
                    }
                    resetPasswordSubmitApiResult2 = new ResetPasswordSubmitApiResult.ExpiredToken(string5, string4);
                } else {
                    String string6;
                    String string7 = this.error;
                    if (string7 == null) {
                        string7 = "";
                    }
                    if ((string6 = this.errorDescription) == null) {
                        string6 = "";
                    }
                    resetPasswordSubmitApiResult2 = new ResetPasswordSubmitApiResult.UnknownError(string7, string6, this.details);
                }
                return resetPasswordSubmitApiResult2;
            }
            case 200: {
                String string8 = this.passwordResetToken;
                if (string8 == null) {
                    return new ResetPasswordSubmitApiResult.UnknownError("invalid_state", "ResetPassword /submit successful, but did not return a flow token", this.details);
                }
                resetPasswordSubmitApiResult = new ResetPasswordSubmitApiResult.SubmitSuccess(string8, this.clampPollInterval(this.pollInterval));
                break;
            }
            default: {
                String string9;
                String string10 = this.error;
                if (string10 == null) {
                    string10 = "";
                }
                if ((string9 = this.errorDescription) == null) {
                    string9 = "";
                }
                resetPasswordSubmitApiResult = new ResetPasswordSubmitApiResult.UnknownError(string10, string9, this.details);
            }
        }
        return resetPasswordSubmitApiResult;
    }

    public final int clampPollInterval(@Nullable Integer pollIntervalInSeconds) {
        if (pollIntervalInSeconds == null || pollIntervalInSeconds < 1 || pollIntervalInSeconds > 15) {
            return 2;
        }
        return pollIntervalInSeconds;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResponse$Companion;", "", "()V", "DEFAULT_POLL_COMPLETION_INTERVAL_IN_SECONDS", "", "MAXIMUM_POLL_COMPLETION_INTERVAL_IN_SECONDS", "MINIMUM_POLL_COMPLETION_INTERVAL_IN_SECONDS", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

