/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.signin;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.interactors.InnerError;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInInitiateApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 12\u00020\u0001:\u00011B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u001a\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f\u0018\u00010\u000b\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001d\u0010%\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f\u0018\u00010\u000bH\u00c6\u0003J\u0011\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH\u00c6\u0003J\u0011\u0010'\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000bH\u00c6\u0003J\u0091\u0001\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\u001c\b\u0002\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f\u0018\u00010\u000b2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010.\u001a\u00020/J\t\u00100\u001a\u00020\u0005H\u00d6\u0001R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R*\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u001e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0018\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u001e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00062"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "credentialToken", "", "challengeType", "error", "errorDescription", "errorUri", "details", "", "", "errorCodes", "innerErrors", "Lcom/microsoft/identity/common/java/nativeauth/providers/interactors/InnerError;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getChallengeType", "()Ljava/lang/String;", "getCredentialToken", "getDetails", "()Ljava/util/List;", "getError", "getErrorCodes", "getErrorDescription", "getErrorUri", "getInnerErrors", "getStatusCode", "()I", "setStatusCode", "(I)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "hashCode", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResult;", "toString", "Companion", "common4j"})
public final class SignInInitiateApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @Expose
    @SerializedName(value="credential_token")
    @Nullable
    private final String credentialToken;
    @Expose
    @SerializedName(value="challenge_type")
    @Nullable
    private final String challengeType;
    @Expose
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @Expose
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @Expose
    @SerializedName(value="error_uri")
    @Nullable
    private final String errorUri;
    @Expose
    @SerializedName(value="details")
    @Nullable
    private final List<Map<String, String>> details;
    @Expose
    @SerializedName(value="error_codes")
    @Nullable
    private final List<Integer> errorCodes;
    @Expose
    @SerializedName(value="inner_errors")
    @Nullable
    private final List<InnerError> innerErrors;
    private static final String TAG = SignInInitiateApiResponse.class.getSimpleName();

    public SignInInitiateApiResponse(int statusCode, @Nullable String credentialToken, @Nullable String challengeType, @Nullable String error, @Nullable String errorDescription, @Nullable String errorUri, @Nullable List<? extends Map<String, String>> details, @Nullable List<Integer> errorCodes, @Nullable List<InnerError> innerErrors) {
        super(statusCode);
        this.statusCode = statusCode;
        this.credentialToken = credentialToken;
        this.challengeType = challengeType;
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
        this.details = details;
        this.errorCodes = errorCodes;
        this.innerErrors = innerErrors;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getCredentialToken() {
        return this.credentialToken;
    }

    @Nullable
    public final String getChallengeType() {
        return this.challengeType;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getErrorUri() {
        return this.errorUri;
    }

    @Nullable
    public final List<Map<String, String>> getDetails() {
        return this.details;
    }

    @Nullable
    public final List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    @Nullable
    public final List<InnerError> getInnerErrors() {
        return this.innerErrors;
    }

    @NotNull
    public final SignInInitiateApiResult toResult() {
        SignInInitiateApiResult signInInitiateApiResult;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, TAG + ".toResult");
        switch (this.getStatusCode()) {
            case 400: {
                String string2;
                String string3;
                if (ApiErrorResponseUtilKt.isInvalidGrant(this.error)) {
                    SignInInitiateApiResult signInInitiateApiResult2;
                    Object object = this.errorCodes;
                    if (object == null || object.isEmpty()) {
                        String string4;
                        Object object2 = this.error;
                        if (object2 == null) {
                            object2 = object = "";
                        }
                        if ((string4 = this.errorDescription) == null) {
                            string4 = "";
                        }
                        String string5 = string4;
                        List<Map<String, String>> list = this.details;
                        List list2 = this.errorCodes;
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                        List list3 = list2;
                        signInInitiateApiResult2 = new SignInInitiateApiResult.UnknownError((String)object, string5, list3, list);
                    } else if (ApiErrorResponseUtilKt.isUserNotFound(this.errorCodes.get(0))) {
                        String string6;
                        String string7 = this.error;
                        if (string7 == null) {
                            string7 = "";
                        }
                        if ((string6 = this.errorDescription) == null) {
                            string6 = "";
                        }
                        signInInitiateApiResult2 = new SignInInitiateApiResult.UserNotFound(string7, string6, this.errorCodes);
                    } else {
                        String string8;
                        Object object3 = this.error;
                        if (object3 == null) {
                            object3 = object = "";
                        }
                        if ((string8 = this.errorDescription) == null) {
                            string8 = "";
                        }
                        String string9 = string8;
                        List<Map<String, String>> list = this.details;
                        List<Integer> list4 = this.errorCodes;
                        signInInitiateApiResult2 = new SignInInitiateApiResult.UnknownError((String)object, string9, list4, list);
                    }
                    return signInInitiateApiResult2;
                }
                String string10 = this.error;
                if (string10 == null) {
                    string10 = string3 = "";
                }
                if ((string2 = this.errorDescription) == null) {
                    string2 = "";
                }
                String string11 = string2;
                List<Map<String, String>> list = this.details;
                List list5 = this.errorCodes;
                if (list5 == null) {
                    list5 = CollectionsKt.emptyList();
                }
                List list6 = list5;
                signInInitiateApiResult = new SignInInitiateApiResult.UnknownError(string3, string11, list6, list);
                break;
            }
            case 200: {
                if (ApiErrorResponseUtilKt.isRedirect(this.challengeType)) {
                    signInInitiateApiResult = SignInInitiateApiResult.Redirect.INSTANCE;
                    break;
                }
                String string12 = this.credentialToken;
                if (string12 == null) {
                    String string13 = ApiErrorResult.Companion.getINVALID_STATE();
                    List<Map<String, String>> list = this.details;
                    List list7 = this.errorCodes;
                    if (list7 == null) {
                        list7 = CollectionsKt.emptyList();
                    }
                    List list8 = list7;
                    return new SignInInitiateApiResult.UnknownError(string13, "SignIn /initiate did not return a flow token", list8, list);
                }
                signInInitiateApiResult = new SignInInitiateApiResult.Success(string12);
                break;
            }
            default: {
                String string14;
                String string15;
                String string16 = this.error;
                if (string16 == null) {
                    string16 = string15 = "";
                }
                if ((string14 = this.errorDescription) == null) {
                    string14 = "";
                }
                String string17 = string14;
                List<Map<String, String>> list = this.details;
                List list9 = this.errorCodes;
                if (list9 == null) {
                    list9 = CollectionsKt.emptyList();
                }
                List list10 = list9;
                signInInitiateApiResult = new SignInInitiateApiResult.UnknownError(string15, string17, list10, list);
            }
        }
        return signInInitiateApiResult;
    }

    public final int component1() {
        return this.getStatusCode();
    }

    @Nullable
    public final String component2() {
        return this.credentialToken;
    }

    @Nullable
    public final String component3() {
        return this.challengeType;
    }

    @Nullable
    public final String component4() {
        return this.error;
    }

    @Nullable
    public final String component5() {
        return this.errorDescription;
    }

    @Nullable
    public final String component6() {
        return this.errorUri;
    }

    @Nullable
    public final List<Map<String, String>> component7() {
        return this.details;
    }

    @Nullable
    public final List<Integer> component8() {
        return this.errorCodes;
    }

    @Nullable
    public final List<InnerError> component9() {
        return this.innerErrors;
    }

    @NotNull
    public final SignInInitiateApiResponse copy(int statusCode, @Nullable String credentialToken, @Nullable String challengeType, @Nullable String error, @Nullable String errorDescription, @Nullable String errorUri, @Nullable List<? extends Map<String, String>> details, @Nullable List<Integer> errorCodes, @Nullable List<InnerError> innerErrors) {
        return new SignInInitiateApiResponse(statusCode, credentialToken, challengeType, error, errorDescription, errorUri, details, errorCodes, innerErrors);
    }

    public static /* synthetic */ SignInInitiateApiResponse copy$default(SignInInitiateApiResponse signInInitiateApiResponse, int n, String string, String string2, String string3, String string4, String string5, List list, List list2, List list3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = signInInitiateApiResponse.getStatusCode();
        }
        if ((n2 & 2) != 0) {
            string = signInInitiateApiResponse.credentialToken;
        }
        if ((n2 & 4) != 0) {
            string2 = signInInitiateApiResponse.challengeType;
        }
        if ((n2 & 8) != 0) {
            string3 = signInInitiateApiResponse.error;
        }
        if ((n2 & 0x10) != 0) {
            string4 = signInInitiateApiResponse.errorDescription;
        }
        if ((n2 & 0x20) != 0) {
            string5 = signInInitiateApiResponse.errorUri;
        }
        if ((n2 & 0x40) != 0) {
            list = signInInitiateApiResponse.details;
        }
        if ((n2 & 0x80) != 0) {
            list2 = signInInitiateApiResponse.errorCodes;
        }
        if ((n2 & 0x100) != 0) {
            list3 = signInInitiateApiResponse.innerErrors;
        }
        return signInInitiateApiResponse.copy(n, string, string2, string3, string4, string5, list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "SignInInitiateApiResponse(statusCode=" + this.getStatusCode() + ", credentialToken=" + this.credentialToken + ", challengeType=" + this.challengeType + ", error=" + this.error + ", errorDescription=" + this.errorDescription + ", errorUri=" + this.errorUri + ", details=" + this.details + ", errorCodes=" + this.errorCodes + ", innerErrors=" + this.innerErrors + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.getStatusCode());
        result = result * 31 + (this.credentialToken == null ? 0 : this.credentialToken.hashCode());
        result = result * 31 + (this.challengeType == null ? 0 : this.challengeType.hashCode());
        result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
        result = result * 31 + (this.errorDescription == null ? 0 : this.errorDescription.hashCode());
        result = result * 31 + (this.errorUri == null ? 0 : this.errorUri.hashCode());
        result = result * 31 + (this.details == null ? 0 : ((Object)this.details).hashCode());
        result = result * 31 + (this.errorCodes == null ? 0 : ((Object)this.errorCodes).hashCode());
        result = result * 31 + (this.innerErrors == null ? 0 : ((Object)this.innerErrors).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SignInInitiateApiResponse)) {
            return false;
        }
        SignInInitiateApiResponse signInInitiateApiResponse = (SignInInitiateApiResponse)other;
        if (this.getStatusCode() != signInInitiateApiResponse.getStatusCode()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.credentialToken, (Object)signInInitiateApiResponse.credentialToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.challengeType, (Object)signInInitiateApiResponse.challengeType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.error, (Object)signInInitiateApiResponse.error)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.errorDescription, (Object)signInInitiateApiResponse.errorDescription)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.errorUri, (Object)signInInitiateApiResponse.errorUri)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.details, signInInitiateApiResponse.details)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.errorCodes, signInInitiateApiResponse.errorCodes)) {
            return false;
        }
        return Intrinsics.areEqual(this.innerErrors, signInInitiateApiResponse.innerErrors);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResponse$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

