/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.signup;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\"\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 92\u00020\u0001:\u00019B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\u001a\u0010\r\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f\u0018\u00010\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010%\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f\u0018\u00010\u000eH\u00c6\u0003J\u0010\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0018J\u000b\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0018J\u000b\u0010*\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u00a2\u0001\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\u001c\b\u0002\u0010\r\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u00100J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u00020\u0003H\u00d6\u0001J\u0006\u00106\u001a\u000207J\t\u00108\u001a\u00020\u0005H\u00d6\u0001R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R*\u0010\r\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f\u0018\u00010\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0018\u0010\f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u001e\u0010\u0018R\u0018\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006:"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "challengeType", "", "bindingMethod", "interval", "challengeTargetLabel", "challengeChannel", "signupToken", "error", "errorDescription", "details", "", "", "codeLength", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Integer;)V", "getBindingMethod", "()Ljava/lang/String;", "getChallengeChannel", "getChallengeTargetLabel", "getChallengeType", "getCodeLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getDetails", "()Ljava/util/List;", "getError", "getErrorDescription", "getInterval", "getSignupToken", "getStatusCode", "()I", "setStatusCode", "(I)V", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Integer;)Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResponse;", "equals", "", "other", "", "hashCode", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResult;", "toString", "Companion", "common4j"})
public final class SignUpChallengeApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @Expose
    @SerializedName(value="challenge_type")
    @Nullable
    private final String challengeType;
    @Expose
    @SerializedName(value="binding_method")
    @Nullable
    private final String bindingMethod;
    @Expose
    @SerializedName(value="interval")
    @Nullable
    private final Integer interval;
    @SerializedName(value="challenge_target_label")
    @Nullable
    private final String challengeTargetLabel;
    @Expose
    @SerializedName(value="challenge_channel")
    @Nullable
    private final String challengeChannel;
    @SerializedName(value="signup_token")
    @Nullable
    private final String signupToken;
    @Expose
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @Expose
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @SerializedName(value="details")
    @Nullable
    private final List<Map<String, String>> details;
    @Expose
    @SerializedName(value="code_length")
    @Nullable
    private final Integer codeLength;
    private static final String TAG = SignUpChallengeApiResponse.class.getSimpleName();

    public SignUpChallengeApiResponse(int statusCode, @Nullable String challengeType, @Nullable String bindingMethod, @Nullable Integer interval, @Nullable String challengeTargetLabel, @Nullable String challengeChannel, @Nullable String signupToken, @Nullable String error, @Nullable String errorDescription, @Nullable List<? extends Map<String, String>> details, @Nullable Integer codeLength) {
        super(statusCode);
        this.statusCode = statusCode;
        this.challengeType = challengeType;
        this.bindingMethod = bindingMethod;
        this.interval = interval;
        this.challengeTargetLabel = challengeTargetLabel;
        this.challengeChannel = challengeChannel;
        this.signupToken = signupToken;
        this.error = error;
        this.errorDescription = errorDescription;
        this.details = details;
        this.codeLength = codeLength;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getChallengeType() {
        return this.challengeType;
    }

    @Nullable
    public final String getBindingMethod() {
        return this.bindingMethod;
    }

    @Nullable
    public final Integer getInterval() {
        return this.interval;
    }

    @Nullable
    public final String getChallengeTargetLabel() {
        return this.challengeTargetLabel;
    }

    @Nullable
    public final String getChallengeChannel() {
        return this.challengeChannel;
    }

    @Nullable
    public final String getSignupToken() {
        return this.signupToken;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final List<Map<String, String>> getDetails() {
        return this.details;
    }

    @Nullable
    public final Integer getCodeLength() {
        return this.codeLength;
    }

    @NotNull
    public final SignUpChallengeApiResult toResult() {
        String string;
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, TAG + ".toResult");
        switch (this.getStatusCode()) {
            case 400: {
                SignUpChallengeApiResult signUpChallengeApiResult;
                if (ApiErrorResponseUtilKt.isUnsupportedChallengeType(this.error)) {
                    String string3;
                    String string4 = this.error;
                    if (string4 == null) {
                        string4 = "";
                    }
                    if ((string3 = this.errorDescription) == null) {
                        string3 = "";
                    }
                    signUpChallengeApiResult = new SignUpChallengeApiResult.UnsupportedChallengeType(string4, string3, this.details);
                } else if (ApiErrorResponseUtilKt.isExpiredToken(this.error)) {
                    String string5;
                    String string6 = this.error;
                    if (string6 == null) {
                        string6 = "";
                    }
                    if ((string5 = this.errorDescription) == null) {
                        string5 = "";
                    }
                    signUpChallengeApiResult = new SignUpChallengeApiResult.ExpiredToken(string6, string5, this.details);
                } else {
                    String string7;
                    String string8 = this.error;
                    if (string8 == null) {
                        string8 = "";
                    }
                    if ((string7 = this.errorDescription) == null) {
                        string7 = "";
                    }
                    signUpChallengeApiResult = new SignUpChallengeApiResult.UnknownError(string8, string7, this.details);
                }
                return signUpChallengeApiResult;
            }
            case 200: {
                SignUpChallengeApiResult signUpChallengeApiResult;
                if (ApiErrorResponseUtilKt.isRedirect(this.challengeType)) {
                    signUpChallengeApiResult = SignUpChallengeApiResult.Redirect.INSTANCE;
                } else {
                    if (ApiErrorResponseUtilKt.isOOB(this.challengeType)) {
                        SignUpChallengeApiResult signUpChallengeApiResult2;
                        CharSequence charSequence = this.challengeTargetLabel;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                            signUpChallengeApiResult2 = new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a challenge_target_label with oob challenge type", this.details);
                        } else {
                            charSequence = this.challengeChannel;
                            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                                signUpChallengeApiResult2 = new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a challenge_channel with oob challenge type", this.details);
                            } else if (this.codeLength == null) {
                                signUpChallengeApiResult2 = new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a code_length with oob challenge type", this.details);
                            } else {
                                String string9 = this.signupToken;
                                if (string9 == null) {
                                    return new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a flow token with oob challenge type", this.details);
                                }
                                signUpChallengeApiResult2 = new SignUpChallengeApiResult.OOBRequired(string9, this.challengeTargetLabel, this.challengeChannel, this.codeLength);
                            }
                        }
                        return signUpChallengeApiResult2;
                    }
                    if (ApiErrorResponseUtilKt.isPassword(this.challengeType)) {
                        String string10 = this.signupToken;
                        if (string10 == null) {
                            return new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a flow token with password challenge type", this.details);
                        }
                        signUpChallengeApiResult = new SignUpChallengeApiResult.PasswordRequired(string10);
                    } else {
                        String string11;
                        String string12 = this.error;
                        if (string12 == null) {
                            string12 = "";
                        }
                        if ((string11 = this.errorDescription) == null) {
                            string11 = "";
                        }
                        signUpChallengeApiResult = new SignUpChallengeApiResult.UnknownError(string12, string11, this.details);
                    }
                }
                return signUpChallengeApiResult;
            }
        }
        String string13 = this.error;
        if (string13 == null) {
            string13 = "";
        }
        if ((string = this.errorDescription) == null) {
            string = "";
        }
        return new SignUpChallengeApiResult.UnknownError(string13, string, this.details);
    }

    public final int component1() {
        return this.getStatusCode();
    }

    @Nullable
    public final String component2() {
        return this.challengeType;
    }

    @Nullable
    public final String component3() {
        return this.bindingMethod;
    }

    @Nullable
    public final Integer component4() {
        return this.interval;
    }

    @Nullable
    public final String component5() {
        return this.challengeTargetLabel;
    }

    @Nullable
    public final String component6() {
        return this.challengeChannel;
    }

    @Nullable
    public final String component7() {
        return this.signupToken;
    }

    @Nullable
    public final String component8() {
        return this.error;
    }

    @Nullable
    public final String component9() {
        return this.errorDescription;
    }

    @Nullable
    public final List<Map<String, String>> component10() {
        return this.details;
    }

    @Nullable
    public final Integer component11() {
        return this.codeLength;
    }

    @NotNull
    public final SignUpChallengeApiResponse copy(int statusCode, @Nullable String challengeType, @Nullable String bindingMethod, @Nullable Integer interval, @Nullable String challengeTargetLabel, @Nullable String challengeChannel, @Nullable String signupToken, @Nullable String error, @Nullable String errorDescription, @Nullable List<? extends Map<String, String>> details, @Nullable Integer codeLength) {
        return new SignUpChallengeApiResponse(statusCode, challengeType, bindingMethod, interval, challengeTargetLabel, challengeChannel, signupToken, error, errorDescription, details, codeLength);
    }

    public static /* synthetic */ SignUpChallengeApiResponse copy$default(SignUpChallengeApiResponse signUpChallengeApiResponse, int n, String string, String string2, Integer n2, String string3, String string4, String string5, String string6, String string7, List list, Integer n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = signUpChallengeApiResponse.getStatusCode();
        }
        if ((n4 & 2) != 0) {
            string = signUpChallengeApiResponse.challengeType;
        }
        if ((n4 & 4) != 0) {
            string2 = signUpChallengeApiResponse.bindingMethod;
        }
        if ((n4 & 8) != 0) {
            n2 = signUpChallengeApiResponse.interval;
        }
        if ((n4 & 0x10) != 0) {
            string3 = signUpChallengeApiResponse.challengeTargetLabel;
        }
        if ((n4 & 0x20) != 0) {
            string4 = signUpChallengeApiResponse.challengeChannel;
        }
        if ((n4 & 0x40) != 0) {
            string5 = signUpChallengeApiResponse.signupToken;
        }
        if ((n4 & 0x80) != 0) {
            string6 = signUpChallengeApiResponse.error;
        }
        if ((n4 & 0x100) != 0) {
            string7 = signUpChallengeApiResponse.errorDescription;
        }
        if ((n4 & 0x200) != 0) {
            list = signUpChallengeApiResponse.details;
        }
        if ((n4 & 0x400) != 0) {
            n3 = signUpChallengeApiResponse.codeLength;
        }
        return signUpChallengeApiResponse.copy(n, string, string2, n2, string3, string4, string5, string6, string7, list, n3);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SignUpChallengeApiResponse(statusCode=").append(this.getStatusCode()).append(", challengeType=").append(this.challengeType).append(", bindingMethod=").append(this.bindingMethod).append(", interval=").append(this.interval).append(", challengeTargetLabel=").append(this.challengeTargetLabel).append(", challengeChannel=").append(this.challengeChannel).append(", signupToken=").append(this.signupToken).append(", error=").append(this.error).append(", errorDescription=").append(this.errorDescription).append(", details=").append(this.details).append(", codeLength=").append(this.codeLength).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int result = Integer.hashCode(this.getStatusCode());
        result = result * 31 + (this.challengeType == null ? 0 : this.challengeType.hashCode());
        result = result * 31 + (this.bindingMethod == null ? 0 : this.bindingMethod.hashCode());
        result = result * 31 + (this.interval == null ? 0 : ((Object)this.interval).hashCode());
        result = result * 31 + (this.challengeTargetLabel == null ? 0 : this.challengeTargetLabel.hashCode());
        result = result * 31 + (this.challengeChannel == null ? 0 : this.challengeChannel.hashCode());
        result = result * 31 + (this.signupToken == null ? 0 : this.signupToken.hashCode());
        result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
        result = result * 31 + (this.errorDescription == null ? 0 : this.errorDescription.hashCode());
        result = result * 31 + (this.details == null ? 0 : ((Object)this.details).hashCode());
        result = result * 31 + (this.codeLength == null ? 0 : ((Object)this.codeLength).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SignUpChallengeApiResponse)) {
            return false;
        }
        SignUpChallengeApiResponse signUpChallengeApiResponse = (SignUpChallengeApiResponse)other;
        if (this.getStatusCode() != signUpChallengeApiResponse.getStatusCode()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.challengeType, (Object)signUpChallengeApiResponse.challengeType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bindingMethod, (Object)signUpChallengeApiResponse.bindingMethod)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.interval, (Object)signUpChallengeApiResponse.interval)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.challengeTargetLabel, (Object)signUpChallengeApiResponse.challengeTargetLabel)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.challengeChannel, (Object)signUpChallengeApiResponse.challengeChannel)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signupToken, (Object)signUpChallengeApiResponse.signupToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.error, (Object)signUpChallengeApiResponse.error)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.errorDescription, (Object)signUpChallengeApiResponse.errorDescription)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.details, signUpChallengeApiResponse.details)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.codeLength, (Object)signUpChallengeApiResponse.codeLength);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResponse$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

