/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.net;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.net.AbstractHttpClient;
import com.microsoft.identity.common.java.net.HttpClient;
import com.microsoft.identity.common.java.net.HttpRequest;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.HttpUrlConnectionFactory;
import com.microsoft.identity.common.java.net.IRetryPolicy;
import com.microsoft.identity.common.java.net.NoRetryPolicy;
import com.microsoft.identity.common.java.net.SSLSocketFactoryWrapper;
import com.microsoft.identity.common.java.net.StatusCodeAndExceptionRetry;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.telemetry.Telemetry;
import com.microsoft.identity.common.java.telemetry.events.HttpEndEvent;
import com.microsoft.identity.common.java.telemetry.events.HttpStartEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.Consumer;
import com.microsoft.identity.common.java.util.ported.Function;
import com.microsoft.identity.common.java.util.ported.Supplier;
import io.opentelemetry.api.trace.Span;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import lombok.NonNull;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class UrlConnectionHttpClient
extends AbstractHttpClient {
    private static final String TAG = UrlConnectionHttpClient.class.getSimpleName();
    protected static final int RETRY_TIME_WAITING_PERIOD_MSEC = 1000;
    protected static final int DEFAULT_CONNECT_TIME_OUT_MS = 30000;
    protected static final int DEFAULT_READ_TIME_OUT_MS = 30000;
    protected static final int DEFAULT_STREAM_BUFFER_SIZE_BYTE = 1024;
    private static final transient AtomicReference<UrlConnectionHttpClient> defaultReference = new AtomicReference<Object>(null);
    private final IRetryPolicy<HttpResponse> retryPolicy;
    private final int streamBufferSize;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;
    private final Supplier<Integer> connectTimeoutMsSupplier;
    private final Supplier<Integer> readTimeoutMsSupplier;
    private final SSLSocketFactoryWrapper sslSocketFactory;

    private UrlConnectionHttpClient(@Nullable IRetryPolicy<HttpResponse> retryPolicy, @Nullable Integer streamBufferSize, @Nullable Integer connectTimeoutMs, @Nullable Integer readTimeoutMs, @Nullable Supplier<Integer> connectTimeoutMsSupplier, @Nullable Supplier<Integer> readTimeoutMsSupplier, @Nullable List<String> supportedSslProtocols, @Nullable SSLContext sslContext) {
        this.retryPolicy = retryPolicy != null ? retryPolicy : new NoRetryPolicy();
        this.streamBufferSize = streamBufferSize != null ? streamBufferSize : 1024;
        this.connectTimeoutMs = connectTimeoutMs != null ? connectTimeoutMs : 30000;
        this.readTimeoutMs = readTimeoutMs != null ? readTimeoutMs : 30000;
        this.connectTimeoutMsSupplier = connectTimeoutMsSupplier;
        this.readTimeoutMsSupplier = readTimeoutMsSupplier;
        List<String> protocol = supportedSslProtocols != null ? supportedSslProtocols : SSLSocketFactoryWrapper.SUPPORTED_SSL_PROTOCOLS;
        this.sslSocketFactory = sslContext == null ? new SSLSocketFactoryWrapper((SSLSocketFactory)SSLSocketFactory.getDefault(), protocol) : new SSLSocketFactoryWrapper(sslContext.getSocketFactory(), protocol);
    }

    public static synchronized UrlConnectionHttpClient getDefaultInstance() {
        UrlConnectionHttpClient reference = defaultReference.get();
        if (reference == null) {
            defaultReference.compareAndSet(null, UrlConnectionHttpClient.builder().retryPolicy(StatusCodeAndExceptionRetry.builder().number(1).extensionFactor(2).isAcceptable(new Function<HttpResponse, Boolean>(){

                @Override
                public Boolean apply(HttpResponse response) {
                    return response != null && response.getStatusCode() < 400;
                }
            }).initialDelay(1000).isRetryable(new Function<HttpResponse, Boolean>(){

                @Override
                public Boolean apply(HttpResponse response) {
                    return response != null && UrlConnectionHttpClient.isRetryableError(response.getStatusCode());
                }
            }).isRetryableException(new Function<Exception, Boolean>(){

                @Override
                public Boolean apply(Exception e) {
                    return e instanceof SocketTimeoutException;
                }
            }).build()).build());
            reference = defaultReference.get();
        }
        return reference;
    }

    private static void recordHttpTelemetryEventStart(@NonNull String requestMethod, @NonNull URL requestUrl, String requestId) {
        if (requestMethod == null) {
            throw new NullPointerException("requestMethod is marked non-null but is null");
        }
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        Telemetry.emit(new HttpStartEvent().putMethod(requestMethod).putPath(requestUrl).putRequestIdHeader(requestId));
    }

    private static void recordHttpTelemetryEventEnd(HttpResponse response) {
        HttpEndEvent httpEndEvent = new HttpEndEvent();
        if (null != response) {
            httpEndEvent.putStatusCode(response.getStatusCode());
        }
        Telemetry.emit(httpEndEvent);
    }

    @Override
    public HttpResponse method(@NonNull HttpClient.HttpMethod httpMethod, @NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, byte[] requestContent) throws IOException {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        UrlConnectionHttpClient.recordHttpTelemetryEventStart(httpMethod.name(), requestUrl, requestHeaders.get("client-request-id"));
        final HttpRequest request = UrlConnectionHttpClient.constructHttpRequest(httpMethod, requestUrl, requestHeaders, requestContent);
        return this.retryPolicy.attempt(new Callable<HttpResponse>(){

            @Override
            public HttpResponse call() throws IOException {
                return UrlConnectionHttpClient.this.executeHttpSend(request, new Consumer<HttpResponse>(){

                    @Override
                    public void accept(HttpResponse httpResponse) {
                        UrlConnectionHttpClient.recordHttpTelemetryEventEnd(httpResponse);
                    }
                });
            }
        });
    }

    private static HttpRequest constructHttpRequest(@NonNull HttpClient.HttpMethod httpMethod, @NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, byte[] requestContent) {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        if (HttpClient.HttpMethod.PATCH == httpMethod) {
            httpMethod = HttpClient.HttpMethod.POST;
            requestHeaders = new HashMap<String, String>(requestHeaders);
            requestHeaders.put("X-HTTP-Method-Override", HttpClient.HttpMethod.PATCH.name());
        }
        return new HttpRequest(requestUrl, requestHeaders, httpMethod.name(), requestContent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) throws IOException {
        try {
            int charsRead;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, AuthenticationConstants.CHARSET_UTF8));
            char[] buffer = new char[this.streamBufferSize];
            StringBuilder stringBuilder = new StringBuilder();
            while ((charsRead = reader.read(buffer)) > -1) {
                stringBuilder.append(buffer, 0, charsRead);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            UrlConnectionHttpClient.safeCloseStream(inputStream);
        }
    }

    private static void safeCloseStream(Closeable stream) {
        String methodName = ":safeCloseStream";
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            Logger.error(TAG + ":safeCloseStream", "Encountered IO exception when trying to close the stream", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeHttpSend(HttpRequest request, Consumer<HttpResponse> completionCallback) throws IOException {
        HttpURLConnection urlConnection = this.setupConnection(request);
        UrlConnectionHttpClient.sendRequest(urlConnection, request.getRequestContent(), request.getRequestHeaders().get("Content-Type"));
        InputStream responseStream = null;
        HttpResponse response = null;
        try {
            try {
                responseStream = urlConnection.getInputStream();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw socketTimeoutException;
            }
            catch (IOException ioException) {
                responseStream = urlConnection.getErrorStream();
            }
            int statusCode = urlConnection.getResponseCode();
            Date date = new Date(urlConnection.getDate());
            String responseBody = responseStream == null ? "" : this.convertStreamToString(responseStream);
            response = new HttpResponse(date, statusCode, responseBody, urlConnection.getHeaderFields());
            Span span = SpanExtension.current();
            if (response.getHeaders() != null && response.getHeaders().size() > 0) {
                span.setAttribute(AttributeName.response_content_type.name(), response.getHeaderValue("Content-Type", 0));
                span.setAttribute(AttributeName.ccs_request_id.name(), response.getHeaderValue("xms-ccs-requestid", 0));
                span.setAttribute(AttributeName.ccs_request_sequence.name(), response.getHeaderValue("x-ms-srs", 0));
            }
            span.setAttribute(AttributeName.response_body_length.name(), (long)responseBody.length());
            span.setAttribute(AttributeName.http_status_code.name(), (long)response.getStatusCode());
            completionCallback.accept(response);
        }
        catch (Throwable throwable) {
            completionCallback.accept(response);
            UrlConnectionHttpClient.safeCloseStream(responseStream);
            throw throwable;
        }
        UrlConnectionHttpClient.safeCloseStream(responseStream);
        return response;
    }

    private HttpURLConnection setupConnection(HttpRequest request) throws IOException {
        String methodName = ":setupConnection";
        HttpURLConnection urlConnection = HttpUrlConnectionFactory.createHttpURLConnection(request.getRequestUrl());
        Set<Map.Entry<String, String>> headerEntries = request.getRequestHeaders().entrySet();
        for (Map.Entry<String, String> entry : headerEntries) {
            urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (urlConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslSocketFactory);
        } else {
            if ("https".equalsIgnoreCase(request.getRequestUrl().getProtocol())) {
                throw new IllegalStateException("Trying to initiate a HTTPS request, but didn't get back HttpsURLConnection");
            }
            if ("http".equalsIgnoreCase(request.getRequestUrl().getProtocol())) {
                Logger.warn(TAG + ":setupConnection", "Making a request for non-https URL.");
            } else {
                Logger.warn(TAG + ":setupConnection", "gets a request from an unexpected protocol: " + request.getRequestUrl().getProtocol());
            }
        }
        urlConnection.setRequestMethod(request.getRequestMethod());
        urlConnection.setConnectTimeout(this.getConnectTimeoutMs());
        urlConnection.setReadTimeout(this.getReadTimeoutMs());
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setUseCaches(true);
        urlConnection.setDoInput(true);
        return urlConnection;
    }

    private int getReadTimeoutMs() {
        return this.readTimeoutMsSupplier == null ? this.readTimeoutMs : this.readTimeoutMsSupplier.get();
    }

    private int getConnectTimeoutMs() {
        return this.connectTimeoutMsSupplier == null ? this.connectTimeoutMs : this.connectTimeoutMsSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendRequest(@NonNull HttpURLConnection connection, byte[] contentRequest, String requestContentType) throws IOException {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (contentRequest == null) {
            return;
        }
        connection.setDoOutput(true);
        if (!StringUtil.isNullOrEmpty(requestContentType)) {
            connection.setRequestProperty("Content-Type", requestContentType);
        }
        connection.setRequestProperty("Content-Length", String.valueOf(contentRequest.length));
        OutputStream out = null;
        try {
            out = connection.getOutputStream();
            out.write(contentRequest);
        }
        finally {
            UrlConnectionHttpClient.safeCloseStream(out);
        }
    }

    public static boolean isRetryableError(int statusCode) {
        return statusCode == 500 || statusCode == 504 || statusCode == 503;
    }

    public static UrlConnectionHttpClientBuilder builder() {
        return new UrlConnectionHttpClientBuilder();
    }

    public UrlConnectionHttpClient(IRetryPolicy<HttpResponse> retryPolicy, int streamBufferSize, int connectTimeoutMs, int readTimeoutMs, Supplier<Integer> connectTimeoutMsSupplier, Supplier<Integer> readTimeoutMsSupplier, SSLSocketFactoryWrapper sslSocketFactory) {
        this.retryPolicy = retryPolicy;
        this.streamBufferSize = streamBufferSize;
        this.connectTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.connectTimeoutMsSupplier = connectTimeoutMsSupplier;
        this.readTimeoutMsSupplier = readTimeoutMsSupplier;
        this.sslSocketFactory = sslSocketFactory;
    }

    public static class UrlConnectionHttpClientBuilder {
        private IRetryPolicy<HttpResponse> retryPolicy;
        private Integer streamBufferSize;
        private Integer connectTimeoutMs;
        private Integer readTimeoutMs;
        private Supplier<Integer> connectTimeoutMsSupplier;
        private Supplier<Integer> readTimeoutMsSupplier;
        private List<String> supportedSslProtocols;
        private SSLContext sslContext;

        UrlConnectionHttpClientBuilder() {
        }

        public UrlConnectionHttpClientBuilder retryPolicy(@Nullable IRetryPolicy<HttpResponse> retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public UrlConnectionHttpClientBuilder streamBufferSize(@Nullable Integer streamBufferSize) {
            this.streamBufferSize = streamBufferSize;
            return this;
        }

        public UrlConnectionHttpClientBuilder connectTimeoutMs(@Nullable Integer connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        public UrlConnectionHttpClientBuilder readTimeoutMs(@Nullable Integer readTimeoutMs) {
            this.readTimeoutMs = readTimeoutMs;
            return this;
        }

        public UrlConnectionHttpClientBuilder connectTimeoutMsSupplier(@Nullable Supplier<Integer> connectTimeoutMsSupplier) {
            this.connectTimeoutMsSupplier = connectTimeoutMsSupplier;
            return this;
        }

        public UrlConnectionHttpClientBuilder readTimeoutMsSupplier(@Nullable Supplier<Integer> readTimeoutMsSupplier) {
            this.readTimeoutMsSupplier = readTimeoutMsSupplier;
            return this;
        }

        public UrlConnectionHttpClientBuilder supportedSslProtocols(@Nullable List<String> supportedSslProtocols) {
            this.supportedSslProtocols = supportedSslProtocols;
            return this;
        }

        public UrlConnectionHttpClientBuilder sslContext(@Nullable SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public UrlConnectionHttpClient build() {
            return new UrlConnectionHttpClient(this.retryPolicy, this.streamBufferSize, this.connectTimeoutMs, this.readTimeoutMs, this.connectTimeoutMsSupplier, this.readTimeoutMsSupplier, this.supportedSslProtocols, this.sslContext);
        }

        public String toString() {
            return "UrlConnectionHttpClient.UrlConnectionHttpClientBuilder(retryPolicy=" + this.retryPolicy + ", streamBufferSize=" + this.streamBufferSize + ", connectTimeoutMs=" + this.connectTimeoutMs + ", readTimeoutMs=" + this.readTimeoutMs + ", connectTimeoutMsSupplier=" + this.connectTimeoutMsSupplier + ", readTimeoutMsSupplier=" + this.readTimeoutMsSupplier + ", supportedSslProtocols=" + this.supportedSslProtocols + ", sslContext=" + this.sslContext + ")";
        }
    }
}

